/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.data.AttributeType;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.odm.binning.CategoricBin;

public class CDSCategoricDiscretizeDataSource
extends CategoricDiscretizeDataSource {
    public CDSCategoricDiscretizeDataSource(Connection connection) throws Exception {
        super(connection);
        this.setLabels(false);
    }

    public CDSCategoricDiscretizeDataSource(Connection connection, boolean bl) throws Exception {
        super(connection);
        this.m_bAutoRun = bl;
        this.setLabels(false);
    }

    public boolean isLabels() {
        return true;
    }

    protected void createDataFrom2DSource() throws Exception {
        this.m_parentSource.m_helper.createDataFrom2DSource();
    }

    public void augmentDataSource(Connection connection, Hashtable hashtable, DiscretizationLDSDataSource discretizationLDSDataSource) throws Exception {
        this.m_lds = discretizationLDSDataSource;
        try {
            int n = this.getRowCount();
            Enumeration enumeration = hashtable.keys();
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.categorical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, this.m_lds.getMiningType(string));
                this.setDataType(n - 1, this.m_lds.getDataType(string));
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setBinBounds(n - 1, null);
                String string3 = this.m_lds.getComplexAttributeInfo(string);
                this.setComplexAttribute(n - 1, string3);
                if (string3 == null) {
                    vector.add(string);
                    hashtable2.put(string, new Integer(n - 1));
                    continue;
                }
                vector2.add(string);
                hashtable3.put(string, new Integer(n - 1));
            }
            this.addCategoricStats2D(connection, vector, hashtable2, null);
            this.addComplexStats(connection, vector2, hashtable3);
            hashtable2.clear();
            vector.clear();
            vector2.clear();
            hashtable3.clear();
        }
        catch (Exception exception) {
            if (CDSCategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    protected void addComplexStats(Connection connection, Vector vector, Hashtable hashtable) {
        if (this.m_parentSource != null) {
            this.m_parentSource.m_helper.addComplexStatsCat(connection, vector, hashtable);
        }
    }

    public String getSamplingViewDefinition() {
        if (this.getSampledInternallySampledCDS() == null) {
            return null;
        }
        return this.getSampledInternallySampledCDS().getCaseTable();
    }

    public void getTopNStats(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (this.m_parentSource != null) {
            this.m_parentSource.m_helper.getTopNStats(connection, vector, hashtable, string);
        }
    }

    void processTextTxSource(String string, String string2) throws Exception {
        TXColumn tXColumn = this.getSampledInputCDS().getTXColumn(string2);
        if (tXColumn == null) {
            return;
        }
        TXColumn tXColumn2 = this.getSampledOutputCDS().getTXColumn(string2);
        if (tXColumn2 == null) {
            return;
        }
        String string3 = tXColumn.getNameColumn();
        String string4 = tXColumn.getTxColumnCaseId();
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + tXColumn2.getDataLocation() + " AS SELECT " + (string3 == null ? "" : (DM4JStringUtils.isDoubleQuotedString(string3) ? string3 : DM4JStringUtils.addDoubleQuotes(string3)) + ",") + (DM4JStringUtils.isDoubleQuotedString(string4) ? string4 : DM4JStringUtils.addDoubleQuotes(string4)) + "," + "\n");
        String string5 = "\"" + string + "\"";
        stringBuffer.append(string5);
        stringBuffer.append("\n");
        stringBuffer.append(" FROM " + tXColumn.getDataLocation());
        tXColumn2.setSqlQuery(stringBuffer);
    }

    protected void processCatTxSource(String string, String string2, String string3, Vector vector) {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            return;
        }
        TXColumn tXColumn = this.getSampledInputCDS().getTXColumn(string3);
        if (tXColumn == null) {
            return;
        }
        TXColumn tXColumn2 = this.getSampledOutputCDS().getTXColumn(string3);
        if (tXColumn2 == null) {
            return;
        }
        String string4 = tXColumn.getNameColumn();
        String string5 = tXColumn.getTxColumnCaseId();
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + tXColumn2.getDataLocation() + " AS SELECT " + (DM4JStringUtils.isDoubleQuotedString(string4) ? string4 : DM4JStringUtils.addDoubleQuotes(string4)) + "," + (DM4JStringUtils.isDoubleQuotedString(string5) ? string5 : DM4JStringUtils.addDoubleQuotes(string5)) + "," + "\n");
        String string6 = "\"" + string2 + "\"";
        if (null == vector) {
            stringBuffer.append(string6);
        } else {
            stringBuffer.append(" DECODE (" + string6);
            stringBuffer.append("\n");
            for (int i = 0; i < vector.size(); ++i) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                for (int j = 0; j < categoricBin.values.size(); ++j) {
                    stringBuffer.append(",");
                    stringBuffer.append("'" + (String)categoricBin.values.elementAt(j) + "'" + "," + "'" + categoricBin.category + "'");
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append(",NULL,NULL,'" + ResourceUtilities.getUILabel("HISTOGRAM_OTHER") + "'" + ")" + string6);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" FROM " + tXColumn.getDataLocation());
        this.setViewDefinition(n, stringBuffer);
        tXColumn2.setSqlQuery(stringBuffer);
    }

    public Object getViewDefinition(String string) {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = null;
            try {
                if (this.getSampledInputCDS() != null && null == this.getSampledInputCDS().getCaseTable() && this.getSampledInputCDS().isSingleMetric()) {
                    int n = this.m_tableColumns.size();
                    for (int i = 0; i < n; ++i) {
                        String string2 = (String)this.m_tableColumns.elementAt(i);
                        String string3 = this.m_lds.getComplexAttributeInfo(string2);
                        if (string3 == null) continue;
                        int n2 = this.getAttributeRow(string2);
                        int n3 = this.m_parentSource.getAttributeRow(string2);
                        stringBuffer = n2 != -1 ? this.getViewDefinition(n2) : this.m_parentSource.getViewDefinition(n3);
                        break block4;
                    }
                    break block4;
                }
                StringBuffer stringBuffer2 = (StringBuffer)super.getViewDefinition(null);
                StringBuffer stringBuffer3 = new StringBuffer("CREATE VIEW " + string + "\n");
                stringBuffer3.append(stringBuffer2);
                stringBuffer3.append(this.getOriginalDataLocation());
                StringBuffer stringBuffer4 = new StringBuffer("CREATE VIEW ");
                ComplexDataStructure complexDataStructure = this.getOriginalOutputCDS();
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure.getCaseSchema()) ? complexDataStructure.getCaseSchema() : DM4JStringUtils.addDoubleQuotes(complexDataStructure.getCaseSchema()));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure.getCaseTable()) ? complexDataStructure.getCaseTable() : DM4JStringUtils.addDoubleQuotes(complexDataStructure.getCaseTable()));
                stringBuffer4.append("\n");
                stringBuffer4.append(stringBuffer2);
                ComplexDataStructure complexDataStructure2 = this.getOriginalInputCDS();
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure2.getCaseSchema()) ? complexDataStructure2.getCaseSchema() : DM4JStringUtils.addDoubleQuotes(complexDataStructure2.getCaseSchema()));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.isDoubleQuotedString(complexDataStructure2.getCaseTable()) ? complexDataStructure2.getCaseTable() : DM4JStringUtils.addDoubleQuotes(complexDataStructure2.getCaseTable()));
                this.getSampledOutputCDS().setSQLCaseQuery(stringBuffer3);
                this.getOriginalOutputCDS().setSQLCaseQuery(stringBuffer4);
                return this;
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer();
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatedoricStats(Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_isTransactional) {
                this.addCategoricStatsTX(connection, vector, hashtable, this.m_sDataLocation);
            } else {
                Vector<String> vector2 = new Vector<String>();
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                Vector<String> vector3 = new Vector<String>();
                Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    int n = this.getAttributeRow(string2);
                    String string3 = this.m_lds.getComplexAttributeInfo(string2);
                    if (string3 == null) {
                        vector2.add(string2);
                        hashtable2.put(string2, new Integer(n));
                        continue;
                    }
                    vector3.add(string2);
                    hashtable3.put(string2, new Integer(n));
                }
                this.addCategoricStats2D(connection, vector2, hashtable2, null);
                this.addComplexStats(connection, vector3, hashtable3);
                hashtable2.clear();
                vector2.clear();
                vector3.clear();
                hashtable3.clear();
            }
        }
        catch (Exception exception) {
            if (CDSCategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public int[] getCategoricAttributeFrequency(Connection connection, int n, String string, String string2) {
        String string3 = this.getComplexAttribute(n);
        if (string3 == null) {
            return super.getCategoricAttributeFrequency(connection, n, string, string2);
        }
        if (this.m_parentSource != null) {
            return this.m_parentSource.m_helper.getCategoricAttributeFrequency(connection, n);
        }
        return null;
    }

    protected void getTopNStats(Connection connection, int n, int n2) {
        String string = this.getComplexAttribute(n);
        if (string == null) {
            super.getTopNStats(connection, n, n2);
            return;
        }
        if (this.m_parentSource != null) {
            this.m_parentSource.m_helper.getTopNStats(connection, n, n2);
        }
    }

    protected Vector get2DDistinctValues(Connection connection, String string) {
        String string2 = this.m_lds.getComplexAttributeInfo(string);
        if (string2 == null) {
            return super.get2DDistinctValues(connection, string);
        }
        Vector vector = null;
        if (this.m_parentSource != null) {
            vector = this.m_parentSource.m_helper.get2DDistinctValues(connection, string);
        }
        return vector;
    }
}

