/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;

public class AllDBColumnsDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 3;
    private static final String ATTRIBUTE_SELECTED_COLUMN = "Select";
    private static final String ATTRIBUTE_NAME_COLUMN = "Name";
    private static final String ATTRIBUTE_TYPE_COLUMN = "Type";
    public static final int ATTRIBUTE_SELECTED_IDX = 0;
    public static final int ATTRIBUTE_NAME_IDX = 1;
    public static final int ATTRIBUTE_TYPE_IDX = 2;
    private String m_schemaName;
    private String m_tableName;
    private String m_attributeNameMapping;
    private String m_valueMapping;
    private boolean m_isTransactional = false;
    private String[] m_dataTypes;
    private boolean m_includeDataTypes;

    public AllDBColumnsDataSource(Connection connection, String string, String string2) {
        super(connection);
        this.m_schemaName = string;
        try {
            this.m_tableName = TransformsDirector.getReplacedString(string2, "'", "''");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AllDBColumnsDataSource(Connection connection, String string, String string2, String string3, String string4) {
        this(connection, string, string2);
        this.m_attributeNameMapping = string3;
        this.m_valueMapping = string4;
        this.m_isTransactional = true;
    }

    protected void createData() throws SQLException {
        if (this.m_isTransactional) {
            this.createDataFromTransactionalDBTable();
        } else {
            this.createDataFrom2DDBTable();
        }
    }

    private void createDataFrom2DDBTable() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SELECT column_name, data_type FROM all_tab_columns WHERE owner = '" + this.m_schemaName + "' and table_name = '" + this.m_tableName + "'");
        if (this.m_dataTypes != null && this.m_dataTypes.length != 0) {
            if (this.m_includeDataTypes) {
                stringBuffer.append("and DATA_TYPE in (" + this.addDataTypes() + ")");
            } else {
                stringBuffer.append("and DATA_TYPE not in (" + this.addDataTypes() + ")");
            }
        }
        stringBuffer.append(" order by column_name");
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            int n = 1;
            int n2 = 0;
            while (resultSet.next()) {
                String string = resultSet.getString("column_name");
                String string2 = resultSet.getString("data_type");
                this.addRows(n - 1, 1);
                this.setData(1, n - 1, string);
                this.setData(2, n - 1, string2);
                ++n;
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createDataFromTransactionalDBTable() throws SQLException {
        String string = "SELECT \"" + this.m_valueMapping + "\" " + "FROM \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
        String string2 = "SELECT DISTINCT \"" + this.m_attributeNameMapping + "\" " + "FROM \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string3 = resultSetMetaData.getColumnTypeName(1);
            resultSet.close();
            resultSet = null;
            int n = 0;
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                this.addRows(n, 1);
                this.setData(1, n, string4);
                this.setData(2, n++, string3);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 3);
        Object[] objectArray = new String[]{ATTRIBUTE_SELECTED_COLUMN, ATTRIBUTE_NAME_COLUMN, ATTRIBUTE_TYPE_COLUMN};
        return new ArrayOneDModel(objectArray);
    }

    public void setAcceptableDataTypes(String[] stringArray, boolean bl) {
        if (stringArray != null) {
            this.m_dataTypes = stringArray;
            this.m_includeDataTypes = bl;
        }
    }

    private String addDataTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_dataTypes.length; ++i) {
            stringBuffer.append("'" + this.m_dataTypes[i] + "',");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

