/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.datamining.MiningObject;
import javax.datamining.resource.Connection;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectDetailLoadedListener;

public class LoadObjectDetailWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultMutableTreeNode m_treeNode;
    private int m_tabIndex = 0;

    public LoadObjectDetailWorker(WorkerThreadManager workerThreadManager, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        super(workerThreadManager);
        this.m_treeNode = defaultMutableTreeNode;
        this.m_tabIndex = n;
    }

    public void addObjectDetailLoadedListener(ObjectDetailLoadedListener objectDetailLoadedListener) {
        this.listenerList.add(ObjectDetailLoadedListener.class, objectDetailLoadedListener);
    }

    public void removeObjectDetailLoadedListener(ObjectDetailLoadedListener objectDetailLoadedListener) {
        this.listenerList.remove(ObjectDetailLoadedListener.class, objectDetailLoadedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object construct() {
        Object object;
        Connection connection = null;
        MiningObject miningObject = null;
        try {
            Object object2;
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(4);
            }
            ++s_thread;
            try {
                connection = DM4JConnectionManager.getConnection();
            }
            catch (Exception exception) {
                object2 = BrowserUtils.getBundleInstance();
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                String string = ((ResourceBundle)object2).getString("DMS_CONNECTION_NOCREATE");
                String string2 = ((ResourceBundle)object2).getString("APPLICATION_TITLE");
                JOptionPane.showMessageDialog(browserFrame, string, string2, 0);
                exception.printStackTrace();
            }
            object = (LeafNodeData)this.m_treeNode.getUserObject();
            object2 = ((NodeData)object).getNodeType();
            if (!(((String)object2).equals("TASKS") || ((String)object2).equals("TABLE") || ((String)object2).equals("VIEW"))) {
                miningObject = LeafNodeData.loadOdmObject(connection, this.m_treeNode);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (miningObject == null && connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        object = new ArrayList<DefaultMutableTreeNode>();
        ((ArrayList)object).add(this.m_treeNode);
        ((ArrayList)object).add(new Integer(this.m_tabIndex));
        ((ArrayList)object).add(connection);
        return object;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(4);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ObjectDetailLoadedListener.class) continue;
            ((ObjectDetailLoadedListener)objectArray[i + 1]).objectDetailLoaded(new EventObject(this.getValue()));
        }
    }
}

