/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.worker;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainRankTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ExplainOutputLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dss.graph.Graph;

public class LoadExplainOutputWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private OraMiningExplainResult m_mar;
    private String m_sortColumn;
    private boolean m_ascending;
    private ExplainRankTableModel m_tableModel = null;
    private Graph m_histogram = null;

    LoadExplainOutputWorker(WorkerThreadManager workerThreadManager, OraMiningExplainResult oraMiningExplainResult, String string, boolean bl, Graph graph) {
        super(workerThreadManager);
        this.m_mar = oraMiningExplainResult;
        this.m_sortColumn = string;
        this.m_ascending = bl;
        this.m_histogram = graph;
    }

    public void addExplainOutputLoadedListener(ExplainOutputLoadedListener explainOutputLoadedListener) {
        this.listenerList.add(ExplainOutputLoadedListener.class, explainOutputLoadedListener);
    }

    public void removeExplainOutputLoadedListener(ExplainOutputLoadedListener explainOutputLoadedListener) {
        this.listenerList.remove(ExplainOutputLoadedListener.class, explainOutputLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new ExplainRankTableModel();
            this.m_tableModel.load(this.m_mar, this.m_sortColumn, this.m_ascending, this.m_histogram);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ExplainOutputLoadedListener.class) continue;
            ((ExplainOutputLoadedListener)objectArray[i + 1]).tableLoaded(new EventObject(this.getValue()));
        }
    }
}

