/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.datamining.NamedObject;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.datamining.supervised.classification.ClassificationTestTask;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class SummarizedConfusionMatrixTableModel
extends Dm4jSortableTwoDModel {
    private boolean m_bShowFloats = true;
    private ClassificationTestMetricsViewer m_parent;
    private String m_confusionMatrix = null;
    private String m_costMatrixName = null;
    private double m_avgAccuracy = 0.0;
    private double m_totalCosts = 0.0;
    private HashMap m_targetMap = new HashMap();
    private static String GET_CM_STATS_WITH_COST = "select a.actual_target_value target_value,   a.recall_total, a.recall_cost, a.recall_cost/GREATEST(0.0001, d.recall_total_cost)*100 recall_cost_ratio from   (select a.actual_target_value, sum(a.value*b.cost) recall_cost, sum(a.value) recall_total      from {0} a , {1} b       where a.actual_target_value = b.actual_target_value      and a.predicted_target_value = b.predicted_target_value      group by a.actual_target_value) a   ,   (select sum(a.value*b.cost) recall_total_cost      from {0} a , {1} b      where a.actual_target_value = b.actual_target_value      and a.predicted_target_value = b.predicted_target_value) d order by a.actual_target_value";
    private static String GET_CM_STATS_WITHOUT_COST = "select a.actual_target_value as target_value, NULL as recall_cost, NULL as recall_cost_ratio, sum(a.value) recall_total  from {0} a group by actual_target_value order by a.actual_target_value";
    private static String GET_CM_RECALL = "select a.actual_target_value target_value,   c.value/GREATEST(0.0001, a.recall_total)*100 recall from   (select a.actual_target_value, sum(a.value) recall_total      from {0} a      group by a.actual_target_value) a   ,   (select actual_target_value, value      from {0}      where actual_target_value = predicted_target_value) c   where a.actual_target_value = c.actual_target_value order by a.actual_target_value";

    public SummarizedConfusionMatrixTableModel(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        this.m_parent = classificationTestMetricsViewer;
    }

    public double getAvgAccuracy() {
        return this.m_avgAccuracy / 100.0;
    }

    public double getTotalCosts() {
        return this.m_totalCosts;
    }

    public void load(Object object) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        this.m_confusionMatrix = this.m_parent.getConfusionMatrixName();
        String string = this.m_parent.getTaskName();
        javax.datamining.resource.Connection connection = null;
        try {
            connection = DM4JConnectionManager.getConnection();
            object7 = null;
            object7 = (ClassificationTestTask)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string), NamedObject.task);
            this.m_costMatrixName = object7.getCostMatrixName();
            if (this.m_costMatrixName == null) {
                object6 = this.m_parent.getClassificationTestMetrics().getModelName();
                object5 = connection.retrieveObject(((String)object6).toUpperCase(), NamedObject.model);
                object4 = (ClassificationModel)object5;
                object3 = (ClassificationSettings)object4.getBuildSettings();
                this.m_costMatrixName = object3.getCostMatrixName();
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        object7 = this.m_parent.getClassificationTestMetrics().getConfusionMatrix();
        object6 = object7.getCategories();
        object5 = object6.iterator();
        object4 = new Double(0.0);
        object3 = new Integer(0);
        int n = 0;
        while (object5.hasNext()) {
            object2 = (Object[])object5.next();
            this.setData(0, n, object2);
            this.setData(1, n, object3);
            this.setData(2, n, object4);
            if (this.m_costMatrixName != null) {
                this.setData(3, n, object4);
                this.setData(4, n, object4);
            }
            this.m_targetMap.put(object2, new Integer(n));
            ++n;
        }
        String string2 = null;
        if (this.m_costMatrixName != null) {
            object2 = new Object[]{this.m_confusionMatrix, this.m_costMatrixName};
            string2 = MessageFormat.format(GET_CM_STATS_WITH_COST, (Object[])object2);
        } else {
            object2 = new Object[]{this.m_confusionMatrix};
            string2 = MessageFormat.format(GET_CM_STATS_WITHOUT_COST, (Object[])object2);
        }
        object2 = null;
        ResultSet resultSet = null;
        Connection connection2 = null;
        int n2 = 0;
        int n3 = 0;
        try {
            double d;
            Object[] objectArray;
            connection2 = DM4JConnectionManager.getDbConnection();
            object2 = connection2.prepareStatement(string2);
            resultSet = object2.executeQuery();
            while (resultSet.next()) {
                objectArray = resultSet.getString("target_value");
                n2 = (Integer)this.m_targetMap.get(objectArray);
                int n4 = resultSet.getInt("recall_total");
                double d2 = resultSet.getDouble("recall_cost");
                this.m_totalCosts += d2;
                d = resultSet.getDouble("recall_cost_ratio");
                this.setData(1, n2, new Integer(n4));
                if (this.m_costMatrixName != null) {
                    this.setData(3, n2, new Double(d2));
                    this.setData(4, n2, new Double(d));
                }
                ++n3;
            }
            object2.close();
            objectArray = new Object[]{this.m_confusionMatrix};
            string2 = MessageFormat.format(GET_CM_RECALL, objectArray);
            object2 = connection2.prepareStatement(string2);
            resultSet = object2.executeQuery();
            double d3 = 0.0;
            while (resultSet.next()) {
                String string3 = resultSet.getString("target_value");
                d = resultSet.getDouble("recall");
                d3 += d;
                n2 = (Integer)this.m_targetMap.get(string3);
                this.setData(2, n2, new Double(d));
            }
            if (n3 > 0) {
                this.m_avgAccuracy = d3 / (double)n3;
            }
        }
        catch (Exception exception) {
            try {
                if (object2 != null) {
                    object2.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                if (connection2 != null) {
                    connection2.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
    }

    public String getConfusionMatrixName() {
        return this.m_confusionMatrix;
    }

    public String getCostMatrixName() {
        return this.m_costMatrixName;
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }
}

