/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.text.Collator;
import java.text.NumberFormat;
import java.util.Collection;
import javax.datamining.supervised.classification.ConfusionMatrix;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.SummarizedConfusionMatrixTableModel;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class SummarizedConfusionMatrixTable
extends Dm4jSpreadTable {
    public static final int TARGET_COL = 0;
    public static final int RECALL_TOTAL_COL = 1;
    public static final int RECALL_COL = 2;
    public static final int RECALL_COST_COL = 3;
    public static final int RECALL_COST_RATIO_COL = 4;
    private boolean m_bShowFloats = true;
    private boolean m_bShowCost = false;
    private ClassificationTestMetricsViewer m_parent;
    private SummarizedConfusionMatrixTableModel cmTableModel = null;
    private String[] m_colNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_TARGET"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_TOTAL_ACTUALS"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_CORRECT_PREDICTION"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_COST_INCORRECT"), DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_COST_RATIO_INCORRECT")};
    private int[] m_colWidthsWithCost = new int[]{20, 20, 20, 20, 20};
    private int[] m_colWidthsWithoutCost = new int[]{33, 33, 34, 0, 0};

    public SummarizedConfusionMatrixTable(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        super(classificationTestMetricsViewer.getClassificationTestMetrics().getConfusionMatrix());
        this.m_parent = classificationTestMetricsViewer;
        this.setColumnNames(this.m_colNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(boolean bl) throws Exception {
        ConfusionMatrix confusionMatrix = (ConfusionMatrix)this.getDataItem();
        if (null == confusionMatrix) {
            throw new Exception("Cannot load data.");
        }
        this.m_bShowCost = bl;
        this.setVerticalSeparatorsVisible(true);
        ConfusionMatrix confusionMatrix2 = confusionMatrix;
        Collection collection = confusionMatrix2.getCategories();
        int n = collection.size();
        this.cmTableModel = new SummarizedConfusionMatrixTableModel(this.m_parent);
        this.setColumnWidths(null, false);
        this.setModels((TwoDModel)this.cmTableModel, this.getColModel(), null);
        this.cmTableModel.addRows(0, n);
        this.cmTableModel.addColumns(0, this.m_colNames.length);
        this.cmTableModel.setShowFloats(this.m_bShowFloats);
        this.cmTableModel.load((Object)this);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 2, 0);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
        this.getGrid().setColumnPainter(1, (Painter)dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(2, (Painter)dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(3, (Painter)dM4JTruncatingNumberFormatPainter);
        this.getGrid().setColumnPainter(4, (Painter)dM4JTruncatingNumberFormatPainter);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        header.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.cmTableModel));
        this.cmTableModel.setColumnComparator(0, (Comparator)new StringComparator(Collator.getInstance()));
        this.cmTableModel.setColumnComparator(1, NumberComparator.getComparator());
        this.cmTableModel.setColumnComparator(2, NumberComparator.getComparator());
        this.cmTableModel.setColumnComparator(3, NumberComparator.getComparator());
        this.cmTableModel.setColumnComparator(4, NumberComparator.getComparator());
        this.showCost(this.m_bShowCost);
    }

    public SummarizedConfusionMatrixTableModel getSummarizedConfusionMatrixTableModel() {
        return this.cmTableModel;
    }

    public void showCost(boolean bl) {
        try {
            this.setColumnVisible(3, bl);
            this.setColumnVisible(4, bl);
            this.setColumnWidths(bl ? this.m_colWidthsWithCost : this.m_colWidthsWithoutCost, true);
            this.m_bShowCost = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }
}

