/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Locale;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.Lift;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.LiftResultTable;
import oracle.dss.graph.Graph;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class LiftPanel
extends GriddedPanel {
    JLabel m_name = new JLabel();
    JLabel m_target = new JLabel();
    ButtonGroup m_groupChart = new ButtonGroup();
    JRadioButton m_optChartCumLift = new JRadioButton();
    JRadioButton m_optChartCumTarget = new JRadioButton();
    LiftResultTable m_liftTable = null;
    ClassificationTestMetricsViewer m_parent = null;
    Graph m_chart = null;

    public LiftPanel(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        try {
            this.m_parent = classificationTestMetricsViewer;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "CLASS_TESTMETRICS_LIFT";
    }

    private void jbInit() throws Exception {
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(0);
        this.m_chart = new Graph((ErrorHandler)defaultErrorHandler);
        int n = 1;
        GriddedPanel griddedPanel = new GriddedPanel();
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("LIFT_TASK_POSITIVE_TARGET"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("LIFT_TASK_POSITIVE_TARGET"));
        griddedPanel.addComponent(jLabel2, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_target, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("LIFT_RESULT_CHART"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        this.m_optChartCumLift.setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_LIFT"));
        this.m_optChartCumLift.setMnemonic(DM4JResourceUtilities.getUIMnemonic("LIFT_RESULT_CUM_LIFT"));
        this.m_optChartCumTarget.setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_TARGET"));
        this.m_optChartCumTarget.setMnemonic(DM4JResourceUtilities.getUIMnemonic("LIFT_RESULT_CUM_TARGET"));
        this.m_groupChart.add(this.m_optChartCumLift);
        this.m_optChartCumLift.setSelected(true);
        this.m_groupChart.add(this.m_optChartCumTarget);
        jPanel.add(this.m_optChartCumLift);
        jPanel.add(this.m_optChartCumTarget);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportChartDialog exportChartDialog = new ExportChartDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(LiftPanel.this.m_chart);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)jButton, "East");
        griddedPanel.addFilledComponent(jPanel2, MIDINDENTEDLABELITEMINSETS, n++, 1, 2, 1, 1);
        this.m_optChartCumLift.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiftPanel.this.displayChart();
            }
        });
        this.m_optChartCumTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiftPanel.this.displayChart();
            }
        });
        this.m_chart.setLocale(Locale.getDefault());
        this.m_chart.setGraphType(31);
        this.m_chart.setEnabled(false);
        this.m_chart.setAutoLayout(2);
        this.m_chart.getPFJ().setDisplay(this.m_chart.getPFJ().getLegendArea(), false);
        this.m_chart.setScrollbarPresenceGroups(1);
        this.m_chart.setImageSize(new Dimension(300, 300));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.setPreferredSize(this.m_chart.getImageSize());
        jPanel3.add((Component)this.m_chart, gridBagConstraints);
        griddedPanel.addFilledComponent(jPanel3, MIDLABELITEMINSETS, n, 1, 2, 2, 1);
        n += 2;
        GriddedPanel griddedPanel2 = new GriddedPanel();
        n = 1;
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("LIFT_RESULT_CHART_TABLE"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("LIFT_RESULT_CHART_TABLE"));
        griddedPanel2.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 1, 1, 1, 16);
        JScrollPane jScrollPane = new JScrollPane();
        this.m_liftTable = new LiftResultTable(this.m_parent);
        jLabel.setLabelFor((Component)((Object)this.m_liftTable));
        jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        griddedPanel2.addAnchoredComponent(jButton, new Insets(10, 5, 0, 10), n++, 2, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(LiftPanel.this.m_liftTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jScrollPane.getViewport().add((Component)((Object)this.m_liftTable));
        jScrollPane.setPreferredSize(null);
        griddedPanel2.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 1, 2, 2, 1);
        JSplitPane jSplitPane = new JSplitPane(0, griddedPanel, griddedPanel2);
        jSplitPane.setResizeWeight(0.8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jSplitPane, gridBagConstraints);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.m_liftTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_liftTable);
    }

    private void runTimePanelLoad() throws Exception {
        this.m_liftTable.load();
        String string = this.m_parent.getTargetValue();
        this.m_target.setText(string == null ? DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE") : string);
        this.displayChart();
        ClassificationTestMetrics classificationTestMetrics = this.m_parent.getClassificationTestMetrics();
        Lift lift = classificationTestMetrics.getLift();
        String string2 = this.m_parent.getLiftName();
        this.m_name.setText(string2);
        Date date = classificationTestMetrics.getCreationDate();
    }

    void displayChart() {
        try {
            Object[] objectArray;
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            ClassificationTestMetrics classificationTestMetrics = this.m_parent.getClassificationTestMetrics();
            Lift lift = classificationTestMetrics.getLift();
            this.m_chart.getO1Title().setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_QUANTILES"));
            if (this.m_optChartCumLift.isSelected()) {
                this.m_chart.getTitle().setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_LIFT_CHART"));
                this.m_chart.getY1Title().setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_LIFT"));
            } else {
                this.m_chart.getTitle().setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_TARGET_CHART"));
                this.m_chart.getY1Title().setText(DM4JResourceUtilities.getUIString("LIFT_RESULT_CUM_TARGET"));
            }
            boolean bl = this.m_optChartCumTarget.isSelected();
            int n = lift.getNumberOfQuantiles();
            long l = this.getTotalPositiveCases();
            this.m_chart.setDisplayGroupsLimit(bl ? n + 1 : n);
            this.m_chart.getX1Axis().setAxisMaxAutoScaled(false);
            this.m_chart.getX1Axis().setAxisMaxValue(bl ? (double)(n + 1) : (double)n);
            if (bl) {
                this.m_chart.getY1Axis().setAxisMinValue(0.0);
                this.m_chart.getY1Axis().setAxisMaxValue(1.0);
            } else {
                this.m_chart.getY1Axis().setAxisMinValue(1.0);
                objectArray = lift.getCumulativeLift(1);
                this.m_chart.getY1Axis().setAxisMaxValue(objectArray.doubleValue());
            }
            this.m_chart.getY1Axis().setAxisMinAutoScaled(false);
            objectArray = new Object[]{DM4JResourceUtilities.getUIString("LIFT_RESULT_LIFT_LABEL")};
            Object[] objectArray2 = new Object[bl ? n + 1 : n];
            Object[][] objectArray3 = new Object[bl ? n + 1 : n][1];
            for (int i = 0; i < n; ++i) {
                float f;
                if (bl) {
                    f = lift.getCumulativePositiveCases(i + 1);
                    if (i == 0) {
                        objectArray3[i][0] = new Float(0.0f);
                        objectArray2[i] = Integer.toString(i);
                    }
                    f /= (float)l;
                } else {
                    Double d = lift.getCumulativeLift(i + 1);
                    f = d.floatValue();
                }
                objectArray3[bl ? i + 1 : i][0] = new Float(f);
                objectArray2[bl ? i + 1 : i] = Integer.toString(i + 1);
            }
            this.m_chart.setDataSource((DataSource)new LocalXMLDataSource(objectArray2, objectArray, objectArray3));
            this.m_chart.setDataRowShownAsASeries(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTotalPositiveCases() {
        String string = this.m_parent.getLiftName();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        long l = 0L;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string2 = "SELECT SUM(QUANTILE_TARGET_COUNT) FROM " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            l = 1L;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return l;
    }
}

