/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.datamining.supervised.classification.ConfusionMatrix;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ConfusionMatrixTable;
import oracle.dmt.dm4j.browser.viewer.testMetrics.SummarizedConfusionMatrixTableModel;

public class ConfusionMatrixTableModel
extends Dm4jSortableTwoDModel {
    public int RECALL_TOTAL_ROW;
    public int RECALL_ROW;
    public int RECALL_COST_ROW;
    public int PRECISION_TOTAL_ROW;
    public int PRECISION_ROW;
    public int PRECISION_COST_ROW;
    private boolean m_bShowFloats = true;
    private ClassificationTestMetricsViewer m_parent;
    private SummarizedConfusionMatrixTableModel m_scmModel;
    private static String GET_CM_STATS_WITH_COST = "select b.predicted_target_value target_value,   b.precision_total, b.precision_cost from   (select a.predicted_target_value, sum(a.value*b.cost) precision_cost, sum(a.value) precision_total      from {0} a , {1} b      where a.actual_target_value = b.actual_target_value      and a.predicted_target_value = b.predicted_target_value      group by a.predicted_target_value) b order by b.predicted_target_value";
    private static String GET_CM_STATS_WITHOUT_COST = "select a.predicted_target_value as target_value, NULL as precision_cost, sum(a.value) precision_total  from {0} a group by predicted_target_value order by a.predicted_target_value";

    public ConfusionMatrixTableModel(ClassificationTestMetricsViewer classificationTestMetricsViewer, SummarizedConfusionMatrixTableModel summarizedConfusionMatrixTableModel) {
        this.m_parent = classificationTestMetricsViewer;
        this.m_scmModel = summarizedConfusionMatrixTableModel;
    }

    public int getRecallTotalColIdx() {
        return this.RECALL_TOTAL_ROW;
    }

    public int getRecallColIdx() {
        return this.RECALL_ROW;
    }

    public int getRecallCostColIdx() {
        return this.RECALL_COST_ROW;
    }

    public int getPrecisionTotalRowIdx() {
        return this.PRECISION_TOTAL_ROW;
    }

    public int getPrecisionRowIdx() {
        return this.PRECISION_ROW;
    }

    public int getPrecisionCostRowIdx() {
        return this.PRECISION_COST_ROW;
    }

    public void load(Object object) {
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Integer n;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = this.m_scmModel.getCostMatrixName();
        String string2 = this.m_scmModel.getConfusionMatrixName();
        ConfusionMatrixTable confusionMatrixTable = (ConfusionMatrixTable)((Object)object);
        ConfusionMatrix confusionMatrix = this.m_parent.getClassificationTestMetrics().getConfusionMatrix();
        Collection collection = confusionMatrix.getCategories();
        int n2 = collection.size();
        this.addRows(0, n2 + 3);
        this.addColumns(0, n2 + 3);
        Object[] objectArray = new String[n2 + 3];
        this.RECALL_TOTAL_ROW = n2;
        this.RECALL_ROW = n2 + 1;
        this.RECALL_COST_ROW = n2 + 2;
        this.PRECISION_TOTAL_ROW = n2;
        this.PRECISION_ROW = n2 + 1;
        this.PRECISION_COST_ROW = n2 + 2;
        String[] stringArray = new String[n2];
        Double d = new Double(0.0);
        Integer n3 = new Integer(0);
        Iterator iterator = collection.iterator();
        int n4 = 0;
        int n5 = 0;
        n5 = 0;
        while (iterator.hasNext()) {
            String string3;
            n = (Integer)this.m_scmModel.getData(1, n5);
            serializable = (Double)this.m_scmModel.getData(2, n5);
            object4 = (Double)this.m_scmModel.getData(3, n5);
            this.setData(this.RECALL_TOTAL_ROW, n5, n);
            this.setData(this.RECALL_ROW, n5, serializable);
            n4 += n.intValue();
            if (string != null) {
                this.setData(this.RECALL_COST_ROW, n5, object4);
            }
            this.setData(n5, this.PRECISION_TOTAL_ROW, n3);
            this.setData(n5, this.PRECISION_ROW, d);
            if (string != null) {
                this.setData(n5, this.PRECISION_COST_ROW, d);
            }
            stringArray[n5] = string3 = (String)iterator.next();
            hashMap.put(string3, new Integer(n5));
            ++n5;
        }
        this.setData(this.RECALL_TOTAL_ROW, this.PRECISION_TOTAL_ROW, new Integer(n4));
        System.arraycopy(stringArray, 0, objectArray, 0, n2);
        objectArray[this.PRECISION_TOTAL_ROW] = DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_TOTAL");
        objectArray[this.PRECISION_ROW] = DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_CORRECT");
        objectArray[this.PRECISION_COST_ROW] = DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_COST");
        n = new ArrayOneDModel(objectArray);
        confusionMatrixTable.setModels((TwoDModel)this, (ArrayOneDModel)n, (ArrayOneDModel)n);
        serializable = DM4JNumericFormat.getInstance(true, 2, 0);
        object4 = new DM4JTruncatingNumberFormatPainter((NumberFormat)serializable);
        confusionMatrixTable.getGrid().setDefaultPainter((Painter)object4);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                try {
                    object3 = confusionMatrix.getValue(stringArray[i], stringArray[j]);
                    this.setData(j, i, object3);
                    continue;
                }
                catch (Exception exception) {
                    this.setData(j, i, DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
            }
        }
        String string4 = null;
        if (string != null) {
            object2 = new Object[]{string2, string};
            string4 = MessageFormat.format(GET_CM_STATS_WITH_COST, (Object[])object2);
        } else {
            object2 = new Object[]{string2};
            string4 = MessageFormat.format(GET_CM_STATS_WITHOUT_COST, (Object[])object2);
        }
        object2 = null;
        object3 = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            object2 = connection.prepareStatement(string4);
            object3 = object2.executeQuery();
            while (object3.next()) {
                String string5 = object3.getString("target_value");
                int n6 = object3.getInt("precision_total");
                double d2 = object3.getDouble("precision_cost");
                int n7 = (Integer)hashMap.get(string5);
                this.setData(n7, this.PRECISION_TOTAL_ROW, new Integer(n6));
                if (string == null) continue;
                this.setData(n7, this.PRECISION_COST_ROW, new Double(d2));
            }
            for (int i = 0; i < n2; ++i) {
                Double d3 = (Double)this.getData(i, i);
                Integer n8 = (Integer)this.getData(i, this.PRECISION_TOTAL_ROW);
                double d4 = 0.0;
                if (n8.doubleValue() != 0.0) {
                    d4 = d3 / (double)n8.intValue() * 100.0;
                }
                this.setData(i, this.PRECISION_ROW, new Double(d4));
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }
}

