/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.testMetrics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ConfusionMatrixTable;
import oracle.dmt.dm4j.browser.viewer.testMetrics.SummarizedConfusionMatrixTable;

public class ConfusionMatrixPanel
extends GriddedPanel {
    JLabel m_name = new JLabel();
    JLabel m_overallAccuracy = new JLabel();
    JLabel m_averageAccuracy = new JLabel();
    JLabel m_totalCost = new JLabel();
    JLabel m_rootMeanSquareError = new JLabel();
    JCheckBox m_mpShowCost = null;
    JCheckBox m_cmShowCost = null;
    JButton m_detailButton = new JButton();
    boolean m_showConfusionMatrix = true;
    SummarizedConfusionMatrixTable m_scmTable = null;
    GriddedPanel m_smPanel = new GriddedPanel();
    GriddedPanel m_cmPanel = null;
    JSplitPane m_splitPanel = null;
    ConfusionMatrixTable m_cmTable = null;
    ClassificationTestMetricsViewer m_parent = null;

    public ConfusionMatrixPanel(ClassificationTestMetricsViewer classificationTestMetricsViewer) {
        try {
            this.m_parent = classificationTestMetricsViewer;
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "CLASS_TESTMETRICS_CM";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.m_smPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.m_smPanel.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_AVERAGE_ACCURACY"));
        this.m_smPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.m_smPanel.addComponent(this.m_averageAccuracy, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_OVERALL_ACCURACY"));
        this.m_smPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.m_smPanel.addComponent(this.m_overallAccuracy, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_TOTAL_COST"));
        this.m_smPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.m_smPanel.addComponent(this.m_totalCost, MIDVALUEITEMINSETS, n, 2);
        n += 2;
        JScrollPane jScrollPane = new JScrollPane();
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_SUMMARIZED_CONFUSION_MATRIX"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TEST_RESULT_SUMMARIZED_CONFUSION_MATRIX"));
        jLabel2.setLabelFor((Component)((Object)this.m_scmTable));
        this.m_scmTable = new SummarizedConfusionMatrixTable(this.m_parent);
        this.m_mpShowCost = new JCheckBox(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_SHOW_MP_DETAIL"));
        this.m_mpShowCost.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CM_SHOW_MP_DETAIL"));
        this.m_mpShowCost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfusionMatrixPanel.this.chkMPShowCost_actionPerformed();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jLabel2);
        jPanel.add(this.m_mpShowCost);
        this.m_smPanel.addAnchoredComponent(jPanel, TOPLABELITEMINSETS, n, 1, 16);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_smPanel.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 3, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ConfusionMatrixPanel.this.m_scmTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jScrollPane.getViewport().add((Component)((Object)this.m_scmTable));
        jScrollPane.setMinimumSize(new Dimension(400, 100));
        jScrollPane.setPreferredSize(new Dimension(400, 140));
        this.m_smPanel.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 1, 3, 3, 1);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        this.m_scmTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_scmTable);
        this.m_detailButton.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_SHOW_DETAIL"));
        this.m_detailButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CM_SHOW_DETAIL"));
        this.m_smPanel.addAnchoredComponent(this.m_detailButton, new Insets(10, 0, 10, 10), n += 3, 3, 1, 1, 14);
        this.addFilledComponent(this.m_smPanel, new Insets(0, 0, 0, 0), 0, 0, 2, 2, 1);
        final int n2 = n + 2;
        this.m_detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConfusionMatrixPanel.this.showConfusionMatrixTable(n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void chkMPShowCost_actionPerformed() {
        boolean bl = this.m_mpShowCost.isSelected();
        this.m_scmTable.showCost(bl);
    }

    private void chkCMShowCost_actionPerformed() {
        boolean bl = this.m_cmShowCost.isSelected();
        this.m_cmTable.showCost(bl);
    }

    private void showConfusionMatrixTable(int n) throws Exception {
        if (this.m_showConfusionMatrix) {
            if (this.m_cmPanel == null) {
                this.m_cmPanel = new GriddedPanel();
                JScrollPane jScrollPane = new JScrollPane();
                JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_CONFUSION_MATRIX"));
                jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TEST_RESULT_CONFUSION_MATRIX"));
                jLabel.setLabelFor((Component)((Object)this.m_cmTable));
                JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("TEST_RESULT_CONFUSION_MATRIX_NOTE"));
                this.m_cmTable = new ConfusionMatrixTable(this.m_parent, this.m_scmTable.getSummarizedConfusionMatrixTableModel());
                this.m_cmShowCost = new JCheckBox(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_SHOW_CM_DETAIL"));
                this.m_cmShowCost.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CM_SHOW_CM_DETAIL"));
                this.m_cmShowCost.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConfusionMatrixPanel.this.chkCMShowCost_actionPerformed();
                    }
                });
                this.m_cmShowCost.setSelected(false);
                JPanel jPanel = new JPanel(new FlowLayout(2));
                jPanel.add(jLabel);
                jPanel.add(jLabel2);
                jPanel.add(this.m_cmShowCost);
                this.m_cmPanel.addAnchoredComponent(jPanel, TOPLABELITEMINSETS, n, 1, 16);
                JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
                jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
                this.m_cmPanel.addAnchoredComponent(jButton, new Insets(10, 5, 0, 10), n++, 3, 1, 1, 14);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                            if (!exportDialog.isCancelled()) {
                                exportDialog.export(ConfusionMatrixPanel.this.m_cmTable);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                jScrollPane.getViewport().add((Component)((Object)this.m_cmTable));
                jLabel.setLabelFor((Component)((Object)this.m_cmTable));
                jScrollPane.setPreferredSize(null);
                this.m_cmPanel.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 1, 3, 3, 1);
                this.addFilledComponent(this.m_cmPanel, MIDLABELITEMINSETS, n, 1, 3, 3, 1);
                this.m_splitPanel = new JSplitPane(0, this.m_smPanel, this.m_cmPanel);
                BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.m_splitPanel.getUI();
                BasicSplitPaneDivider basicSplitPaneDivider = basicSplitPaneUI.getDivider();
                basicSplitPaneDivider.setBorder(new BevelBorder(0));
                this.addFilledComponent(this.m_splitPanel, new Insets(0, 0, 0, 0), 0, 0, 2, 2, 1);
                this.revalidate();
                this.repaint();
                GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
                this.m_cmTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
                Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_cmTable);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            ConfusionMatrixPanel.this.m_cmTable.load(false);
                            ConfusionMatrixPanel.this.m_cmTable.showColorDiagonal();
                            ConfusionMatrixPanel.this.m_cmTable.setResize(false);
                            ConfusionMatrixPanel.this.m_cmTable.setAutoResize(false);
                            ConfusionMatrixPanel.this.m_cmTable.setColumnWidths(50);
                            ConfusionMatrixPanel.this.m_cmTable.setDefaultColumnWidth(75);
                            ConfusionMatrixPanel.this.m_cmTable.setRowHeaderWidth(75);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            } else {
                this.m_splitPanel = new JSplitPane(0, this.m_smPanel, this.m_cmPanel);
                this.m_splitPanel.setResizeWeight(0.5);
                BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.m_splitPanel.getUI();
                BasicSplitPaneDivider basicSplitPaneDivider = basicSplitPaneUI.getDivider();
                basicSplitPaneDivider.setBorder(new BevelBorder(0));
                this.addFilledComponent(this.m_splitPanel, new Insets(0, 0, 0, 0), 0, 0, 2, 2, 1);
                this.revalidate();
                this.repaint();
            }
            this.m_detailButton.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_HIDE_DETAIL"));
            this.m_detailButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CM_HIDE_DETAIL"));
            this.m_showConfusionMatrix = false;
        } else {
            this.remove(this.m_splitPanel);
            this.addFilledComponent(this.m_smPanel, new Insets(0, 0, 0, 0), 0, 0, 2, 2, 1);
            this.revalidate();
            this.repaint();
            this.m_detailButton.setText(DM4JResourceUtilities.getUIString("CLASS_TESTMETRICS_CM_SHOW_DETAIL"));
            this.m_detailButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TESTMETRICS_CM_SHOW_DETAIL"));
            this.m_showConfusionMatrix = true;
        }
    }

    private void runTimePanelLoad() throws Exception {
        this.m_mpShowCost.setSelected(false);
        this.m_scmTable.load(false);
        ClassificationTestMetrics classificationTestMetrics = this.m_parent.getClassificationTestMetrics();
        String string = this.m_parent.getConfusionMatrixName();
        this.m_name.setText(string);
        double d = this.m_scmTable.getSummarizedConfusionMatrixTableModel().getAvgAccuracy();
        double d2 = classificationTestMetrics.getConfusionMatrix().getAccuracy();
        double d3 = this.m_scmTable.getSummarizedConfusionMatrixTableModel().getTotalCosts();
        this.m_averageAccuracy.setText(DM4JNumericFormat.format(d, false, 10));
        this.m_overallAccuracy.setText(DM4JNumericFormat.format(d2, false, 10));
        this.m_totalCost.setText(DM4JNumericFormat.format(d3, false, 4));
    }
}

