/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.base.Task;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailPanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.task.OraTransformationTask;
import oracle.dmt.jdm.transform.text.OraTextTransform;

public class TransformationTaskDetailPanel
extends TaskDetailPanel {
    private JLabel m_name = new JLabel();
    private JLabel m_type = new JLabel();
    private HyperlinkButton m_modelNameBtn = new HyperlinkButton();
    private JLabel m_schema = new JLabel();
    private JLabel m_outputSchema = new JLabel();
    private HyperlinkButton m_tableBtn = new HyperlinkButton();
    private HyperlinkButton m_outTableBtn = new HyperlinkButton();
    private JLabel m_time = new JLabel();
    private JLabel m_duration = new JLabel();
    private JLabel m_status = new JLabel();
    private JTextArea m_message = null;
    private JScrollPane m_messagePanel = new JScrollPane();
    private OraTransformationTask m_task = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformationTaskDetailPanel(Task task) {
        super(task);
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_task = (OraTransformationTask)this.getMiningTask();
            this.jbInit();
            this.runTimePanelLoad(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addFilledComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2, 2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_type, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        this.addComponent(jLabel3, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_tableBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
        this.addComponent(jLabel4, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_outTableBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        this.addComponent(jLabel5, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_time, TOPVALUEITEMINSETS, n++, 2);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DM4JResourceUtilities.getUIString("COMMON_DURATION"));
        this.addComponent(jLabel6, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_duration, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(DM4JResourceUtilities.getUIString("COMMON_STATUS"));
        this.addComponent(jLabel7, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_status, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(DM4JResourceUtilities.getUIString("TASK_MESSAGE"));
        jLabel8.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TASK_MESSAGE"));
        this.addComponent(jLabel8, TOPLABELITEMINSETS, n++, 1);
        this.m_message = new JTextArea(4, 10);
        this.m_message.setEditable(false);
        this.m_message.setLineWrap(true);
        this.m_message.setWrapStyleWord(true);
        jLabel8.setLabelFor(this.m_message);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_message);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n++, 1, 2, 2, 1);
        this.setPreferredSize(null);
    }

    private void runTimePanelLoad(Connection connection) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string = this.m_task.getName();
        this.m_name.setText(string);
        String string2 = null;
        if (this.m_task.getTransformation() instanceof OraTextTransform) {
            string2 = DM4JResourceUtilities.getUIString("TEXT_TASK_TYPE");
        }
        this.m_type.setText(string2);
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        String string3 = this.m_task.getTransformation().getTransformInputData();
        if (this.m_task.getTransformation().getTransformInputData().equalsIgnoreCase(this.m_task.getTransformation().getTransformOutputData())) {
            object3 = DMEMetadata.getInstance();
            string3 = ((DMEMetadata)object3).getModelNameForTask(connection, "XTEXT", string);
        }
        object3 = new StringTokenizer(string3, ".");
        String string4 = null;
        String string5 = null;
        if (((StringTokenizer)object3).countTokens() == 2) {
            string4 = ((StringTokenizer)object3).nextToken();
            string5 = ((StringTokenizer)object3).nextToken();
        } else {
            string4 = DM4JConnectionManager.getUser();
            string5 = string3;
        }
        this.m_tableBtn.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_NAME") + " " + string4 + "." + string5);
        this.m_tableBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                String string = null;
                Object object3 = null;
                try {
                    Object object4;
                    object2 = TransformationTaskDetailPanel.this.m_task.getTransformation().getTransformInputData();
                    if (TransformationTaskDetailPanel.this.m_task.getTransformation().getTransformInputData().equalsIgnoreCase(TransformationTaskDetailPanel.this.m_task.getTransformation().getTransformOutputData())) {
                        object4 = null;
                        try {
                            object4 = DM4JConnectionManager.getDbConnection();
                            object = DMEMetadata.getInstance();
                            object2 = ((DMEMetadata)object).getModelNameForTask((Connection)object4, "XTEXT", TransformationTaskDetailPanel.this.m_task.getName());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (object4 != null) {
                                try {
                                    object4.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    if (((StringTokenizer)(object4 = new StringTokenizer((String)object2, "."))).countTokens() == 2) {
                        string = ((StringTokenizer)object4).nextToken();
                        object3 = ((StringTokenizer)object4).nextToken();
                    } else {
                        string = DM4JConnectionManager.getUser();
                        object3 = object2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = (HyperlinkButton)actionEvent.getSource();
                ((Component)object2).setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = false;
                object = null;
                try {
                    object = DM4JConnectionManager.getDbConnection();
                    bl = DatabaseMetadata.isTable((Connection)object, string, object3);
                    if (bl) {
                        browserFrame.findSchemaObject(string, (String)object3, "TABLE");
                    } else {
                        browserFrame.findSchemaObject(string, (String)object3, "VIEW");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                ((Component)object2).setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        browserFrame = BrowserFrame.getMainFrame();
        string3 = this.m_task.getTransformation().getTransformOutputData();
        object3 = new StringTokenizer(string3, ".");
        string4 = null;
        string5 = null;
        if (((StringTokenizer)object3).countTokens() == 2) {
            string4 = ((StringTokenizer)object3).nextToken();
            string5 = ((StringTokenizer)object3).nextToken();
        } else {
            string4 = DM4JConnectionManager.getUser();
            string5 = string3;
        }
        this.m_outTableBtn.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_NAME") + " " + string4 + "." + string5);
        this.m_outTableBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void actionPerformed(ActionEvent actionEvent) {
                Object object;
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                String string = null;
                Object object2 = null;
                try {
                    object = TransformationTaskDetailPanel.this.m_task.getTransformation().getTransformOutputData();
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
                    if (stringTokenizer.countTokens() == 2) {
                        string = stringTokenizer.nextToken();
                        object2 = stringTokenizer.nextToken();
                    } else {
                        string = DM4JConnectionManager.getUser();
                        object2 = object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = (HyperlinkButton)actionEvent.getSource();
                ((Component)object).setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = false;
                Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    bl = DatabaseMetadata.isTable(connection, string, (String)object2);
                    if (bl) {
                        browserFrame.findSchemaObject(string, (String)object2, "TABLE");
                    } else {
                        browserFrame.findSchemaObject(string, (String)object2, "VIEW");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                ((Component)object).setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        ExecutionHandle executionHandle = this.m_task.getExecutionHandle();
        ExecutionStatus executionStatus = executionHandle.getLatestStatus();
        ExecutionState executionState = executionStatus.getState();
        try {
            object2 = new Date(executionStatus.getTimestamp().getTime());
            object = DateFormat.getDateTimeInstance(3, 3);
            String string6 = ((DateFormat)object).format((Date)object2);
            this.m_time.setText(string6);
        }
        catch (Exception exception) {
            this.m_time.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        try {
            object2 = executionHandle.getDurationInSeconds();
            object = BrowserUtils.getDuration(((Integer)object2).longValue());
            this.m_duration.setText((String)object);
        }
        catch (Exception exception) {
            this.m_duration.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        object2 = executionState.name();
        this.m_status.setText((String)object2);
        object = executionStatus.getDescription();
        this.m_message.setText((String)object);
    }
}

