/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.Format;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.task.LoadTasksWorker;
import oracle.dmt.dm4j.browser.viewer.task.TaskTableModel;

public final class TaskTable
extends Dm4jSpreadTable {
    private LoadTasksWorker m_worker = null;
    private TaskTableModel m_tableModel;
    private int m_sortColumn = 0;
    private boolean m_sortAscending = true;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("TASK_COLUMN_NAME"), DM4JResourceUtilities.getUIString("TASK_COLUMN_TYPE"), DM4JResourceUtilities.getUIString("TASK_COLUMN_STATUS"), DM4JResourceUtilities.getUIString("TASK_COLUMN_ENDTIME")};
    private int[] m_colWidths = new int[]{40, 15, 15, 30};

    public TaskTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDefaultColumnWidths() {
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TaskTableModel getTableModel() {
        return this.m_tableModel;
    }

    public boolean getSortOrder() {
        return this.m_sortAscending;
    }

    public int getSortColumn() {
        return this.m_sortColumn;
    }

    public void loadTasks(TaskTableModel taskTableModel, String string, int n, boolean bl) {
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = taskTableModel;
        this.m_tableModel.sort(n, bl);
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(this.m_tableModel));
        header.setCanMoveItems(false);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        FormatPainter formatPainter = new FormatPainter((Format)dateFormat);
        this.getGrid().setColumnPainter(3, (Painter)formatPainter);
        if (this.m_tableModel.getRowCount() != 0) {
            int n2 = this.m_tableModel.findSelectionIndex(string);
            TwoDSelection twoDSelection = new TwoDSelection(n2, true);
            this.setFirstRowOnScreen(n2);
            try {
                this.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        TaskTableModel model = null;

        public SortHandler(TaskTableModel taskTableModel) {
            this.model = taskTableModel;
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            Grid grid = TaskTable.this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = (GeneralGridSelectionManager)grid.getGridSelectionManager();
            int n2 = generalGridSelectionManager.getSelection().getSingleRow();
            String string = (String)TaskTable.this.m_tableModel.getData(0, n2);
            TaskTable.this.m_sortColumn = n;
            TaskTable.this.m_sortAscending = !TaskTable.this.m_sortAscending;
            this.model.sort(n, TaskTable.this.m_sortAscending);
            n2 = this.model.findSelectionIndex(string);
            TwoDSelection twoDSelection = new TwoDSelection(n2, true);
            try {
                TaskTable.this.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TaskTable.this.setFirstRowOnScreen(n2);
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

