/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.base.Task;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.task.TaskDetailPanel;
import oracle.dmt.jdm.task.OraPredictTask;

public class PredictTaskDetailPanel
extends TaskDetailPanel {
    private JLabel m_name = new JLabel();
    private JLabel m_type = new JLabel();
    private HyperlinkButtonDataSource m_tableBtn = new HyperlinkButtonDataSource();
    private HyperlinkButtonDataSource m_outTableBtn = new HyperlinkButtonDataSource();
    private JLabel m_time = new JLabel();
    private JLabel m_duration = new JLabel();
    private JLabel m_status = new JLabel();
    private JTextArea m_message = null;
    private JScrollPane m_messagePanel = new JScrollPane();
    private OraPredictTask m_task = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictTaskDetailPanel(Task task) {
        super(task);
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_task = (OraPredictTask)this.getMiningTask();
            this.jbInit();
            this.runTimePanelLoad(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addFilledComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2, 2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_type, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        this.addComponent(jLabel3, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_tableBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
        this.addComponent(jLabel4, TOPLABELITEMINSETS, n++, 1);
        this.addComponent(this.m_outTableBtn, MIDINDENTEDLABELITEMINSETS, n++, 1, 3, 1, 16, 2);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        this.addComponent(jLabel5, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_time, TOPVALUEITEMINSETS, n++, 2);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DM4JResourceUtilities.getUIString("COMMON_DURATION"));
        this.addComponent(jLabel6, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_duration, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(DM4JResourceUtilities.getUIString("COMMON_STATUS"));
        this.addComponent(jLabel7, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_status, MIDVALUEITEMINSETS, n++, 2);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(DM4JResourceUtilities.getUIString("TASK_MESSAGE"));
        jLabel8.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TASK_MESSAGE"));
        this.addComponent(jLabel8, TOPLABELITEMINSETS, n++, 1);
        this.m_message = new JTextArea(4, 10);
        this.m_message.setEditable(false);
        this.m_message.setLineWrap(true);
        this.m_message.setWrapStyleWord(true);
        jLabel8.setLabelFor(this.m_message);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_message);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n++, 1, 2, 2, 1);
        this.setPreferredSize(null);
    }

    private void runTimePanelLoad(Connection connection) throws Exception {
        Object object;
        Object object2;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string = this.m_task.getName();
        this.m_name.setText(string);
        String string2 = DM4JResourceUtilities.getUIString("PREDICT_TASK_TYPE");
        this.m_type.setText(string2);
        String string3 = this.m_task.getInputData();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        String string4 = null;
        String string5 = null;
        if (stringTokenizer.countTokens() == 2) {
            string4 = stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
        } else {
            string4 = DM4JConnectionManager.getUser();
            string5 = string3;
        }
        string4 = DM4JStringUtils.isDoubleQuotedString(string4) ? DM4JStringUtils.trimDoubleQuotes(string4) : string4.toUpperCase();
        string5 = DM4JStringUtils.isDoubleQuotedString(string5) ? DM4JStringUtils.trimDoubleQuotes(string5) : string5.toUpperCase();
        this.m_tableBtn.setSchemaName(string4);
        this.m_tableBtn.setTableName(string5);
        this.m_tableBtn.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_NAME") + " " + string4 + "." + string5);
        this.m_tableBtn.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
                hyperlinkButtonDataSource.setCursor(Cursor.getPredefinedCursor(3));
                OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                hyperlinkButtonDataSource.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        string5 = this.m_task.getOutputData();
        string5 = DM4JStringUtils.isDoubleQuotedString(string5) ? DM4JStringUtils.trimDoubleQuotes(string5) : string5.toUpperCase();
        this.m_outTableBtn.setSchemaName(string4);
        this.m_outTableBtn.setTableName(string5);
        this.m_outTableBtn.setIsView(false);
        this.m_outTableBtn.setText(DM4JResourceUtilities.getUIString("COMMON_TABLE_RESULT_NAME") + " " + string5);
        this.m_outTableBtn.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
                hyperlinkButtonDataSource.setCursor(Cursor.getPredefinedCursor(3));
                OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                hyperlinkButtonDataSource.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        ExecutionHandle executionHandle = this.m_task.getExecutionHandle();
        ExecutionStatus executionStatus = executionHandle.getLatestStatus();
        ExecutionState executionState = executionStatus.getState();
        try {
            object2 = new Date(executionStatus.getTimestamp().getTime());
            object = DateFormat.getDateTimeInstance(3, 3);
            String string6 = ((DateFormat)object).format((Date)object2);
            this.m_time.setText(string6);
        }
        catch (Exception exception) {
            this.m_time.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        try {
            object2 = executionHandle.getDurationInSeconds();
            object = BrowserUtils.getDuration(((Integer)object2).longValue());
            this.m_duration.setText((String)object);
        }
        catch (Exception exception) {
            this.m_duration.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        object2 = executionState.name();
        this.m_status.setText((String)object2);
        object = executionStatus.getDescription();
        this.m_message.setText((String)object);
    }
}

