/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.task.TasksTableModel;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class ActiveTasksTableModel
extends TasksTableModel {
    private String[] _columnNames = new String[]{DM4JResourceUtilities.getUIString("TASK_COLUMN_NAME"), DM4JResourceUtilities.getUIString("TASK_COLUMN_STATUS")};

    public void load(Connection connection) {
        this._tasks = this.getTasks(connection);
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public int getRowCount() {
        return this._tasks.size();
    }

    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        String string = null;
        TaskItemInfo taskItemInfo = (TaskItemInfo)this._tasks.get(n);
        switch (n2) {
            case 0: {
                string = taskItemInfo.getName();
                break;
            }
            case 1: {
                string = taskItemInfo.getState();
                break;
            }
            default: {
                string = DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE");
            }
        }
        return string;
    }

    public Vector getTasks(Connection connection) {
        Vector<TaskItemInfo> vector = new Vector<TaskItemInfo>();
        UserPreferences userPreferences = UserPreferences.getInstance();
        this._maxAge = userPreferences.getFinishedTasksAge();
        try {
            if (BrowserFrame.getMainFrame() == null) {
                return null;
            }
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            Vector vector2 = dMEMetadata.getTasks(connection, new Integer(this._maxAge));
            for (Hashtable hashtable : vector2) {
                String string = (String)hashtable.get("TASK_NAME");
                String string2 = (String)hashtable.get("TASK_STATE");
                vector.add(new TaskItemInfo(string, string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    class TaskItemInfo {
        private String _name = null;
        private String _state = null;

        TaskItemInfo(String string, String string2) {
            this._name = string;
            this._state = string2;
        }

        public String getName() {
            return this._name;
        }

        public String getState() {
            return this._state;
        }

        public String toString() {
            return this.getName();
        }
    }
}

