/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.datamining.ExecutionHandle;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.viewer.task.ActiveTasksTableModel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.base.OraTask;

public class ActiveTasksTable
extends JTable {
    private ActiveTasksTableModel _model = null;
    private Thread _monitorThread = null;
    private ProgressBar _progress = null;
    private java.sql.Connection _dbConn = null;
    private Object _refreshLock = new Object();

    public ActiveTasksTable() {
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setModel(new LoadingTasksModel());
        this.setAutoResizeMode(4);
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ActiveTasksTable.this.view_actionPerformed();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            private void doPopup(MouseEvent mouseEvent) {
                int n;
                ActiveTasksTable activeTasksTable = BrowserFrame.getMainFrame().getActiveTasksTable();
                if (!activeTasksTable.isRowSelected(n = ActiveTasksTable.this.rowAtPoint(mouseEvent.getPoint()))) {
                    activeTasksTable.changeSelection(n, 0, false, false);
                }
                JPopupMenu jPopupMenu = ActiveTasksTable.this.createContextMenu();
                jPopupMenu.show(activeTasksTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        MenuListener menuListener = new MenuListener();
        this.addMouseListener(menuListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findTask(String string) {
        if (!(this.getModel() instanceof ActiveTasksTableModel)) {
            return false;
        }
        boolean bl = false;
        String[] stringArray = this.getSelection();
        bl = this.findAndSelectTask(string);
        if (!bl) {
            ActiveTasksTableModel activeTasksTableModel = (ActiveTasksTableModel)this.getModel();
            Object object = this._refreshLock;
            synchronized (object) {
                if (null != this._dbConn) {
                    activeTasksTableModel.load(this._dbConn);
                    activeTasksTableModel.fireTableDataChanged();
                }
            }
            bl = this.findAndSelectTask(string);
            if (!bl) {
                this.setSelection(stringArray);
            }
        }
        return bl;
    }

    private boolean findAndSelectTask(String string) {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string2 = (String)this.getValueAt(i, 0);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.changeSelection(i, 0, false, false);
            bl = true;
            break;
        }
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        this.startMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        super.removeNotify();
        if (this._monitorThread != null) {
            this._monitorThread.interrupt();
        }
        if (this._dbConn != null) {
            try {
                Object object = this._refreshLock;
                synchronized (object) {
                    this._dbConn.close();
                    this._dbConn = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void startMonitor() {
        Thread thread;
        final ActiveTasksTable activeTasksTable = this;
        this._monitorThread = thread = new Thread("ODMActiveTaskMonitor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ActiveTasksTable.this._dbConn = ActiveTasksTable.this.getMonitorConnection();
                while (!1.interrupted()) {
                    Object object;
                    if (1.interrupted()) {
                        return;
                    }
                    if (ActiveTasksTable.this._model == null) {
                        ActiveTasksTable.this._model = new ActiveTasksTableModel();
                        if (1.interrupted()) {
                            return;
                        }
                        object = ActiveTasksTable.this._refreshLock;
                        synchronized (object) {
                            if (null != ActiveTasksTable.this._dbConn) {
                                ActiveTasksTable.this._model.load(ActiveTasksTable.this._dbConn);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        activeTasksTable.setModel(ActiveTasksTable.this._model);
                                        ActiveTasksTable.this._model.fireTableDataChanged();
                                        ActiveTasksTable.this.configureEnclosingScrollPane();
                                    }
                                });
                            }
                        }
                    }
                    if (1.interrupted()) {
                        return;
                    }
                    object = ActiveTasksTable.this._refreshLock;
                    synchronized (object) {
                        if (null != ActiveTasksTable.this._dbConn) {
                            final String[] stringArray = activeTasksTable.getSelection();
                            ActiveTasksTable.this._model.load(ActiveTasksTable.this._dbConn);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ActiveTasksTable.this._model.fireTableDataChanged();
                                    activeTasksTable.setSelection(stringArray);
                                }
                            });
                        }
                    }
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        this._monitorThread.start();
    }

    private java.sql.Connection getMonitorConnection() {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        java.sql.Connection connection = null;
        while (null == browserFrame) {
            browserFrame = BrowserFrame.getMainFrame();
            if (null != browserFrame) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSelection() {
        String[] stringArray = null;
        int[] nArray = null;
        Object object = this._refreshLock;
        synchronized (object) {
            nArray = this.getSelectedRows();
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = (String)this.getValueAt(nArray[i], 0);
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelection(String[] stringArray) {
        Object object = this._refreshLock;
        synchronized (object) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = (String)this.getValueAt(i, 0);
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equalsIgnoreCase(stringArray[j])) continue;
                    this.changeSelection(i, 0, true, false);
                }
            }
        }
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DM4JResourceUtilities.getActivityUIString("TASK_MENU_VIEW_TASK"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveTasksTable.this.view_actionPerformed();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DM4JResourceUtilities.getActivityUIString("TASK_MENU_DELETE_TASK"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveTasksTable.this.delete_actionPerformed();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(DM4JResourceUtilities.getActivityUIString("TASK_MENU_STOP_TASK"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveTasksTable.this.stop_actionPerformed();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        int n = this.getSelectedRowCount();
        if (n != 1) {
            jMenuItem.setEnabled(false);
        }
        if (n < 1) {
            jMenuItem2.setEnabled(false);
            jMenuItem3.setEnabled(false);
        }
        return jPopupMenu;
    }

    private void view_actionPerformed() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        String string = (String)this.getValueAt(this.getSelectedRow(), 0);
        BrowserFrame.getMainFrame().findComponent("TASKS", string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop_actionPerformed() {
        final String[] stringArray = this.getSelection();
        final BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        final Vector vector = new Vector();
        if (stringArray.length == 0) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            return;
        }
        int n = JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_PROMPT"), DM4JResourceUtilities.getUIString("WARNING"), 0, 2);
        if (1 == n) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    if (ActiveTasksTable.this._progress.hasUserCancelled()) {
                        return;
                    }
                    try {
                        connection = DM4JConnectionManager.getConnection();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(browserFrame, DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE"), DM4JResourceUtilities.getUIString("ERROR"), 0);
                        try {
                            connection.close();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        ActiveTasksTable.this._progress.setDoneStatus();
                        return;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (ActiveTasksTable.this._progress.hasUserCancelled()) {
                            return;
                        }
                        try {
                            ActiveTasksTable.this._progress.updateProgress(DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASKS"), DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASK") + string);
                            OraTask oraTask = OraTask.retrieveObjectFromDatabase(connection, DMEMetadata.fixObjectNameWhenLoad(string));
                            ExecutionHandle executionHandle = oraTask.getExecutionHandle();
                            executionHandle.terminate();
                            continue;
                        }
                        catch (Exception exception) {
                            vector.add(exception);
                        }
                    }
                }
                finally {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ActiveTasksTable.this._progress.setDoneStatus();
                }
            }
        };
        this._progress = new ProgressBar(browserFrame, DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASKS"), runnable, true);
        this._progress.start(DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASKS"), DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASK"));
        ActiveTasksTableModel activeTasksTableModel = (ActiveTasksTableModel)browserFrame.getActiveTasksTable().getModel();
        Object object = this._refreshLock;
        synchronized (object) {
            if (null != this._dbConn) {
                activeTasksTableModel.load(this._dbConn);
                activeTasksTableModel.fireTableDataChanged();
                this.setSelection(stringArray);
            }
        }
        if (0 != vector.size()) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_STOP_ERROR"), DM4JResourceUtilities.getUIString("ERROR"), -1, 0, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_actionPerformed() {
        final String[] stringArray = this.getSelection();
        final BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        final Vector vector = new Vector();
        if (stringArray.length == 0) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            return;
        }
        int n = JOptionPane.showConfirmDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_PROMPT"), DM4JResourceUtilities.getUIString("WARNING"), 0, 2);
        if (1 == n) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    if (ActiveTasksTable.this._progress.hasUserCancelled()) {
                        return;
                    }
                    try {
                        connection = DM4JConnectionManager.getConnection();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(browserFrame, DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE"), DM4JResourceUtilities.getUIString("ERROR"), 0);
                        try {
                            connection.close();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        ActiveTasksTable.this._progress.setDoneStatus();
                        return;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (ActiveTasksTable.this._progress.hasUserCancelled()) {
                            return;
                        }
                        try {
                            ActiveTasksTable.this._progress.updateProgress(DM4JResourceUtilities.getActivityUIString("TASK_DELETING_TASKS"), DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASK") + string);
                            connection.removeObject(string, NamedObject.task);
                            continue;
                        }
                        catch (Exception exception) {
                            vector.add(exception);
                        }
                    }
                }
                finally {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ActiveTasksTable.this._progress.setDoneStatus();
                }
            }
        };
        this._progress = new ProgressBar(browserFrame, DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASKS"), runnable, true);
        this._progress.start(DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASKS"), DM4JResourceUtilities.getActivityUIString("TASK_TERMINATING_TASK"));
        ActiveTasksTableModel activeTasksTableModel = (ActiveTasksTableModel)browserFrame.getActiveTasksTable().getModel();
        Object object = this._refreshLock;
        synchronized (object) {
            if (null != this._dbConn) {
                activeTasksTableModel.load(this._dbConn);
                activeTasksTableModel.fireTableDataChanged();
                this.setSelection(stringArray);
            }
        }
        if (0 != vector.size()) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("TASK_DELETE_ERROR"), DM4JResourceUtilities.getUIString("ERROR"), -1, 0, null, null, null);
        }
    }

    class LoadingTasksModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{DM4JResourceUtilities.getActivityUIString("TASK_DELETING_TASKS")};
        private String[] _data = new String[]{DM4JResourceUtilities.getUIString("COMMON_LOADING")};

        LoadingTasksModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data[n];
                    break;
                }
                case 1: {
                    string = "";
                    break;
                }
                default: {
                    string = DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE");
                }
            }
            return string;
        }
    }
}

