/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.task;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.viewer.task.ActiveActivitiesTableModel;

public class ActiveActivitiesTable
extends JTable {
    private ActiveActivitiesTableModel _model = null;
    private Thread _monitorThread = null;
    private Object _refreshLock = new Object();

    public ActiveActivitiesTable() {
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setModel(new LoadingTasksModel());
        this.setAutoResizeMode(4);
        final ActiveActivitiesTable activeActivitiesTable = this;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ActiveActivitiesTable.this.view_actionPerformed();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            private void doPopup(MouseEvent mouseEvent) {
                int n = ActiveActivitiesTable.this.rowAtPoint(mouseEvent.getPoint());
                if (!activeActivitiesTable.isRowSelected(n)) {
                    activeActivitiesTable.changeSelection(n, 0, false, false);
                }
                JPopupMenu jPopupMenu = ActiveActivitiesTable.this.createContextMenu();
                jPopupMenu.show(activeActivitiesTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        MenuListener menuListener = new MenuListener();
        this.addMouseListener(menuListener);
    }

    public void addNotify() {
        super.addNotify();
        this.startMonitor();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._monitorThread != null) {
            this._monitorThread.interrupt();
        }
    }

    private void startMonitor() {
        Thread thread;
        final ActiveActivitiesTable activeActivitiesTable = this;
        this._monitorThread = thread = new Thread("ActiveActivitiesMonitor"){

            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    ActiveActivitiesTable.this.refresh(activeActivitiesTable);
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        this._monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(final ActiveActivitiesTable activeActivitiesTable) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this._model == null) {
            this._model = new ActiveActivitiesTableModel();
            Object object = this._refreshLock;
            synchronized (object) {
                this._model.load();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        activeActivitiesTable.setModel(ActiveActivitiesTable.this._model);
                        ActiveActivitiesTable.this._model.fireTableDataChanged();
                        ActiveActivitiesTable.this.configureEnclosingScrollPane();
                    }
                });
            }
        }
        Object object = this._refreshLock;
        synchronized (object) {
            final String[] stringArray = activeActivitiesTable.getSelection();
            this._model.load();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ActiveActivitiesTable.this._model.fireTableDataChanged();
                    activeActivitiesTable.setSelection(stringArray);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSelection() {
        String[] stringArray = null;
        int[] nArray = null;
        Object object = this._refreshLock;
        synchronized (object) {
            nArray = this.getSelectedRows();
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = ((ActivityTask)this.getValueAt(nArray[i], 0)).getName();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelection(String[] stringArray) {
        Object object = this._refreshLock;
        synchronized (object) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = ((ActivityTask)this.getValueAt(i, 0)).getName();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equalsIgnoreCase(stringArray[j])) continue;
                    this.changeSelection(i, 0, true, false);
                }
            }
        }
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_MENU_VIEW"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveActivitiesTable.this.view_actionPerformed();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_MENU_REMOVE"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveActivitiesTable.this.delete_actionPerformed();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_MENU_CANCEL"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveActivitiesTable.this.stop_actionPerformed();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        int n = this.getSelectedRowCount();
        if (n != 1) {
            jMenuItem.setEnabled(false);
        }
        if (n < 1) {
            jMenuItem2.setEnabled(false);
            jMenuItem3.setEnabled(false);
        }
        return jPopupMenu;
    }

    private void view_actionPerformed() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        ActivityTask activityTask = (ActivityTask)this.getValueAt(this.getSelectedRow(), 0);
        AbstractActivity abstractActivity = activityTask.getActivity();
        BrowserFrame.getMainFrame().findComponent(ActivityUtils.mapActivityTypeToItemType(abstractActivity.getType()), abstractActivity.getName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop_actionPerformed() {
        String[] stringArray = this.getSelection();
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        if (stringArray.length == 0) {
            JOptionPane.showOptionDialog(browserFrame, DM4JResourceUtilities.getUIString("TASK_STOP_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            return;
        }
        int n = JOptionPane.showConfirmDialog(browserFrame, DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_CANCEL_CONFIRM"), DM4JResourceUtilities.getUIString("WARNING"), 0, 3);
        if (1 == n) {
            return;
        }
        String[] stringArray2 = this.getSelection();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        for (int i = 0; i < stringArray2.length; ++i) {
            activityTaskManager.stop(stringArray2[i]);
        }
        ActiveActivitiesTableModel activeActivitiesTableModel = (ActiveActivitiesTableModel)this.getModel();
        Object object = this._refreshLock;
        synchronized (object) {
            activeActivitiesTableModel.load();
            activeActivitiesTableModel.fireTableDataChanged();
            this.setSelection(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete_actionPerformed() {
        String[] stringArray = this.getSelection();
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        if (stringArray.length == 0) {
            JOptionPane.showOptionDialog(browserFrame, DM4JResourceUtilities.getUIString("TASK_DELETE_WARNING"), DM4JResourceUtilities.getUIString("WARNING"), -1, 2, null, null, null);
            return;
        }
        int n = JOptionPane.showConfirmDialog(browserFrame, DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_REMOVE_CONFIRM"), DM4JResourceUtilities.getUIString("WARNING"), 0, 2);
        if (1 == n) {
            return;
        }
        String[] stringArray2 = this.getSelection();
        ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (activityTaskManager.remove(stringArray2[i])) continue;
            bl = true;
        }
        ActiveActivitiesTableModel activeActivitiesTableModel = (ActiveActivitiesTableModel)this.getModel();
        Object object = this._refreshLock;
        synchronized (object) {
            activeActivitiesTableModel.load();
            activeActivitiesTableModel.fireTableDataChanged();
            this.setSelection(stringArray);
        }
        if (bl) {
            JOptionPane.showOptionDialog(browserFrame, DM4JResourceUtilities.getActivityUIString("ACTIVITY_MONITOR_REMOVE_WARNING"), DM4JResourceUtilities.getUIString("ERROR"), -1, 2, null, null, null);
        }
    }

    class LoadingTasksModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{DM4JResourceUtilities.getActivityUIString("TASK_DELETING_TASKS")};
        private String[] _data = new String[]{DM4JResourceUtilities.getUIString("COMMON_LOADING")};

        LoadingTasksModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data[n];
                    break;
                }
                case 1: {
                    string = "";
                    break;
                }
                default: {
                    string = DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE");
                }
            }
            return string;
        }
    }
}

