/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataType {
    private static final long TWO_GIG = Integer.MAX_VALUE;
    private static final long FOUR_GIG = 0x100000000L;
    public static final DataType ANSI_CHARACTER = new DataType("CHARACTER", true, false, 255L, 0L, 0L);
    public static final DataType ANSI_CHARACTER_VARYING = new DataType("CHARACTER VARYING", true, false, 255L, 0L, 0L);
    public static final DataType ANSI_NUMERIC = new DataType("NUMERIC", true, true, 38L, 0L, 127L);
    public static final DataType ANSI_DECIMAL = new DataType("DECIMAL", true, true, 38L, 0L, 127L);
    public static final DataType ANSI_INTEGER = new DataType("INTEGER", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_INT = new DataType("INT", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_SMALLINT = new DataType("SMALLINT", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_FLOAT = new DataType("FLOAT", true, false, 38L, 0L, 0L);
    public static final DataType ANSI_DOUBLE_PRECISION = new DataType("DOUBLE PRECISION", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_REAL = new DataType("REAL", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_DATE = new DataType("DATE", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_TIME = new DataType("TIME", false, false, 0L, 0L, 0L);
    public static final DataType ANSI_DATETIME = new DataType("DATETIME", false, false, 0L, 0L, 0L);
    public static final DataType ORA_VARCHAR2 = new DataType("VARCHAR2", true, false, 4000L, 0L, 0L);
    public static final DataType ORA_NVARCHAR2 = new DataType("NVARCHAR2", true, false, 4000L, 0L, 0L);
    public static final DataType ORA_NUMBER = new DataType("NUMBER", true, true, 38L, -84L, 127L);
    public static final DataType ORA_LONG = new DataType("LONG", false, false, Integer.MAX_VALUE, 0L, 0L);
    public static final DataType ORA_DATE = new DataType("DATE", false, false, 0L, 0L, 0L);
    public static final DataType ORA_RAW = new DataType("RAW", true, false, 2000L, 0L, 0L);
    public static final DataType ORA_LONG_RAW = new DataType("LONG RAW", false, false, Integer.MAX_VALUE, 0L, 0L);
    public static final DataType ORA_ROWID = new DataType("ROWID", false, false, 0L, 0L, 0L);
    public static final DataType ORA_UROWID = new DataType("UROWID", true, false, 2000L, 0L, 0L);
    public static final DataType ORA_CHAR = new DataType("CHAR", true, false, 2000L, 0L, 0L);
    public static final DataType ORA_NCHAR = new DataType("NCHAR", true, false, 2000L, 0L, 0L);
    public static final DataType ORA_CLOB = new DataType("CLOB", false, false, 0x100000000L, 0L, 0L);
    public static final DataType ORA_NCLOB = new DataType("NCLOB", false, false, 0x100000000L, 0L, 0L);
    public static final DataType ORA_BLOB = new DataType("BLOB", false, false, 0x100000000L, 0L, 0L);
    public static final DataType ORA_BFILE = new DataType("BFILE", false, false, 0x100000000L, 0L, 0L);
    private static List m_ansiList;
    private static List m_oraList;
    private static Map m_oraToAnsiMap;
    private static Map m_ansiToOraMap;
    private String m_name;
    private boolean m_allowPrec;
    private boolean m_allowScale;
    private long m_maxPrecision;
    private long m_minScale;
    private long m_maxScale;

    private DataType(String string, boolean bl, boolean bl2, long l, long l2, long l3) {
        this.m_name = string;
        this.m_allowPrec = bl;
        this.m_allowScale = bl2;
        this.m_maxPrecision = l;
        this.m_minScale = l2;
        this.m_maxScale = l3;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean isAllowPrecision() {
        return this.m_allowPrec;
    }

    public final boolean isAllowScale() {
        return this.m_allowScale;
    }

    public final long getMaxPrecision() {
        return this.m_maxPrecision;
    }

    public final long getMinScale() {
        return this.m_minScale;
    }

    public final long getMaxScale() {
        return this.m_maxScale;
    }

    public String toString() {
        return this.getName();
    }

    public static synchronized List getAnsiDataTypes() {
        if (null == m_ansiList) {
            m_ansiList = new ArrayList();
            m_ansiList.add(ANSI_CHARACTER);
            m_ansiList.add(ANSI_CHARACTER_VARYING);
            m_ansiList.add(ANSI_NUMERIC);
            m_ansiList.add(ANSI_DECIMAL);
            m_ansiList.add(ANSI_INTEGER);
            m_ansiList.add(ANSI_INT);
            m_ansiList.add(ANSI_SMALLINT);
            m_ansiList.add(ANSI_FLOAT);
            m_ansiList.add(ANSI_DOUBLE_PRECISION);
            m_ansiList.add(ANSI_REAL);
            m_ansiList.add(ANSI_DATE);
            m_ansiList.add(ANSI_TIME);
            m_ansiList.add(ANSI_DATETIME);
            m_ansiList = Collections.unmodifiableList(m_ansiList);
        }
        return m_ansiList;
    }

    public static synchronized List getOracleDataTypes() {
        if (null == m_oraList) {
            m_oraList = new ArrayList();
            m_oraList.add(ORA_VARCHAR2);
            m_oraList.add(ORA_NVARCHAR2);
            m_oraList.add(ORA_NUMBER);
            m_oraList.add(ORA_LONG);
            m_oraList.add(ORA_DATE);
            m_oraList.add(ORA_RAW);
            m_oraList.add(ORA_LONG_RAW);
            m_oraList.add(ORA_ROWID);
            m_oraList.add(ORA_UROWID);
            m_oraList.add(ORA_CHAR);
            m_oraList.add(ORA_NCHAR);
            m_oraList.add(ORA_CLOB);
            m_oraList.add(ORA_NCLOB);
            m_oraList.add(ORA_BLOB);
            m_oraList.add(ORA_BFILE);
            m_oraList = Collections.unmodifiableList(m_oraList);
        }
        return m_oraList;
    }

    public static synchronized DataType getAnsiForOracle(DataType dataType) {
        if (null == m_ansiToOraMap) {
            m_ansiToOraMap = new HashMap();
            m_ansiToOraMap.put(ORA_CHAR, ANSI_CHARACTER);
            m_ansiToOraMap.put(ORA_DATE, ANSI_DATETIME);
            m_ansiToOraMap.put(ORA_NCHAR, ANSI_CHARACTER);
            m_ansiToOraMap.put(ORA_NUMBER, ANSI_NUMERIC);
            m_ansiToOraMap.put(ORA_NVARCHAR2, ANSI_CHARACTER_VARYING);
            m_ansiToOraMap.put(ORA_VARCHAR2, ANSI_CHARACTER_VARYING);
            m_ansiToOraMap = Collections.unmodifiableMap(m_ansiToOraMap);
        }
        return (DataType)m_ansiToOraMap.get(dataType);
    }

    public static synchronized DataType getOracleForAnsi(DataType dataType) {
        if (null == m_oraToAnsiMap) {
            m_oraToAnsiMap = new HashMap();
            m_oraToAnsiMap.put(ANSI_CHARACTER, ORA_CHAR);
            m_oraToAnsiMap.put(ANSI_CHARACTER_VARYING, ORA_VARCHAR2);
            m_oraToAnsiMap.put(ANSI_DATE, ORA_DATE);
            m_oraToAnsiMap.put(ANSI_DATETIME, ORA_DATE);
            m_oraToAnsiMap.put(ANSI_DECIMAL, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_DOUBLE_PRECISION, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_FLOAT, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_INT, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_INTEGER, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_NUMERIC, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_REAL, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_SMALLINT, ORA_NUMBER);
            m_oraToAnsiMap.put(ANSI_TIME, ORA_DATE);
            m_oraToAnsiMap = Collections.unmodifiableMap(m_oraToAnsiMap);
        }
        return (DataType)m_oraToAnsiMap.get(dataType);
    }
}

