/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationBar;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationEvent;
import oracle.dmt.dm4j.browser.viewer.table.ResultSetNavigationListener;

public class ResultSetTableModel
extends AbstractTableModel {
    private Connection m_conn;
    private String m_sql;
    private ResultSet m_rs;
    private Statement m_stmt;
    private ArrayList m_colNames;
    private int[] m_colTypes = null;
    private ArrayList m_rows;
    private ResultSetNavigationBar m_bar;
    private List m_listenerList = Collections.synchronizedList(new ArrayList());
    private ActionListener m_fetchActionListener;
    private ActionListener m_refreshActionListener;
    private ActionListener m_exportActionListener;

    public ResultSetTableModel(Connection connection, String string, ResultSetNavigationBar resultSetNavigationBar, boolean bl) {
        this.m_conn = connection;
        this.m_sql = string;
        this.setBar(resultSetNavigationBar);
        if (bl) {
            this.open();
        }
    }

    public ResultSetTableModel(ResultSet resultSet, String string, ResultSetNavigationBar resultSetNavigationBar) throws SQLException {
        this.m_rs = resultSet;
        this.m_stmt = resultSet.getStatement();
        this.m_conn = this.m_stmt.getConnection();
        this.m_sql = string;
        this.setBar(resultSetNavigationBar);
        this.open();
    }

    public void setBar(ResultSetNavigationBar resultSetNavigationBar) {
        if (resultSetNavigationBar != this.m_bar) {
            if (this.m_bar != null) {
                this.removeResultSetNavigationListener(this.m_bar);
                this.m_bar.removeFetchActionListener(this.m_fetchActionListener);
                this.m_bar.removeRefreshActionListener(this.m_refreshActionListener);
                this.m_bar.removeExportActionListener(this.m_exportActionListener);
                this.m_fetchActionListener = null;
                this.m_refreshActionListener = null;
                this.m_exportActionListener = null;
            }
            if (resultSetNavigationBar != null) {
                this.m_fetchActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this.fetchNext();
                    }
                };
                resultSetNavigationBar.addFetchActionListener(this.m_fetchActionListener);
                this.m_refreshActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this.refresh();
                    }
                };
                resultSetNavigationBar.addRefreshActionListener(this.m_refreshActionListener);
                this.m_exportActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this.export();
                    }
                };
                resultSetNavigationBar.addExportActionListener(this.m_exportActionListener);
                this.addResultSetNavigationListener(resultSetNavigationBar);
            }
            this.m_bar = resultSetNavigationBar;
        }
    }

    public boolean open() {
        try {
            if (this.m_stmt == null) {
                this.m_stmt = this.m_conn.createStatement();
            }
            if (this.m_rs == null) {
                this.m_rs = this.m_stmt.executeQuery(this.sanitizeOracleSQL(this.m_sql));
            }
            this.createColumnNamesList();
            this.fireTableStructureChanged();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        try {
            if (this.m_bar != null) {
                this.m_bar.setFetchEnabled(true);
                this.m_bar.setRefreshEnabled(true);
                this.m_bar.setExportEnabled(true);
            }
            this.fetchNext();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void cleanup() {
        this.m_rows = null;
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
            this.m_rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        this.cleanup();
        try {
            if (this.m_stmt != null) {
                this.m_stmt.close();
            }
            this.m_stmt = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_bar != null) {
            this.m_bar.setFetchEnabled(false);
            this.m_bar.setRefreshEnabled(false);
            this.m_bar.setExportEnabled(false);
            this.setBar(null);
        }
        return true;
    }

    public int getRowCount() {
        if (this.m_rows != null) {
            return this.m_rows.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return this.m_colNames != null ? this.m_colNames.size() : 0;
    }

    public String getColumnName(int n) {
        try {
            return (String)this.m_colNames.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList;
        if (this.m_rows != null && (arrayList = (ArrayList)this.m_rows.get(n)) != null) {
            return arrayList.get(n2);
        }
        return null;
    }

    public void addResultSetNavigationListener(ResultSetNavigationListener resultSetNavigationListener) {
        this.m_listenerList.add(resultSetNavigationListener);
    }

    public void removeResultSetNavigationListener(ResultSetNavigationListener resultSetNavigationListener) {
        this.m_listenerList.remove(resultSetNavigationListener);
    }

    protected void fireFetchNextPerformed(int n) {
        ResultSetNavigationEvent resultSetNavigationEvent = new ResultSetNavigationEvent(this, this.m_bar.getFetchSize());
        resultSetNavigationEvent.setNumberFetched(n);
        Iterator iterator = this.m_listenerList.iterator();
        try {
            while (iterator.hasNext()) {
                ((ResultSetNavigationListener)iterator.next()).fetchNextPerformed(resultSetNavigationEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void fireRefreshPerformed() {
        ResultSetNavigationEvent resultSetNavigationEvent = new ResultSetNavigationEvent(this, this.m_bar.getFetchSize());
        Iterator iterator = this.m_listenerList.iterator();
        try {
            while (iterator.hasNext()) {
                ((ResultSetNavigationListener)iterator.next()).refreshPerformed(resultSetNavigationEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    private void createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.m_colNames = new ArrayList(n);
        this.m_colTypes = new int[n];
        for (int i = 1; i <= n; ++i) {
            this.m_colNames.add(resultSetMetaData.getColumnLabel(i));
            this.m_colTypes[i - 1] = resultSetMetaData.getColumnType(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fetchNext() {
        int n = 0;
        int n2 = this.m_rows != null ? this.m_rows.size() : 0;
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false);
        numberFormat.setMinimumFractionDigits(0);
        double d = 0.0;
        String string = "";
        try {
            int n3 = this.m_colNames.size();
            for (int i = this.getFetchSize(); i > 0 && this.m_rs.next(); --i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 1; j <= n3; ++j) {
                    if (this.m_colTypes[j - 1] == 2) {
                        d = this.m_rs.getDouble(j);
                        if (this.m_rs.wasNull()) {
                            arrayList.add("");
                            continue;
                        }
                        arrayList.add(numberFormat.format(d));
                        continue;
                    }
                    string = this.m_rs.getString(j);
                    if (this.m_rs.wasNull()) {
                        arrayList.add("");
                        continue;
                    }
                    arrayList.add(string);
                }
                if (this.m_rows == null) {
                    this.m_rows = new ArrayList(100);
                }
                this.m_rows.add(arrayList);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            this.fireTableStructureChanged();
            this.fireFetchNextPerformed(n);
        }
        return n;
    }

    private void refresh() {
        this.cleanup();
        this.open();
    }

    private void export() {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
            if (!exportDialog.isCancelled()) {
                exportDialog.export(new JTable(this));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int getFetchSize() {
        return this.m_bar != null ? this.m_bar.getFetchSize() : 100;
    }

    private String getDataAsTabDelimitedText() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(this.getRowCount() * this.getColumnCount() * 20);
        try {
            Iterator iterator = this.m_colNames.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append("\t");
                } else {
                    bl = false;
                }
                object = iterator.next();
                stringBuffer.append(object != null ? object.toString() : "");
            }
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (ArrayList arrayList : this.m_rows) {
                object = arrayList.iterator();
                boolean bl = true;
                while (object.hasNext()) {
                    if (!bl) {
                        stringBuffer.append("\t");
                    } else {
                        bl = false;
                    }
                    Object e = object.next();
                    stringBuffer.append(e != null ? e.toString() : "");
                }
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

