/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.summarization;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.viewer.summarization.DataSummarizationCommonViewer;
import oracle.dmt.dm4j.datasources.SummarizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramFrame;
import oracle.dmt.dm4j.wizard.steps.transformsteps.DataSummarizationPanel;
import oracle.help.CSHManager;
import oracle.help.Help;

public class DataSummarizationViewer
extends DataSummarizationCommonViewer {
    private static Dimension m_prefJoinBuilderSize = new Dimension(700, 500);
    private JMenuBar m_menuBar = new JMenuBar();
    private JMenu m_menuFile = new JMenu();
    private JMenuItem m_menuFileExit = new JMenuItem();
    private JMenu m_menuHelp = new JMenu();
    private JMenuItem m_menuHelpContents = new JMenuItem();
    private BorderLayout m_borderLayout = new BorderLayout();
    private CSHManager m_helpCxtMgr = null;
    private DataSummarizationPanel m_dataViewer = null;
    private String m_sourceTableName;
    private String m_sourceSchemaName;
    private SummarizeDataSource m_model = null;
    private boolean m_userCancelled = false;
    private boolean m_bTx = false;
    private String m_attributeMapping;
    private String m_valueMapping;
    private String m_seqIdMapping;
    private List m_histograms = Collections.synchronizedList(new LinkedList());
    private BrowserFrame m_parentFrame;

    public DataSummarizationViewer(BrowserFrame browserFrame, String string, String string2, boolean bl, String string3, String string4, String string5) throws Exception {
        this.m_parentFrame = browserFrame;
        this.m_sourceTableName = string;
        this.m_sourceSchemaName = string2;
        this.m_bTx = bl;
        this.m_attributeMapping = string3;
        this.m_valueMapping = string4;
        this.m_seqIdMapping = string5;
        this.jbInit();
    }

    public boolean isUserCanceled() {
        return this.m_userCancelled;
    }

    public void addHistogram(HistogramFrame histogramFrame) {
        this.m_histograms.add(histogramFrame);
    }

    public void removeHistogram(HistogramFrame histogramFrame) {
        this.m_histograms.remove(histogramFrame);
    }

    public void closeWindow() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        super.processWindowEvent(windowEvent);
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                if (DataSummarizationViewer.this.m_model != null) {
                    DataSummarizationViewer.this.m_model.finishCleanUp();
                }
                while (!DataSummarizationViewer.this.m_histograms.isEmpty()) {
                    HistogramFrame histogramFrame = (HistogramFrame)DataSummarizationViewer.this.m_histograms.get(DataSummarizationViewer.this.m_histograms.size() - 1);
                    if (histogramFrame == null) continue;
                    histogramFrame.closeWindow();
                }
                DataSummarizationViewer.this.m_parentFrame.removeSummViewer(DataSummarizationViewer.this);
                window.dispose();
            }
        });
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setLayout(this.m_borderLayout);
        this.setSize(m_prefJoinBuilderSize);
        this.setTitle(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_VIEWER"));
        Help.registerClientWindow((Window)this);
        this.m_helpCxtMgr = BrowserFrame.getCSHManager();
        this.m_helpCxtMgr.addComponent((Component)this, "dm4j_show_summary_html", true, false);
        this.setJMenuBar(this.m_menuBar);
        this.m_menuFileExit.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_EXIT"));
        this.m_menuFileExit.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_EXIT"));
        this.m_menuFileExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.m_menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationViewer.this.cancel_actionPerformed(actionEvent);
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(1).put(keyStroke, "CancelAction");
        this.getRootPane().getActionMap().put("CancelAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationViewer.this.cancel_actionPerformed(actionEvent);
            }
        });
        keyStroke = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(1).put(keyStroke, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationViewer.this.help_actionPerformed(actionEvent);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationViewer.this.help_actionPerformed(actionEvent);
            }
        };
        this.m_menuHelpContents.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_HELP_CONTENTS"));
        this.m_menuHelpContents.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_HELP_CONTENTS"));
        this.m_menuHelpContents.addActionListener(actionListener);
        this.m_menuFile.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_FILE"));
        this.m_menuFile.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_FILE"));
        this.m_menuFile.addSeparator();
        this.m_menuFile.add(this.m_menuFileExit);
        this.m_menuHelp.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_HELP"));
        this.m_menuHelp.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_HELP"));
        this.m_menuHelp.add(this.m_menuHelpContents);
        this.m_menuBar.add(this.m_menuFile);
        this.m_menuBar.add(this.m_menuHelp);
        this.m_model = this.createDataSource();
        if (this.m_model != null) {
            this.m_dataViewer = new DataSummarizationPanel(this, this.m_model);
            this.getContentPane().add((Component)this.m_dataViewer, "Center");
            this.m_dataViewer.loadDefaultValues();
            this.setTitle(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_VIEWER") + ": " + this.m_model.getDataSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SummarizeDataSource createDataSource() throws Exception {
        Connection connection = null;
        SummarizeDataSource summarizeDataSource = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            summarizeDataSource = this.m_bTx ? new SummarizeDataSource(connection, this.m_sourceTableName, this.m_sourceSchemaName, DM4JConnectionManager.getUser(), this.m_attributeMapping, this.m_valueMapping, this.m_seqIdMapping) : new SummarizeDataSource(connection, this.m_sourceTableName, this.m_sourceSchemaName, DM4JConnectionManager.getUser());
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), summarizeDataSource, true);
            summarizeDataSource.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), "");
            if (summarizeDataSource.getException() != null) {
                summarizeDataSource = null;
                this.m_userCancelled = true;
            } else if (progressBar.hasUserCancelled()) {
                summarizeDataSource = null;
                this.m_userCancelled = true;
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return summarizeDataSource;
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        Help.unregisterClientWindow((Window)this);
        this.setVisible(false);
        this.dispose();
    }

    private void help_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("dm4j_show_summary_html");
        }
        catch (Exception exception) {
            this.m_helpCxtMgr.showTopic("BrowserHelpTopics.BROWSER_INTRODUCTION");
        }
        this.setCursor(new Cursor(0));
    }
}

