/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.sort;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.association.RuleProperty;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;

public class SortPanel
extends GriddedPanel {
    private static final String NONE = "none";
    protected JLabel[] m_lblRules = new JLabel[3];
    protected JComboBox[] m_comboRules = new JComboBox[3];
    protected JLabel[] m_labelAsc = new JLabel[3];
    protected JLabel[] m_labelDesc = new JLabel[3];
    protected JRadioButton[] m_radioAsc = new JRadioButton[3];
    protected JRadioButton[] m_radioDesc = new JRadioButton[3];
    protected ButtonGroup[] m_group = new ButtonGroup[3];
    protected GriddedPanel[] m_panels = new GriddedPanel[3];
    protected DefaultComboBoxModel[] m_sortRules = new DefaultComboBoxModel[3];
    protected ComboActionListener[] m_actionListeners = new ComboActionListener[3];
    private int COMBO1 = 0;
    private int COMBO2 = 1;
    private int COMBO3 = 2;
    private static String[] m_labels;
    private static Hashtable m_htRuleNames;
    private Vector m_selectedRules = null;
    private Vector m_SelectedRulesSortOrder = null;
    private RuleProperty[] m_oldSortSriteria = null;
    private Boolean[] m_oldSortOrder = null;
    protected DM4JDialog m_parentDialog;
    EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);

    public SortPanel(DM4JDialog dM4JDialog, int n, RuleProperty[] rulePropertyArray, Boolean[] booleanArray) throws Exception {
        this.m_parentDialog = dM4JDialog;
        m_labels = new String[]{DM4JResourceUtilities.getUIString("SORT_RULES_SORT_BY"), DM4JResourceUtilities.getUIString("SORT_RULES_THEN_BY"), DM4JResourceUtilities.getUIString("SORT_RULES_THEN_BY")};
        m_htRuleNames.put(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_ID"), RuleProperty.lift);
        m_htRuleNames.put(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_SUPPORT"), RuleProperty.support);
        m_htRuleNames.put(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_CONFIDENCE"), RuleProperty.confidence);
        this.m_oldSortSriteria = rulePropertyArray;
        this.m_oldSortOrder = booleanArray;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        while (n < m_labels.length) {
            int n3 = 0;
            this.m_lblRules[n] = new JLabel();
            this.m_comboRules[n] = new JComboBox();
            this.m_sortRules[n] = new DefaultComboBoxModel();
            this.m_comboRules[n].setModel(this.m_sortRules[n]);
            this.fillCombo(n);
            this.m_lblRules[n].setText(m_labels[n]);
            this.m_lblRules[n].setLabelFor(this.m_comboRules[n]);
            this.m_radioAsc[n] = new JRadioButton();
            this.m_radioDesc[n] = new JRadioButton();
            this.m_labelAsc[n] = new JLabel();
            this.m_labelDesc[n] = new JLabel();
            this.m_labelAsc[n].setText(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"));
            this.m_labelDesc[n].setText(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"));
            this.m_labelAsc[n].setLabelFor(this.m_radioAsc[n]);
            this.m_labelDesc[n].setLabelFor(this.m_radioDesc[n]);
            this.m_group[n] = new ButtonGroup();
            this.m_group[n].add(this.m_radioAsc[n]);
            this.m_group[n].add(this.m_radioDesc[n]);
            this.m_actionListeners[n] = new ComboActionListener(n);
            this.m_comboRules[n].addActionListener(this.m_actionListeners[n]);
            if (this.m_oldSortOrder != null && this.m_oldSortOrder.length > n) {
                this.m_radioAsc[n].setSelected(this.m_oldSortOrder[n]);
                this.m_radioDesc[n].setSelected(this.m_oldSortOrder[n] == false);
            } else {
                this.m_radioAsc[n].setSelected(false);
                this.m_radioDesc[n].setSelected(true);
            }
            this.m_panels[n] = new GriddedPanel();
            this.m_panels[n].setBorder(new CompoundBorder(new TitledBorder(null, m_labels[n], 1, 2), this.border5));
            this.m_panels[n].addFilledComponent(this.m_comboRules[n], COL1_CONTROL, n3, 0, 2, 1, 2);
            this.m_panels[n].addAnchoredComponent(this.m_radioAsc[n], COL1_CONTROL, n3, 3, 1, 1, 13);
            this.m_panels[n].addAnchoredComponent(this.m_labelAsc[n], COL1_LABEL, n3++, 4, 1, 1, 17);
            this.m_panels[n].addAnchoredComponent(this.m_radioDesc[n], COL1_CONTROL, n3, 3, 1, 1, 13);
            this.m_panels[n].addAnchoredComponent(this.m_labelDesc[n], COL1_LABEL, n3++, 4, 1, 1, 17);
            this.addFilledComponent(this.m_panels[n], MIDLABELITEMINSETS, n2, 0, 4, 2, 1);
            ++n;
            n2 += 2;
        }
        this.enableOtherCombos();
        this.addOKHelpCancelListeners();
    }

    private void enableOtherCombos() {
        String string = (String)this.m_comboRules[this.COMBO1].getSelectedItem();
        RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(string);
        boolean bl = !ruleProperty.equals(RuleProperty.lift);
        this.m_comboRules[this.COMBO2].setEnabled(bl);
        this.m_comboRules[this.COMBO3].setEnabled(bl);
        this.m_radioAsc[this.COMBO2].setEnabled(bl);
        this.m_radioDesc[this.COMBO2].setEnabled(bl);
        this.m_radioAsc[this.COMBO3].setEnabled(bl);
        this.m_radioDesc[this.COMBO3].setEnabled(bl);
    }

    private String getRuleNameByValue(RuleProperty ruleProperty) {
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RuleProperty ruleProperty2 = (RuleProperty)m_htRuleNames.get(string);
            if (!ruleProperty.equals(ruleProperty2)) continue;
            return string;
        }
        return null;
    }

    protected void fillCombo(int n) {
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(string);
            if (n == this.COMBO1) {
                this.m_sortRules[n].addElement(string);
                if (this.m_oldSortSriteria != null && this.m_oldSortSriteria.length > n && this.m_oldSortSriteria[n] != null) {
                    this.m_sortRules[n].setSelectedItem(this.getRuleNameByValue(this.m_oldSortSriteria[n]));
                    continue;
                }
                if (!ruleProperty.equals(RuleProperty.confidence)) continue;
                this.m_sortRules[n].setSelectedItem(string);
                continue;
            }
            String string2 = (String)this.m_sortRules[this.COMBO1].getSelectedItem();
            if (0 == string.compareTo(string2)) {
                this.m_sortRules[n].addElement(NONE);
            } else {
                this.m_sortRules[n].addElement(string);
            }
            if (this.m_oldSortSriteria != null && this.m_oldSortSriteria.length > n && this.m_oldSortSriteria[n] != null) {
                this.m_sortRules[n].setSelectedItem(this.getRuleNameByValue(this.m_oldSortSriteria[n]));
                continue;
            }
            this.m_sortRules[n].setSelectedItem(NONE);
        }
    }

    protected void reloadNextCombo(int n) {
        this.m_actionListeners[n].enable(false);
        this.m_comboRules[n].removeAllItems();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.m_sortRules[i].getSelectedItem();
        }
        Enumeration enumeration = m_htRuleNames.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (0 != string.compareTo(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.m_sortRules[n].addElement(string);
        }
        this.m_sortRules[n].addElement(NONE);
        this.m_comboRules[n].setSelectedItem(NONE);
        this.m_actionListeners[n].enable(true);
    }

    protected void comboRule_actionPerformed(int n) {
        try {
            for (int i = n + 1; i <= this.COMBO3; ++i) {
                this.reloadNextCombo(i);
            }
            this.enableOtherCombos();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public RuleProperty[] getSortCriteria() {
        return this.m_selectedRules.toArray(new RuleProperty[this.m_selectedRules.size()]);
    }

    public Boolean[] getSortCriteriaOrder() {
        return this.m_SelectedRulesSortOrder.toArray(new Boolean[this.m_SelectedRulesSortOrder.size()]);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            try {
                this.processUserInput();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        this.m_selectedRules = new Vector();
        this.m_SelectedRulesSortOrder = new Vector();
        for (int i = 0; i < this.m_comboRules.length; ++i) {
            String string = (String)this.m_comboRules[i].getSelectedItem();
            RuleProperty ruleProperty = (RuleProperty)m_htRuleNames.get(string);
            if (ruleProperty == null) continue;
            this.m_selectedRules.add(i, ruleProperty);
            this.m_SelectedRulesSortOrder.add(i, new Boolean(this.m_radioAsc[i].isSelected()));
        }
    }

    static {
        m_htRuleNames = new Hashtable();
    }

    private class ComboActionListener
    implements ActionListener {
        int m_comboNumber = 0;
        boolean m_enable = true;

        ComboActionListener(int n) {
            this.m_comboNumber = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_enable) {
                SortPanel.this.comboRule_actionPerformed(this.m_comboNumber);
            }
        }

        public void enable(boolean bl) {
            this.m_enable = bl;
        }
    }
}

