/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.sort;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.datamining.association.RuleProperty;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.rule.Rule;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.viewer.classification.MiningABNRule;
import oracle.dmt.dm4j.browser.viewer.clustering.MiningClusteringRule;
import oracle.dmt.jdm.rule.OraABNRule;

public class MiningRuleQuickSort {
    private static final int LIMIT = 10;
    private static Class m_className;
    private MiningClusteringRule[] m_rules;
    private RuleProperty m_1stCriteria;
    private RuleProperty m_2ndCriteria;
    private RuleProperty m_3rdCriteria;
    private boolean sortOrder1stCriteria = true;
    private boolean sortOrder2ndCriteria = true;
    private boolean sortOrder3rdCriteria = true;
    private String[] m_comparisonFunction;
    private ClusteringModel m_model;
    private static Hashtable m_htRuleNames;
    private static int m_totalCount;

    public void setTotalCount(int n) {
        m_totalCount = n;
    }

    public static int getTotalCount() {
        return m_totalCount;
    }

    public MiningRuleQuickSort(ClusteringModel clusteringModel, Rule[] ruleArray, RuleProperty[] rulePropertyArray, Boolean[] booleanArray) throws Exception {
        if (ruleArray == null || ruleArray.length == 0) {
            throw new Exception();
        }
        if (rulePropertyArray == null || rulePropertyArray.length == 0) {
            throw new Exception();
        }
        this.m_model = clusteringModel;
        boolean bl = false;
        if (ruleArray[0] instanceof OraABNRule) {
            bl = true;
        }
        this.m_rules = new MiningClusteringRule[ruleArray.length];
        for (int i = 0; i < ruleArray.length; ++i) {
            this.m_rules[i] = bl ? new MiningABNRule((OraABNRule)ruleArray[i]) : new MiningClusteringRule(this.m_model, ruleArray[i]);
        }
        this.m_1stCriteria = rulePropertyArray[0];
        this.sortOrder1stCriteria = booleanArray[0];
        if (rulePropertyArray.length > 1) {
            this.m_2ndCriteria = rulePropertyArray[1];
            this.sortOrder2ndCriteria = booleanArray[1];
        }
        if (rulePropertyArray.length > 2) {
            this.m_3rdCriteria = rulePropertyArray[2];
            this.sortOrder3rdCriteria = booleanArray[2];
        }
        this.m_comparisonFunction = new String[rulePropertyArray.length];
    }

    public MiningClusteringRule[] sort() throws Exception {
        this.m_comparisonFunction[0] = (String)m_htRuleNames.get(this.m_1stCriteria);
        this.qsort(this.m_rules, 0, this.m_rules.length - 1, this.m_comparisonFunction[0], this.sortOrder1stCriteria);
        this.secondarySort();
        this.ternarySort();
        return this.m_rules;
    }

    private void swap(MiningClusteringRule[] miningClusteringRuleArray, int n, int n2) {
        MiningClusteringRule miningClusteringRule = miningClusteringRuleArray[n];
        miningClusteringRuleArray[n] = miningClusteringRuleArray[n2];
        miningClusteringRuleArray[n2] = miningClusteringRule;
    }

    private void qsort(MiningClusteringRule[] miningClusteringRuleArray, int n, int n2, String string, boolean bl) throws Exception {
        if (n + 10 > n2) {
            this.insertion(miningClusteringRuleArray, n, n2, string, bl);
        } else {
            int n3 = (n + n2) / 2;
            if (this.compare(miningClusteringRuleArray[n3], miningClusteringRuleArray[n], string, bl)) {
                this.swap(miningClusteringRuleArray, n, n3);
            }
            if (this.compare(miningClusteringRuleArray[n2], miningClusteringRuleArray[n], string, bl)) {
                this.swap(miningClusteringRuleArray, n, n2);
            }
            if (this.compare(miningClusteringRuleArray[n2], miningClusteringRuleArray[n3], string, bl)) {
                this.swap(miningClusteringRuleArray, n3, n2);
            }
            this.swap(miningClusteringRuleArray, n3, n2 - 1);
            MiningClusteringRule miningClusteringRule = miningClusteringRuleArray[n2 - 1];
            int n4 = n;
            int n5 = n2 - 1;
            while (true) {
                if (this.compare(miningClusteringRuleArray[++n4], miningClusteringRule, string, bl)) {
                    continue;
                }
                while (this.compare(miningClusteringRule, miningClusteringRuleArray[--n5], string, bl)) {
                }
                if (n4 >= n5) break;
                this.swap(miningClusteringRuleArray, n4, n5);
            }
            this.swap(miningClusteringRuleArray, n4, n2 - 1);
            this.qsort(miningClusteringRuleArray, n, n4 - 1, string, bl);
            this.qsort(miningClusteringRuleArray, n4 + 1, n2, string, bl);
        }
    }

    private void insertion(MiningClusteringRule[] miningClusteringRuleArray, int n, int n2, String string, boolean bl) throws Exception {
        for (int i = n + 1; i <= n2; ++i) {
            MiningClusteringRule miningClusteringRule = miningClusteringRuleArray[i];
            for (int j = i; j > n && this.compare(miningClusteringRule, miningClusteringRuleArray[j - 1], string, bl); --j) {
                miningClusteringRuleArray[j] = miningClusteringRuleArray[j - 1];
            }
            miningClusteringRuleArray[j] = miningClusteringRule;
        }
    }

    private Object getComaprisonValue(MiningClusteringRule miningClusteringRule, String string) throws Exception {
        Object object = null;
        try {
            if (m_className == null) {
                m_className = Class.forName("oracle.dmt.dm4j.browser.viewer.clustering.MiningClusteringRule");
            }
            Method method = m_className.getDeclaredMethod(string, new Class[0]);
            object = method.invoke((Object)miningClusteringRule, new Object[0]);
        }
        catch (Exception exception) {
            System.out.println("Function: " + string + " failed:" + exception);
            throw exception;
        }
        return object;
    }

    private boolean compare(MiningClusteringRule miningClusteringRule, MiningClusteringRule miningClusteringRule2, String string, boolean bl) throws Exception {
        Object object = this.getComaprisonValue(miningClusteringRule, string);
        Object object2 = this.getComaprisonValue(miningClusteringRule2, string);
        if (object instanceof Integer && object2 instanceof Integer) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (bl) {
                return n < n2;
            }
            return n > n2;
        }
        if (object instanceof Float && object2 instanceof Float) {
            float f = ((Float)object).floatValue();
            float f2 = ((Float)object2).floatValue();
            if (bl) {
                return f < f2;
            }
            return f > f2;
        }
        if (object instanceof Double && object2 instanceof Double) {
            double d = (Double)object;
            double d2 = (Double)object2;
            if (bl) {
                return d < d2;
            }
            return d > d2;
        }
        throw new Exception();
    }

    private boolean isEqual(MiningClusteringRule miningClusteringRule, MiningClusteringRule miningClusteringRule2, String string) throws Exception {
        Object object = this.getComaprisonValue(miningClusteringRule, string);
        Object object2 = this.getComaprisonValue(miningClusteringRule2, string);
        return object.equals(object2);
    }

    private boolean isEqual(MiningClusteringRule miningClusteringRule, MiningClusteringRule miningClusteringRule2, String string, String string2) throws Exception {
        Object object = this.getComaprisonValue(miningClusteringRule, string);
        Object object2 = this.getComaprisonValue(miningClusteringRule2, string);
        Object object3 = this.getComaprisonValue(miningClusteringRule, string2);
        Object object4 = this.getComaprisonValue(miningClusteringRule2, string2);
        return object.equals(object2) && object3.equals(object4);
    }

    private void secondarySort() throws Exception {
        if (this.m_1stCriteria.equals(RuleProperty.lift)) {
            return;
        }
        if (this.m_2ndCriteria == null) {
            return;
        }
        this.m_comparisonFunction[1] = (String)m_htRuleNames.get(this.m_2ndCriteria);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < this.m_rules.length - 1; ++i) {
            if (this.isEqual(this.m_rules[i], this.m_rules[i + 1], this.m_comparisonFunction[0])) {
                if (!bl) {
                    n = i;
                    bl = true;
                }
                n2 = i + 1;
                continue;
            }
            if (!bl) continue;
            this.qsort(this.m_rules, n, n2, this.m_comparisonFunction[1], this.sortOrder2ndCriteria);
            n = 0;
            n2 = 0;
            bl = false;
        }
        if (bl) {
            this.qsort(this.m_rules, n, n2, this.m_comparisonFunction[1], this.sortOrder2ndCriteria);
        }
    }

    private void ternarySort() throws Exception {
        if (this.m_1stCriteria.equals(RuleProperty.lift)) {
            return;
        }
        if (this.m_3rdCriteria == null) {
            return;
        }
        this.m_comparisonFunction[1] = (String)m_htRuleNames.get(this.m_2ndCriteria);
        this.m_comparisonFunction[2] = (String)m_htRuleNames.get(this.m_3rdCriteria);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < this.m_rules.length - 1; ++i) {
            if (this.isEqual(this.m_rules[i], this.m_rules[i + 1], this.m_comparisonFunction[0], this.m_comparisonFunction[1])) {
                if (!bl) {
                    n = i;
                    bl = true;
                }
                n2 = i + 1;
                continue;
            }
            if (!bl) continue;
            this.qsort(this.m_rules, n, n2, this.m_comparisonFunction[2], this.sortOrder3rdCriteria);
            n = 0;
            n2 = 0;
            bl = false;
        }
        if (bl) {
            this.qsort(this.m_rules, n, n2, this.m_comparisonFunction[2], this.sortOrder3rdCriteria);
        }
    }

    private void printRules(MiningClusteringRule[] miningClusteringRuleArray) {
        System.out.println("\n-----------------------------");
        for (int i = 0; i < miningClusteringRuleArray.length; ++i) {
            System.out.println("[" + i + "]=" + "ruleid[" + miningClusteringRuleArray[i].getRuleId() + "]=" + miningClusteringRuleArray[i].getSupport());
        }
    }

    static {
        m_htRuleNames = new Hashtable();
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        m_htRuleNames.put(RuleProperty.lift, "getRuleId");
        m_htRuleNames.put(RuleProperty.length, "getRuleLength");
        m_htRuleNames.put(RuleProperty.support, "getSupport");
        m_htRuleNames.put(RuleProperty.confidence, "getConfidence");
    }
}

