/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.test;

import java.text.NumberFormat;
import javax.datamining.data.CategoryMatrix;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;

public class ConfusionMatrixTableModel
extends Dm4jSortableTwoDModel {
    boolean m_bShowFloats = false;

    public void load(Object object) {
        String string = null;
        CategoryMatrix categoryMatrix = (CategoryMatrix)object;
        Object[] objectArray = ((CategoryMatrix)object).getCategories().toArray();
        String[] stringArray = null;
        if (objectArray != null) {
            int n;
            stringArray = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                stringArray[n] = objectArray[n].toString();
            }
            n = stringArray.length;
            this.addRows(0, n);
            this.addColumns(0, n);
            NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 8);
            NumberFormat numberFormat2 = DM4JNumericFormat.getInstance();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    try {
                        Double d = categoryMatrix.getValue(objectArray[i], objectArray[j]);
                        string = this.m_bShowFloats ? numberFormat.format(d) : numberFormat2.format(new Integer(d.intValue()));
                        this.setData(j, i, string);
                        continue;
                    }
                    catch (Exception exception) {
                        this.setData(j, i, DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                    }
                }
            }
        }
    }

    public void setShowFloats(boolean bl) {
        this.m_bShowFloats = bl;
    }
}

