/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.Color;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;
import oracle.dss.graph.Graph;

public class ResidualPlotTableModel
extends Dm4jSortableTwoDModel {
    private Double[] m_residual = null;
    private Double[] m_predicted = null;
    private Double[][] m_data = null;
    private Double m_targetShift = null;
    private Double m_targetScale = null;

    public void load(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object object, int n, String[] stringArray, String string, boolean bl, Graph graph, Hashtable hashtable, String string2, boolean bl2, JLabel jLabel) {
        OraMiningApplyResult oraMiningApplyResult = (OraMiningApplyResult)object;
        String string3 = oraMiningApplyResult.getSchemaName();
        String string4 = oraMiningApplyResult.getApplyOutputTableName();
        String string5 = bl ? "ASC" : "DESC";
        String string6 = string;
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\"" + stringArray[i] + "\"");
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            connection = DM4JConnectionManager.getDbConnection();
            String string7 = null;
            string7 = bl2 ? "SELECT " + stringBuffer.toString() + " FROM (SELECT t.*, ROWNUM RNUM FROM " + string3 + "." + string4 + " t ) " + " WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string3 + "." + string4 + " ) -1),12345) < " + n + " ORDER BY " + "\"" + string2 + "\"" : "SELECT " + stringBuffer.toString() + " FROM (SELECT t.*, ROWNUM RNUM FROM " + string3 + "." + string4 + " t ) " + " WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string3 + "." + string4 + " ) -1),12345) < " + n + " ORDER BY PREDICTION ";
            statement = connection.createStatement();
            statement.setMaxRows(n);
            resultSet = statement.executeQuery(string7);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.addRows(0, n);
            this.addColumns(0, n2);
            int n3 = 0;
            while (resultSet.next()) {
                int n4;
                double d = 0.0;
                double d2 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    int n5 = resultSetMetaData.getColumnType(n4 + 1);
                    int n6 = resultSetMetaData.getScale(n4 + 1);
                    if (n5 == 2) {
                        double d3 = resultSet.getDouble(n4 + 1);
                        String string8 = resultSetMetaData.getColumnName(n4 + 1);
                        if (string8.compareTo("PREDICTION") == 0 || string8.compareTo(string2) == 0) {
                            if (hashtable != null && string2 != null) {
                                if (this.m_targetShift == null && this.m_targetScale == null) {
                                    String string9 = (String)hashtable.get("XNORM");
                                    DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                                    Hashtable hashtable2 = dMEMetadata.getRegressionNormTableDetails(connection, string9, string2);
                                    if (hashtable2 != null) {
                                        this.m_targetShift = (Double)hashtable2.get("SHIFT");
                                        this.m_targetScale = (Double)hashtable2.get("SCALE");
                                    }
                                }
                                d3 = d3 * this.m_targetScale + this.m_targetShift;
                            }
                            if (string8.compareTo("PREDICTION") == 0) {
                                d2 = d3;
                            } else if (string8.compareTo(string2) == 0) {
                                d = d3;
                            }
                        }
                        this.setData(n4, n3, new Float(d3));
                        continue;
                    }
                    String string10 = resultSet.getString(n4 + 1);
                    this.setData(n4, n3, string10);
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    Object[] objectArray = new Object[3];
                    if (bl2) {
                        objectArray[0] = n4 == 0 ? "Actual" : "Residual";
                        objectArray[1] = n3 + ":Predicted=" + DM4JNumericFormat.format(d2, false, 4);
                        objectArray[2] = n4 == 0 ? new Double(d2) : new Double(d - d2);
                    } else {
                        objectArray[0] = n4 == 0 ? "Predicted" : "Residual";
                        objectArray[1] = n3 + ":Actual=" + DM4JNumericFormat.format(d, false, 4);
                        objectArray[2] = n4 == 0 ? new Double(d2) : new Double(d - d2);
                    }
                    arrayList.add(objectArray);
                }
                ++n3;
            }
            this.loadGraph(graph, arrayList, jLabel);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void loadGraph(Graph graph, ArrayList arrayList, JLabel jLabel) throws Exception {
        if (graph != null) {
            graph.setTabularData((List)arrayList);
            if (jLabel != null) {
                jLabel.setText("");
            }
            int n = graph.getDisplaySeries();
            graph.getY1ZeroLine().setVisible(true);
            graph.getY1ZeroLine().setLineColor(Color.RED);
            graph.setVisible(true);
        }
    }
}

