/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Locale;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderMoveAdapter;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.results.apply.PredictOutputTableModel;
import oracle.dmt.dm4j.browser.worker.LoadPredictOutputWorker;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.PredictOutputLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;

public final class PredictOutputTable
extends Dm4jSpreadTable
implements PredictOutputLoadedListener {
    String[] m_columnNames = null;
    Painter[] m_columnPainters = null;
    int m_rows = 100;
    int[] m_colSortOrders = null;
    int m_curSortOrder = 1;
    boolean m_bColumnMoved = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictOutputTable(Object object) {
        super(object);
        OraMiningPredictResult oraMiningPredictResult = (OraMiningPredictResult)object;
        Statement statement = null;
        ResultSet resultSet = null;
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = DM4JConnectionManager.getUser();
            String string2 = oraMiningPredictResult.getPredictOutputTableName();
            String string3 = "SELECT * FROM " + string + "." + string2;
            statement = connection.createStatement();
            statement.setMaxRows(1);
            resultSet = statement.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.m_columnNames = new String[n];
            this.m_columnPainters = new Painter[n];
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
            DecimalFormat decimalFormat = null;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                decimalFormat.setMaximumFractionDigits(4);
            }
            for (int i = 0; i < n; ++i) {
                String string4 = resultSetMetaData.getColumnName(i + 1);
                this.m_columnNames[i] = new String(string4);
                int n2 = resultSetMetaData.getColumnType(i + 1);
                int n3 = resultSetMetaData.getScale(i + 1);
                this.m_columnPainters[i] = n2 == 2 && decimalFormat != null ? new FormatPainter((Format)decimalFormat) : this.getGrid().getColumnPainter(i);
            }
            this.setColumnNames(this.m_columnNames);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colSortOrders = new int[this.m_columnNames.length];
        for (int i = 0; i < this.m_colSortOrders.length; ++i) {
            this.m_colSortOrders[i] = 0;
        }
    }

    public void load() throws Exception {
        this.load(this.m_rows);
    }

    public void load(int n) throws Exception {
        this.load(n, null, false);
    }

    public void load(int n, String string, boolean bl) throws Exception {
        Object object;
        Object object2;
        this.m_rows = n;
        if (this.m_bColumnMoved) {
            int n2;
            int n3 = this.m_columnNames.length;
            object2 = new String[n3];
            object = new Painter[n3];
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                n2 = this.getGrid().getColumnVisibleIndex(i);
                object2[n2] = this.m_columnNames[i];
                object[n2] = this.m_columnPainters[i];
                nArray[n2] = this.m_colSortOrders[i];
            }
            System.arraycopy(object2, 0, this.m_columnNames, 0, ((Object)object2).length);
            System.arraycopy(object, 0, this.m_columnPainters, 0, ((Object)object).length);
            System.arraycopy(nArray, 0, this.m_colSortOrders, 0, nArray.length);
            ArrayOneDModel arrayOneDModel = this.getColModel();
            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                arrayOneDModel.setData(n2, object2[n2]);
            }
            this.m_bColumnMoved = false;
        }
        this.setColumnWidths(null, false);
        OraMiningPredictResult oraMiningPredictResult = (OraMiningPredictResult)this.getDataItem();
        if (null == oraMiningPredictResult) {
            throw new Exception("Cannot load data. OraMiningPredictResult not supplied");
        }
        object2 = WorkerThreadManager.getInstance();
        object = (LoadPredictOutputWorker)((WorkerThreadManager)object2).getLoadPredictOutputWorker(oraMiningPredictResult, n, this.m_columnNames, string, bl);
        ((LoadPredictOutputWorker)object).addPredictOutputLoadedListener(this);
        ((SwingWorker)object).start();
    }

    public void displayLoadingStatus() throws Exception {
        if (this.m_bColumnMoved) {
            int n;
            int n2 = this.m_columnNames.length;
            String[] stringArray = new String[n2];
            Painter[] painterArray = new Painter[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                n = this.getGrid().getColumnVisibleIndex(i);
                stringArray[n] = this.m_columnNames[i];
                painterArray[n] = this.m_columnPainters[i];
                nArray[n] = this.m_colSortOrders[i];
            }
            System.arraycopy(stringArray, 0, this.m_columnNames, 0, stringArray.length);
            System.arraycopy(painterArray, 0, this.m_columnPainters, 0, painterArray.length);
            System.arraycopy(nArray, 0, this.m_colSortOrders, 0, nArray.length);
            ArrayOneDModel arrayOneDModel = this.getColModel();
            for (n = 0; n < stringArray.length; ++n) {
                arrayOneDModel.setData(n, (Object)stringArray[n]);
            }
            this.m_bColumnMoved = false;
        }
        super.displayLoadingStatus();
    }

    public void tableLoaded(EventObject eventObject) {
        this.setVerticalSeparatorsVisible(true);
        PredictOutputTableModel predictOutputTableModel = (PredictOutputTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)predictOutputTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(predictOutputTableModel));
        header.setCanMoveItems(true);
        header.addMoveListener((HeaderMoveListener)new HdrMoveListener());
        Grid grid = this.getGrid();
        for (int i = 0; i < this.m_columnPainters.length; ++i) {
            grid.setColumnPainter(i, this.m_columnPainters[i]);
        }
        try {
            this.setColumnWidths(null, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        public SortHandler(SortableTwoDModel sortableTwoDModel) {
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = PredictOutputTable.this.m_colSortOrders[n];
                if (n2 == 0) {
                    n2 = PredictOutputTable.this.m_curSortOrder;
                } else if (n2 == 1) {
                    n2 = 2;
                } else if (n2 == 2) {
                    n2 = 1;
                }
                PredictOutputTable.this.m_colSortOrders[n] = n2;
                PredictOutputTable.this.m_curSortOrder = n2;
                PredictOutputTable.this.load(PredictOutputTable.this.m_rows, PredictOutputTable.this.m_columnNames[n], n2 == 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }

    private class HdrMoveListener
    extends HeaderMoveAdapter {
        private HdrMoveListener() {
        }

        public void itemMoved(HeaderEvent headerEvent) {
            super.itemMoved(headerEvent);
            PredictOutputTable.this.m_bColumnMoved = true;
        }

        public void itemMoving(HeaderEvent headerEvent) {
            super.itemMoving(headerEvent);
        }
    }
}

