/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.resource.Connection;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.SimplePredicate;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.results.apply.RuleDisplayDialog;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;

public class NodeDisplayPanel
extends GriddedPanel {
    RuleDisplayDialog m_parentDialog;
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private JLabel lblRule = new JLabel();
    private JTextArea txtRule = new JTextArea();
    private JScrollPane scrollRule = new JScrollPane();
    private JRadioButton m_radioSurrogate = new JRadioButton();
    private JRadioButton m_radioFullRule = new JRadioButton();
    private OraMiningApplyResult m_mar = null;
    private int m_nodeId;
    private StringBuffer m_surrogate = null;
    private StringBuffer m_fullRule = null;
    private boolean m_bShowFullRule = true;

    public NodeDisplayPanel(RuleDisplayDialog ruleDisplayDialog, OraMiningApplyResult oraMiningApplyResult, int n) throws Exception {
        this.m_mar = oraMiningApplyResult;
        this.m_nodeId = n;
        this.m_parentDialog = ruleDisplayDialog;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getUIString("APPLY_RESULT_RULE_VIEWER_DESC"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, new Insets(10, 0, 10, 0), n++, 0, 3, 1, 1);
        n += 2;
        this.lblRule.setText(DM4JResourceUtilities.getUIString("COMMON_NODE_DETAIL"));
        this.lblRule.setLabelFor(this.txtRule);
        this.addComponent(this.lblRule, new Insets(5, 0, 0, 0), n++, 0);
        this.txtRule.setEditable(false);
        this.txtRule.setLineWrap(true);
        this.txtRule.setWrapStyleWord(true);
        this.scrollRule.getViewport().add(this.txtRule);
        this.addFilledComponent(this.scrollRule, new Insets(5, 0, 0, 0), n++, 0, 3, 2, 1);
        this.m_radioFullRule.setText(DM4JResourceUtilities.getUIString("TREE_NODE_FULL_RULE"));
        this.m_radioSurrogate.setText(DM4JResourceUtilities.getUIString("TREE_NODE_SURROGATE"));
        this.m_radioFullRule.setSelected(true);
        this.m_radioSurrogate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeDisplayPanel.this.m_bShowFullRule = false;
                NodeDisplayPanel.this.displayNode(NodeDisplayPanel.this.m_nodeId);
            }
        });
        this.m_radioFullRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeDisplayPanel.this.m_bShowFullRule = true;
                NodeDisplayPanel.this.displayNode(NodeDisplayPanel.this.m_nodeId);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_radioFullRule);
        buttonGroup.add(this.m_radioSurrogate);
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
        this.displayNode(this.m_nodeId);
    }

    protected void displayNode(int n) {
        this.setCursor(new Cursor(3));
        final int n2 = n;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                NodeDisplayPanel.this.txtRule.setText(DM4JResourceUtilities.getUIString("COMMON_LOADING"));
                try {
                    connection = DM4JConnectionManager.getConnection();
                    ClassificationModel classificationModel = (ClassificationModel)connection.retrieveObject(NodeDisplayPanel.this.m_mar.getMiningModel().toUpperCase(), NamedObject.model);
                    TreeModelDetail treeModelDetail = (TreeModelDetail)classificationModel.getModelDetail();
                    TreeNode treeNode = treeModelDetail.getNode(n2);
                    String string = DM4JResourceUtilities.getUIString("COMMON_RULES_IF");
                    String string2 = DM4JResourceUtilities.getUIString("COMMON_RULES_THEN");
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.append("\n");
                    if (NodeDisplayPanel.this.m_bShowFullRule) {
                        stringBuffer.append(NodeDisplayPanel.this.showFullRule(treeModelDetail, treeNode));
                    } else {
                        stringBuffer.append(NodeDisplayPanel.this.loadSurrogate(treeNode));
                    }
                    stringBuffer.append("\n\n");
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                    stringBuffer.append(NodeDisplayPanel.this.showTarget(treeModelDetail, treeNode));
                    float f = 0.0f;
                    float f2 = 0.0f;
                    long l = treeNode.getCaseCount();
                    long l2 = treeModelDetail.getRootNode().getCaseCount();
                    Object object = treeNode.getPrediction();
                    long l3 = treeNode.getTargetCount(object);
                    f2 = (float)l / (float)l2;
                    f = (float)l3 / (float)l;
                    stringBuffer.append("\n\n");
                    stringBuffer.append(DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE") + "=" + NodeDisplayPanel.this.toPercent(f));
                    stringBuffer.append("\n");
                    stringBuffer.append(DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT") + "=" + NodeDisplayPanel.this.toPercent(f2));
                    NodeDisplayPanel.this.txtRule.setText(stringBuffer.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.setCursor(new Cursor(0));
    }

    private String toPercent(float f) {
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 2, 2);
        double d = (double)f * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(2, 4);
        d = bigDecimal.doubleValue();
        String string = numberFormat.format(d);
        return string;
    }

    private String showFullRule(TreeModelDetail treeModelDetail, TreeNode treeNode) {
        if (this.m_fullRule != null && 0 != this.m_fullRule.toString().compareTo(DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR"))) {
            return this.m_fullRule.toString();
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        this.m_fullRule = new StringBuffer();
        try {
            TreeNode treeNode2 = treeModelDetail.getRootNode();
            while (treeNode.getIdentifier() != treeNode2.getIdentifier()) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                TreeNode treeNode3 = (TreeNode)arrayList.get(i);
                this.m_fullRule.append(treeNode3.getPredicate().toString());
                if (i == arrayList.size() - 1) continue;
                this.m_fullRule.append(DM4JResourceUtilities.getUIString("TREE_NODE_RULE_AND"));
            }
        }
        catch (Exception exception) {
            this.m_fullRule = new StringBuffer(DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR"));
            exception.printStackTrace();
        }
        return this.m_fullRule.toString();
    }

    private String loadSurrogate(TreeNode treeNode) {
        if (this.m_surrogate != null && 0 != this.m_surrogate.toString().compareTo(DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR"))) {
            return this.m_surrogate.toString();
        }
        try {
            Predicate[] predicateArray = treeNode.getSurrogates();
            this.m_surrogate = new StringBuffer();
            if (predicateArray != null) {
                for (int i = 0; i < predicateArray.length; ++i) {
                    String string = Integer.toString(i) + ": " + predicateArray[i].toString();
                    this.m_surrogate.append(string + "\n");
                }
            }
        }
        catch (Exception exception) {
            this.m_surrogate = new StringBuffer(DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR"));
            exception.printStackTrace();
        }
        return this.m_surrogate.toString();
    }

    private String showTarget(TreeModelDetail treeModelDetail, TreeNode treeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Rule rule = treeModelDetail.getRule(treeNode.getIdentifier());
            Predicate predicate = rule.getConsequent();
            if (predicate == null) {
                return stringBuffer.toString();
            }
            Vector vector = new Vector();
            this.unnestConsequent(predicate, vector);
            for (int i = 0; i < vector.size(); ++i) {
                StringBuffer stringBuffer2 = (StringBuffer)vector.elementAt(i);
                if (i < vector.size() - 1) {
                    stringBuffer2.append(" AND\n");
                }
                stringBuffer.append(stringBuffer2.toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Error printing Consequent");
            stringBuffer = new StringBuffer();
        }
        return stringBuffer.toString();
    }

    private void unnestConsequent(Predicate predicate, Vector vector) {
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            Predicate[] predicateArray = compoundPredicate.getPredicates();
            for (int i = 0; i < predicateArray.length; ++i) {
                this.unnestConsequent(predicateArray[i], vector);
            }
            return;
        }
        SimplePredicate simplePredicate = (SimplePredicate)predicate;
        StringBuffer stringBuffer = RuleDisplayDialog.getSimplePredicateString(simplePredicate);
        vector.add(stringBuffer);
    }
}

