/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;

public class MiningApplyOutputPanel
extends GriddedPanel {
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private JScrollPane scrTablePane = new JScrollPane();
    private DM4JDialog m_parentDialog;
    private JTable m_attributes = null;
    private TableSorter m_sorter = null;
    private OneDModel m_cols;
    private MiningApplyOutputTableModel m_tableModel = new MiningApplyOutputTableModel();
    private String m_selection;
    private String m_nodePrefix;
    private static String[] columnNames = new String[]{DM4JResourceUtilities.getUIString("MINING_APPLY_OUTPUT_COLUMN_NAME")};

    public MiningApplyOutputPanel(DM4JDialog dM4JDialog, OneDModel oneDModel, String string) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_cols = oneDModel;
        this.m_nodePrefix = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getUIString("MINING_APPLY_OUTPUT_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_attributes = new JTable(this.m_sorter);
        this.m_attributes.setAutoCreateColumnsFromModel(false);
        this.m_sorter.setTableHeader(this.m_attributes.getTableHeader());
        this.m_attributes.setRowSelectionAllowed(true);
        this.scrTablePane.getViewport().add(this.m_attributes);
        this.addFilledComponent(this.scrTablePane, COL_VALUE, n, 0, 5, 3, 1);
        this.addOKHelpCancelListeners();
        this.fillTable();
    }

    private void fillTable() {
        for (int i = 0; i < this.m_cols.getItemCount(); ++i) {
            String string = (String)this.m_cols.getData(i);
            if (!string.startsWith(this.m_nodePrefix)) continue;
            this.m_tableModel.addEntry(string);
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningApplyOutputPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            try {
                this.processUserInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processUserInput() {
        int n = this.m_attributes.getSelectedRow();
        this.m_selection = (String)this.m_tableModel.getValueAt(n, 0);
    }

    public String getSelected() {
        return this.m_selection;
    }

    class MiningApplyOutputTableModel
    extends AbstractTableModel {
        private List m_fieldEntries = Collections.synchronizedList(new ArrayList(0));

        MiningApplyOutputTableModel() {
        }

        public void addEntry(String string) {
            this.m_fieldEntries.add(string);
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            return this.m_fieldEntries.size();
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = (String)this.m_fieldEntries.get(n);
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

