/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.regression;

import java.awt.EventQueue;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.regression.SVMRegressionSettings;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelGlobalDetailsPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.GLMModelContentPanel;
import oracle.dmt.dm4j.browser.viewer.classification.GLMRowDiagnosticsPanel;
import oracle.dmt.dm4j.browser.viewer.regression.RegressionSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.regression.SVMRegressionModelContentPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;
import oracle.dmt.jdm.supervised.regression.OraRegressionSettings;

public class RegressionModelViewer
extends ModelViewer {
    static int SETTING_TAB = 0;
    static int CONTENT_TAB = 1;
    static int RESULT_TAB = 2;
    static int TASK_TAB = 3;
    static int GLM_ROW_DIAGNOSTICS_TAB = 4;
    static int GLOBAL_DETAILS_TAB = 5;
    static int GLM_CONTENT_TAB = 6;
    int[] m_tabIndex;
    RegressionSettingsPanel m_regressionSettingsPanel;
    SVMRegressionModelContentPanel m_SVMRegressionModelContentPanel;
    BrowseResultsListPanel m_browseResultsListPanel;
    BuildTaskPanel m_buildTaskPanel;
    OraMiningBuildResult m_buldTask;
    GLMRowDiagnosticsPanel m_rowDiagnosticsPanel;
    ModelGlobalDetailsPanel m_globalDetailsPanel;
    GLMModelContentPanel m_GLMRegressionModelContentPanel;

    public RegressionModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        RegressionModel regressionModel = (RegressionModel)leafNodeData.getOdmObject();
        MiningAlgorithm miningAlgorithm = regressionModel.getMiningAlgorithm();
        int n2 = 0;
        this.m_tabIndex = new int[5];
        if (miningAlgorithm.equals(MiningAlgorithm.svmRegression)) {
            RegressionModel regressionModel2 = (RegressionModel)leafNodeData.getOdmObject();
            SVMRegressionSettings sVMRegressionSettings = (SVMRegressionSettings)regressionModel2.getBuildSettings().getAlgorithmSettings();
            if (sVMRegressionSettings.getKernelFunction().equals(KernelFunction.kLinear)) {
                this.addTab(DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS"));
                this.m_tabIndex[n2++] = CONTENT_TAB;
            }
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.generalizedLinearModel)) {
            String string = DM4JResourceUtilities.getUIString("GLM_ROW_DIAG_TAB_NAME");
            String string2 = DM4JResourceUtilities.getUIString("GLM_GLOBAL_STATISTICS");
            String string3 = DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS");
            this.m_tabIndex = new int[6];
            try {
                OraRegressionSettings oraRegressionSettings = (OraRegressionSettings)regressionModel.getBuildSettings();
                OraGLMRegressionSettings oraGLMRegressionSettings = (OraGLMRegressionSettings)regressionModel.getBuildSettings().getAlgorithmSettings();
                this.addTab(string2, null, new LoadingStatusPanel(), string2);
                this.m_tabIndex[n2++] = GLOBAL_DETAILS_TAB;
                this.addTab(string3, null, new LoadingStatusPanel(), string3);
                this.m_tabIndex[n2++] = GLM_CONTENT_TAB;
                if (oraGLMRegressionSettings.getDiagnosticsTableName() != null) {
                    if (oraGLMRegressionSettings.getDiagnosticsTableName().length() != 0) {
                        this.addTab(string, null, new LoadingStatusPanel(), string);
                    }
                    this.m_tabIndex[n2++] = GLM_ROW_DIAGNOSTICS_TAB;
                }
            }
            catch (Exception exception) {
                System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
                exception.printStackTrace();
            }
        }
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RESULTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RESULTS"));
        this.m_tabIndex[n2++] = RESULT_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        public void run() {
            try {
                RegressionModel regressionModel = (RegressionModel)RegressionModelViewer.this.m_node.getOdmObject();
                this.panel = null;
                if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (RegressionModelViewer.this.m_regressionSettingsPanel == null) {
                        RegressionModelViewer.this.m_regressionSettingsPanel = new RegressionSettingsPanel(regressionModel);
                    }
                    this.panel = RegressionModelViewer.this.m_regressionSettingsPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == CONTENT_TAB) {
                    if (RegressionModelViewer.this.m_SVMRegressionModelContentPanel == null) {
                        RegressionModelViewer.this.m_SVMRegressionModelContentPanel = new SVMRegressionModelContentPanel(RegressionModelViewer.this.m_node);
                    }
                    this.panel = RegressionModelViewer.this.m_SVMRegressionModelContentPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == RESULT_TAB) {
                    if (RegressionModelViewer.this.m_browseResultsListPanel == null) {
                        RegressionModelViewer.this.m_browseResultsListPanel = new BrowseResultsListPanel(RegressionModelViewer.this.m_node);
                    }
                    this.panel = RegressionModelViewer.this.m_browseResultsListPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (RegressionModelViewer.this.m_buildTaskPanel == null) {
                        RegressionModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(regressionModel.getName());
                    }
                    this.panel = RegressionModelViewer.this.m_buildTaskPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == GLOBAL_DETAILS_TAB) {
                    if (RegressionModelViewer.this.m_globalDetailsPanel == null) {
                        RegressionModelViewer.this.m_globalDetailsPanel = new ModelGlobalDetailsPanel(RegressionModelViewer.this.m_node);
                    }
                    RegressionModelViewer.this.m_globalDetailsPanel.resize();
                    this.panel = RegressionModelViewer.this.m_globalDetailsPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == GLM_CONTENT_TAB) {
                    if (RegressionModelViewer.this.m_GLMRegressionModelContentPanel == null) {
                        RegressionModelViewer.this.m_GLMRegressionModelContentPanel = new GLMModelContentPanel(RegressionModelViewer.this.m_node);
                    }
                    this.panel = RegressionModelViewer.this.m_GLMRegressionModelContentPanel;
                } else if (RegressionModelViewer.this.m_tabIndex[this.tabIndex] == GLM_ROW_DIAGNOSTICS_TAB) {
                    if (RegressionModelViewer.this.m_rowDiagnosticsPanel == null) {
                        RegressionModelViewer.this.m_rowDiagnosticsPanel = new GLMRowDiagnosticsPanel(RegressionModelViewer.this.m_node);
                    }
                    this.panel = RegressionModelViewer.this.m_rowDiagnosticsPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        RegressionModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

