/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.folder;

import java.sql.Connection;
import java.sql.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.JLabelNode;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class ResultsTableModel
extends AbstractTableModel {
    String m_type = null;
    Vector m_rows = null;
    public static final int NAME_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int ACTIVITY_NAME_COLUMN = 2;
    public static final int MODEL_NAME_COLUMN = 3;
    public static final int CREATION_DATE_COLUMN = 4;
    public static final int TASK_NAME_COLUMN = 5;
    private static String[] columns = new String[]{"Name", "Type", "Activity Name", "Model Name", "Creation Date", "Server Task Name"};
    private static final int COLUMN_COUNT = columns.length;

    public ResultsTableModel(String string) {
        this.m_type = string;
        this.loadFolder(this.m_type);
    }

    public void refreshFolder() {
        this.loadFolder(this.m_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFolder(String string) {
        Connection connection = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("DMS_CONNECTION_NOCREATE"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        try {
            if (string.equals("APPLY_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "APPLY", null);
            } else if (string.equals("BUILD_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "BUILD", null);
            } else if (string.equals("EXPLAIN_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "EXPLN", null);
            } else if (string.equals("PREDICT_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "PRDCT", null);
            } else if (string.equals("RESIDUAL_PLOT_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "PLOT", null);
            } else if (string.equals("TEST_METRICS_RESULTS")) {
                this.m_rows = DMEMetadata.getResultList(connection, "TEST", null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return JLabelNode.class;
        }
        if (n == 4) {
            return Date.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = (Object[])this.m_rows.get(n);
        if (objectArray != null) {
            return objectArray[n2];
        }
        return null;
    }
}

