/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.featureExtraction;

import java.text.Collator;
import java.util.EventObject;
import java.util.HashMap;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.AbsoluteNumberComparator;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.LoadNMFFeaturesWorker;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.jdm.data.OraAttributeCoefficient;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;

public final class NMFFeaturesTable
extends Dm4jSpreadTable
implements NMFFeaturesLoadedListener {
    private LoadNMFFeaturesWorker m_worker = null;
    private NMFFeaturesTableModel m_tableModel;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("FEATU_TBL_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("FEATU_TBL_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("FEATU_TBL_COEFFICIENT")};
    int[] m_colWidths = new int[]{40, 40, 20};

    public NMFFeaturesTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(Integer n, HashMap hashMap) throws Exception {
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setColumnWidths(this.m_colWidths, true);
        OraFeatureExtractionModel oraFeatureExtractionModel = (OraFeatureExtractionModel)this.getDataItem();
        if (null == oraFeatureExtractionModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadNMFFeaturesWorker)workerThreadManager.getLoadNMFFeaturesWorker(oraFeatureExtractionModel, n, hashMap);
        this.m_worker.addNMFFeaturesLoadedListener(this);
        this.m_worker.start();
    }

    public void setSortAbsoluteCoefficient(boolean bl) {
        if (this.m_tableModel != null) {
            if (bl) {
                this.m_tableModel.setColumnComparator(2, AbsoluteNumberComparator.getComparator());
            } else {
                this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
            }
        }
    }

    public void nmfFeaturesLoaded(EventObject eventObject) {
        Grid grid;
        NMFFeaturesTableModel nMFFeaturesTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = nMFFeaturesTableModel = (NMFFeaturesTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)nMFFeaturesTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        header.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, (Comparator)new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, (Comparator)new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                grid = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)grid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        grid = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        grid.setColumnPainter(2, (Painter)dM4JTruncatingNumberFormatPainter);
    }

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_tableModel.getAttributeCoefficient(n);
    }
}

