/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.featureExtraction;

import java.util.EventObject;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;

public class LoadNMFFeaturesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private OraFeatureExtractionModel m_miningModel = null;
    private NMFFeaturesTableModel m_tableModel = null;
    private Integer m_featureId = null;
    private HashMap m_condition = null;

    public LoadNMFFeaturesWorker(WorkerThreadManager workerThreadManager, OraFeatureExtractionModel oraFeatureExtractionModel, Integer n, HashMap hashMap) {
        super(workerThreadManager);
        this.m_miningModel = oraFeatureExtractionModel;
        this.m_featureId = n;
        this.m_condition = hashMap;
    }

    public void addNMFFeaturesLoadedListener(NMFFeaturesLoadedListener nMFFeaturesLoadedListener) {
        this.listenerList.add(NMFFeaturesLoadedListener.class, nMFFeaturesLoadedListener);
    }

    public void removeNMFFeaturesLoadedListener(NMFFeaturesLoadedListener nMFFeaturesLoadedListener) {
        this.listenerList.remove(NMFFeaturesLoadedListener.class, nMFFeaturesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new NMFFeaturesTableModel();
            this.m_tableModel.load(this.m_miningModel, this.m_featureId, this.m_condition);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NMFFeaturesLoadedListener.class) continue;
            ((NMFFeaturesLoadedListener)objectArray[i + 1]).nmfFeaturesLoaded(new EventObject(this.getValue()));
        }
    }
}

