/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.featureExtraction;

import java.awt.EventQueue;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.FeatureExtractionSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;

public class FeatureExtractionModelViewer
extends ModelViewer {
    static int SETTING_TAB = 0;
    static int FEATURE_TAB = 1;
    static int RESULT_TAB = 2;
    static int TASK_TAB = 3;
    int[] m_tabIndex;
    FeatureExtractionSettingsPanel m_featureExtractionSettingsPanel;
    NMFFeaturesPanel m_NMFFeaturesPanel;
    BrowseResultsListPanel m_browseResultsListPanel;
    BuildTaskPanel m_buildTaskPanel;
    OraMiningBuildResult m_buldTask;

    public FeatureExtractionModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        OraFeatureExtractionModel oraFeatureExtractionModel = (OraFeatureExtractionModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[4];
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_FEATURES"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_FEATURES"));
        this.m_tabIndex[n2++] = FEATURE_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RESULTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RESULTS"));
        this.m_tabIndex[n2++] = RESULT_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        public void run() {
            try {
                OraFeatureExtractionModel oraFeatureExtractionModel = (OraFeatureExtractionModel)FeatureExtractionModelViewer.this.m_node.getOdmObject();
                this.panel = null;
                if (FeatureExtractionModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (FeatureExtractionModelViewer.this.m_featureExtractionSettingsPanel == null) {
                        FeatureExtractionModelViewer.this.m_featureExtractionSettingsPanel = new FeatureExtractionSettingsPanel(oraFeatureExtractionModel);
                    }
                    this.panel = FeatureExtractionModelViewer.this.m_featureExtractionSettingsPanel;
                } else if (FeatureExtractionModelViewer.this.m_tabIndex[this.tabIndex] == FEATURE_TAB) {
                    if (FeatureExtractionModelViewer.this.m_NMFFeaturesPanel == null) {
                        FeatureExtractionModelViewer.this.m_NMFFeaturesPanel = new NMFFeaturesPanel(FeatureExtractionModelViewer.this.m_node);
                    }
                    this.panel = FeatureExtractionModelViewer.this.m_NMFFeaturesPanel;
                } else if (FeatureExtractionModelViewer.this.m_tabIndex[this.tabIndex] == RESULT_TAB) {
                    if (FeatureExtractionModelViewer.this.m_browseResultsListPanel == null) {
                        FeatureExtractionModelViewer.this.m_browseResultsListPanel = new BrowseResultsListPanel(FeatureExtractionModelViewer.this.m_node);
                    }
                    this.panel = FeatureExtractionModelViewer.this.m_browseResultsListPanel;
                } else if (FeatureExtractionModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (FeatureExtractionModelViewer.this.m_buildTaskPanel == null) {
                        FeatureExtractionModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(oraFeatureExtractionModel.getName());
                    }
                    this.panel = FeatureExtractionModelViewer.this.m_buildTaskPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        FeatureExtractionModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

