/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.datamining.association.RuleProperty;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.rule.Rule;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.clustering.LoadClusteringRulesWorker;
import oracle.dmt.dm4j.browser.viewer.clustering.RulesTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;

public final class RulesTable
extends Dm4jSpreadTable
implements ClusteringRulesLoadedListener {
    private int m_rows = 100;
    private int[] m_colSortOrders = null;
    private int m_curSortOrder = 2;
    private Rule m_prevSelectedRule;
    public static final int CLUSTER_ID = 0;
    public static final int CLUSTER_CONFIDENCE = 1;
    public static final int CLUSTER_SUPPORT_COUNT = 2;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ID_HEADER"), DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE"), DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT_COUNT")};
    private String[] m_columnNamesOCluster = new String[]{DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ID_HEADER"), DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE"), DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT_COUNT")};
    private int[] m_colWidths = new int[]{30, 35, 35};
    private RulesTableModel m_tableModel;

    public RulesTableModel getRulesTableModel() {
        return this.m_tableModel;
    }

    public RuleProperty[] getSortCriteria() {
        return this.m_tableModel != null ? this.m_tableModel.getSortCriteria() : null;
    }

    public Boolean[] getSortOrder() {
        return this.m_tableModel != null ? this.m_tableModel.getSortOrder() : null;
    }

    public RulesTable(Object object) {
        super(object);
        ClusteringModel clusteringModel = (ClusteringModel)this.getDataItem();
        AlgorithmSettings algorithmSettings = clusteringModel.getBuildSettings().getAlgorithmSettings();
        if (algorithmSettings != null && algorithmSettings instanceof OraOClusterSettings) {
            this.setColumnNames(this.m_columnNamesOCluster);
        } else {
            this.setColumnNames(this.m_columnNames);
        }
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colSortOrders = new int[this.m_columnNames.length];
        this.m_colSortOrders[0] = -1;
        this.m_colSortOrders[1] = -1;
        this.m_colSortOrders[2] = -1;
    }

    public void load() throws Exception {
        this.load(false, false, 0);
    }

    public void displayLoadingStatus() throws Exception {
        super.displayLoadingStatus();
    }

    public void load(boolean bl, boolean bl2, int n) throws Exception {
        this.setColumnWidths(this.m_colWidths, true);
        ClusteringModel clusteringModel = (ClusteringModel)this.getDataItem();
        if (null == clusteringModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadClusteringRulesWorker loadClusteringRulesWorker = (LoadClusteringRulesWorker)workerThreadManager.getLoadClusteringRulesWorker(clusteringModel, bl, bl2, n);
        loadClusteringRulesWorker.addClusteringRulesLoadedListener(this);
        loadClusteringRulesWorker.start();
    }

    public void rulesLoaded(EventObject eventObject) {
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = (RulesTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_tableModel.getRowCount() != 0) {
            int n;
            dM4JTruncatingNumberFormatPainter = null;
            dM4JTruncatingNumberFormatPainter = this.m_prevSelectedRule != null ? new TwoDSelection((n = this.findRule(this.m_prevSelectedRule)) > 0 ? n : 0, true) : new TwoDSelection(0, true);
            try {
                this.setSelection((TwoDSelection)dM4JTruncatingNumberFormatPainter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 2, 2));
        this.getGrid().setColumnPainter(1, (Painter)dM4JTruncatingNumberFormatPainter);
    }

    public Rule getMiningRule(int n) {
        return this.m_tableModel.getMiningRule(n);
    }

    public int findRule(Rule rule) {
        return this.m_tableModel.findRule(rule);
    }

    public void setPrevSelectedRule(Rule rule) {
        this.m_prevSelectedRule = rule;
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        public SortHandler(SortableTwoDModel sortableTwoDModel) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = RulesTable.this.m_colSortOrders[n];
                if (n2 == -1) {
                    return;
                }
                if (n2 == 0) {
                    n2 = RulesTable.this.m_curSortOrder;
                } else if (n2 == 1) {
                    n2 = 2;
                } else if (n2 == 2) {
                    n2 = 1;
                }
                ((RulesTable)RulesTable.this).m_colSortOrders[n] = n2;
                RulesTable.this.m_curSortOrder = n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

