/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.data.AttributeType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.IntervalClosure;
import javax.datamining.data.ModelSignature;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.statistics.AttributeStatisticsSet;
import javax.datamining.statistics.AttributeStatisticsSetCapability;
import javax.datamining.statistics.UnivariateStatistics;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrComplexAttributeName;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraUnivariateStatistics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.clustering.OraClusteringSignatureAttribute;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;

public class ODMrOraAttributeStatisticsSet
extends OraDMObject
implements AttributeStatisticsSet {
    private static String QRY_CLUSTER_HISTOGRAM_ATTRIBUTE = "SELECT          hg.bin_id                       hist_bin_id,         hg.lower_bound                  hist_lower_bound,         hg.upper_bound                  hist_upper_bound,         hg.label                        hist_label,         hg.count                        hist_frequency FROM (SELECT *  {0}   ,TABLE(a.histogram) hg   ORDER by hist_bin_id";
    private static String ORDER_BY_ID = "ORDER BY id";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM = "    FROM {0} ) ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,   NVL((select label from label_view l where hg.bin_id=l.bin and   l.col=hg.attribute_name), hg.label ) hist_label,  hg.count                        hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.bin_id = l.bin order by hist_attribute_name, hist_bin_id ";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT = " WITH label_view as ( SELECT col, bin, val FROM {0} ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,  NVL( val,                        hg.label) hist_label,  hg.count                        hist_frequency   FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.label = l.bin  ORDER BY hg.label, hist_bin_id ";
    private static final String hist_bin_id = "hist_bin_id";
    private static final String hist_lower_bound = "hist_lower_bound";
    private static final String hist_upper_bound = "hist_upper_bound";
    private static final String hist_label = "hist_label";
    private static final String hist_frequency = "hist_frequency";
    private OraTransformation m_buildTransform;
    private Hashtable m_attrStatisticsMap = new Hashtable();
    private ModelSignature m_modelSignature;
    private int m_clusterId;
    private String m_modelName;
    private ODMrOraClusteringModel m_model;
    private Hashtable m_numAttributeMap;
    private Hashtable m_catAttributeMap;
    private TreeMap m_signMap = new TreeMap();
    private static String QRY_MODEL_SIGNATURE = "SELECT attribute_name, attribute_type  FROM USER_MINING_MODEL_ATTRIBUTES WHERE MODEL_NAME = ? ORDER BY ATTRIBUTE_NAME ASC";
    private static final String attribute_name = "attribute_name";
    private static final String attribute_type = "attribute_type";

    public ODMrOraAttributeStatisticsSet(OraConnection oraConnection, ODMrOraClusteringModel oDMrOraClusteringModel, ModelSignature modelSignature, String string, int n, OraTransformation oraTransformation) {
        super(oraConnection, null);
        this.m_modelSignature = modelSignature;
        this.m_modelName = string;
        this.m_clusterId = n;
        this.m_buildTransform = oraTransformation;
        this.m_model = oDMrOraClusteringModel;
    }

    private boolean isCategoricallyBinned(Connection connection, String string) {
        if (this.m_catAttributeMap != null) {
            return null != this.m_catAttributeMap.get(string);
        }
        this.m_catAttributeMap = this.isBinned(connection, string, false);
        if (this.m_catAttributeMap == null) {
            return false;
        }
        return null != this.m_catAttributeMap.get(string);
    }

    private boolean isNumericallyBinned(Connection connection, String string) {
        if (this.m_numAttributeMap != null) {
            return null != this.m_numAttributeMap.get(string);
        }
        this.m_numAttributeMap = this.isBinned(connection, string, true);
        if (this.m_numAttributeMap == null) {
            return false;
        }
        return null != this.m_numAttributeMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable isBinned(Connection connection, String string, boolean bl) {
        Hashtable<String, String> hashtable = null;
        String string2 = "SELECT distinct COL FROM " + this.getXformTableName(bl);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                hashtable.put(string3, string3);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            if (hashtable != null) {
                hashtable.clear();
                hashtable = null;
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public UnivariateStatistics getStatistics(String string) throws JDMException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UnivariateStatistics getStatistics(ODMrComplexAttributeName oDMrComplexAttributeName) throws JDMException {
        Comparable<Double> comparable;
        String string = oDMrComplexAttributeName.getAttributeName();
        UnivariateStatistics univariateStatistics = (UnivariateStatistics)this.m_attrStatisticsMap.get(oDMrComplexAttributeName.toString());
        if (univariateStatistics != null) {
            return univariateStatistics;
        }
        Vector<HistogramPoint> vector = new Vector<HistogramPoint>();
        OraConnection oraConnection = this.getConnection();
        boolean bl = oraConnection.is102();
        Connection connection = this.getDatabaseConnection();
        SignatureAttribute signatureAttribute = this.m_modelSignature.getAttribute(string);
        AttributeType attributeType = signatureAttribute.getAttributeType();
        boolean bl2 = false;
        String string2 = "";
        if (this.m_buildTransform != null) {
            if (this.m_buildTransform instanceof OraNormalizeTransform) {
                comparable = this.getScale(connection, string);
                string2 = comparable != null && (Double)comparable != 0.0 ? this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true) : this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID, bl);
            } else {
                if (!(this.m_buildTransform instanceof OraBinningTransform)) throw new JDMException();
                if (this.isNumericallyBinned(connection, string)) {
                    string2 = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true);
                    bl2 = true;
                } else if (this.isCategoricallyBinned(connection, string)) {
                    string2 = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, false);
                    bl2 = true;
                } else {
                    string2 = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID, bl);
                }
            }
        } else {
            string2 = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID);
        }
        comparable = this.m_model.getMiningAlgorithm();
        boolean bl3 = true == ((Enum)comparable).equals(MiningAlgorithm.kMeans);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 1;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(n++, this.m_modelName);
            preparedStatement.setInt(n++, this.m_clusterId);
            preparedStatement.setString(n++, string);
            preparedStatement.setInt(n++, 0);
            preparedStatement.setInt(n++, 1);
            preparedStatement.setInt(n++, 0);
            if (!bl && bl3) {
                if (oDMrComplexAttributeName.getAttributeSubName() != null) {
                    preparedStatement.setString(n, oDMrComplexAttributeName.getAttributeSubName());
                } else {
                    preparedStatement.setNull(n, 12);
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = resultSet.getInt(hist_bin_id);
                double d = resultSet.getDouble(hist_lower_bound);
                Double d2 = resultSet.wasNull() ? null : new Double(d);
                double d3 = resultSet.getDouble(hist_upper_bound);
                Double d4 = resultSet.wasNull() ? null : new Double(d3);
                String string3 = resultSet.getString(hist_label);
                double d5 = resultSet.getDouble(hist_frequency);
                HistogramPoint histogramPoint = new HistogramPoint(n2, d2, d4, string3, d5);
                vector.add(histogramPoint);
            }
            if (vector.isEmpty()) {
                UnivariateStatistics univariateStatistics2 = univariateStatistics;
                return univariateStatistics2;
            }
            n2 = vector.size();
            double[] dArray = new double[n2];
            if (attributeType.equals(AttributeType.numerical) && !bl2) {
                OraInterval[] oraIntervalArray = new OraInterval[n2];
                for (int i = 0; i < n2; ++i) {
                    HistogramPoint histogramPoint = (HistogramPoint)vector.elementAt(i);
                    oraIntervalArray[i] = new OraInterval(this.getConnection(), histogramPoint.dLowerBound != null ? histogramPoint.dLowerBound : 0.0, histogramPoint.dUpperBound != null ? histogramPoint.dUpperBound : 0.0, IntervalClosure.closedClosed);
                    dArray[i] = histogramPoint.value;
                }
                univariateStatistics = new ODMrOraUnivariateStatistics(this.getConnection(), string, signatureAttribute, oraIntervalArray, dArray, bl2);
            } else {
                OraCategorySet oraCategorySet = new OraCategorySet(this.getConnection(), signatureAttribute.getDataType());
                for (int i = 0; i < n2; ++i) {
                    HistogramPoint histogramPoint = (HistogramPoint)vector.elementAt(i);
                    oraCategorySet.addCategory(histogramPoint.label, CategoryProperty.valid);
                    dArray[i] = histogramPoint.value;
                }
                univariateStatistics = new ODMrOraUnivariateStatistics(this.getConnection(), string, signatureAttribute, oraCategorySet, dArray, bl2);
            }
            if (univariateStatistics == null) return univariateStatistics;
            this.addAttributeStatistics(string, univariateStatistics);
            return univariateStatistics;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            sQLException.printStackTrace();
            return univariateStatistics;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void addAttributeStatistics(String string, UnivariateStatistics univariateStatistics) {
        this.m_attrStatisticsMap.put(string, univariateStatistics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getHistogramQueryDecode(String string, String string2, boolean bl) {
        OraConnection oraConnection = this.getConnection();
        boolean bl2 = oraConnection.is102();
        String string3 = null;
        MiningAlgorithm miningAlgorithm = this.m_model.getMiningAlgorithm();
        UserPreferences userPreferences = UserPreferences.getInstance();
        boolean bl3 = true;
        int n = 4;
        if (userPreferences.getClusterDetailsPrecisionOption()) {
            bl3 = true;
            n = userPreferences.getClusterDetailsPrecisionDegree();
        } else {
            bl3 = false;
        }
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            if (!this.isEucledian()) return this.m_model.getQuery(string, string2, bl2);
            return MessageFormat.format(DecodeHistogramKmeans.getDecodeHistogramKmeans(bl2), this.getNormTableName());
        }
        if (!bl3) return (bl ? ODMrOraClusteringModel.DECODE_VIEW : "") + MessageFormat.format(bl ? QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM : QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT, this.getXformTableName(bl));
        return (bl ? MessageFormat.format(ODMrOraClusteringModel.DECODE_VIEW_ROUNDED, String.valueOf(n)) : "") + MessageFormat.format(bl ? QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM : QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT, this.getXformTableName(bl));
    }

    private boolean isEucledian() {
        OraKMeansSettings oraKMeansSettings;
        ClusteringDistanceFunction clusteringDistanceFunction = null;
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_model.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        return algorithmSettings instanceof OraKMeansSettings && (clusteringDistanceFunction = (oraKMeansSettings = (OraKMeansSettings)algorithmSettings).getDistanceFunction()).equals(ClusteringDistanceFunction.euclidean);
    }

    private String getNormTableName() {
        if (this.m_buildTransform instanceof OraNormalizeTransform) {
            return ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable();
        }
        return "";
    }

    private String getXformTableName(boolean bl) {
        if (!(this.m_buildTransform instanceof OraBinningTransform)) {
            return "";
        }
        return bl ? ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable() : ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getScale(Connection connection, String string) throws JDMException {
        Statement statement = null;
        ResultSet resultSet = null;
        BigDecimal bigDecimal = null;
        try {
            String string2 = "select SCALE from " + ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable() + " where COL = ?";
            statement = connection.prepareCall(string2);
            statement.setString(1, string.toUpperCase());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                bigDecimal = resultSet.getBigDecimal(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return bigDecimal != null ? new Double(bigDecimal.doubleValue()) : null;
    }

    private SignatureAttribute getAttribute(String string) throws JDMException {
        if (this.m_signMap.isEmpty()) {
            this.getAttributes();
        }
        return (SignatureAttribute)this.m_signMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributes() {
        Connection connection = this.getDatabaseConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement(QRY_MODEL_SIGNATURE);
            preparedStatement.setString(n++, this.m_modelName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(attribute_name);
                String string2 = resultSet.getString(attribute_type);
                OraClusteringSignatureAttribute oraClusteringSignatureAttribute = new OraClusteringSignatureAttribute(this.getConnection(), string, OraPLSQLMappings.getAttributeType(string2), OraPLSQLMappings.getAttributeDataType(string2), this.m_model.getMiningAlgorithm());
                this.m_signMap.put(oraClusteringSignatureAttribute.getName(), oraClusteringSignatureAttribute);
            }
        }
        catch (Exception exception) {
            this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exception, "3517", new Object[]{this.m_modelName});
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Date getStatisticsTimestamp() {
        return null;
    }

    public boolean supportsCapabiltiy(AttributeStatisticsSetCapability attributeStatisticsSetCapability) throws JDMException {
        return true;
    }

    public long getNumberOfCases() {
        return 0L;
    }

    public Collection getStatistics() throws JDMException {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_attrStatisticsMap.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    class HistogramPoint {
        int binId;
        Double dLowerBound;
        Double dUpperBound;
        String label;
        double value;

        HistogramPoint(int n, Double d, Double d2, String string, double d3) {
            this.binId = n;
            this.dLowerBound = d;
            this.dUpperBound = d2;
            this.label = string;
            this.value = d3;
        }
    }

    private static class DecodeHistogramKmeans {
        private static String _QRY_DECODE_CLUSTER_HISTOGRAM_KM = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT  hg.attribute_name                hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col (+)   ORDER by hist_bin_id";
        private static String _QRY_DECODE_CLUSTER_HISTOGRAM_KM_11G = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT  hg.attribute_name                hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col (+)   ORDER by hist_bin_id";

        private DecodeHistogramKmeans() {
        }

        private static String getDecodeHistogramKmeans(boolean bl) {
            return bl ? _QRY_DECODE_CLUSTER_HISTOGRAM_KM : _QRY_DECODE_CLUSTER_HISTOGRAM_KM_11G;
        }
    }
}

