/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.util.EventObject;
import javax.datamining.clustering.ClusteringModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.clustering.RulesTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadClusteringRulesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClusteringModel m_miningModel = null;
    private RulesTableModel m_tableModel = null;
    private boolean m_leafsOnly = false;
    private boolean m_limitTopAttributes = false;
    private int m_topAttributes = 0;

    public LoadClusteringRulesWorker(WorkerThreadManager workerThreadManager, ClusteringModel clusteringModel, boolean bl, boolean bl2, int n) {
        super(workerThreadManager);
        this.m_miningModel = clusteringModel;
        this.m_leafsOnly = bl;
        this.m_limitTopAttributes = bl2;
        this.m_topAttributes = n;
    }

    public void addClusteringRulesLoadedListener(ClusteringRulesLoadedListener clusteringRulesLoadedListener) {
        this.listenerList.add(ClusteringRulesLoadedListener.class, clusteringRulesLoadedListener);
    }

    public void removeClusteringRulesLoadedListener(ClusteringRulesLoadedListener clusteringRulesLoadedListener) {
        this.listenerList.remove(ClusteringRulesLoadedListener.class, clusteringRulesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new RulesTableModel();
            this.m_tableModel.load(this.m_miningModel, this.m_leafsOnly, this.m_limitTopAttributes, this.m_topAttributes);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ClusteringRulesLoadedListener.class) continue;
            ((ClusteringRulesLoadedListener)objectArray[i + 1]).rulesLoaded(new EventObject(this.getValue()));
        }
    }
}

