/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.resource.Connection;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.grid.hGrid.HGridKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.clustering.CentroidAttributesPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.ClustersLoadedListener;
import oracle.dmt.dm4j.browser.viewer.clustering.ClustersTableModel;
import oracle.dmt.dm4j.browser.viewer.clustering.LoadClustersWorker;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrCluster;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.transform.binning.OraBinningTransformFactory;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformFactory;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class ClusteringClustersPanel
extends GriddedPanel
implements ClustersLoadedListener,
VetoableChangeListener {
    private JLabel m_leafCount = new JLabel();
    private JLabel m_levelsCount = new JLabel();
    private JLabel m_caseCount = new JLabel();
    private JCheckBox m_leavesOnly = new JCheckBox();
    private JButton m_attributes = new JButton();
    private JButton m_expand = new JButton();
    private JButton m_collapse = new JButton();
    private JButton m_exportButton = null;
    private JScrollPane m_clustersPanel = new JScrollPane();
    private ClusteringModel m_miningModel = null;
    private ClustersTableModel m_tableModel = null;
    private DefaultDm4jSpreadTable m_clusterTable = null;
    private boolean m_displaySplitRules = false;
    private ClusteringModelViewer m_parent = null;
    private AlgorithmSettings m_algSetting;
    private Integer m_selectedClusterId;
    JButton m_transformButton = new JButton();
    boolean m_isTransformed = false;
    Hashtable m_xformTables = null;

    public ClusteringClustersPanel(ClusteringModelViewer clusteringModelViewer, ClusteringModel clusteringModel) {
        this.m_miningModel = clusteringModel;
        this.m_parent = clusteringModelViewer;
        ClusteringSettings clusteringSettings = (ClusteringSettings)clusteringModel.getBuildSettings();
        this.m_algSetting = clusteringSettings.getAlgorithmSettings();
        this.m_displaySplitRules = this.m_algSetting instanceof OraOClusterSettings;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        if (this.m_algSetting instanceof KMeansSettings) {
            return "CLUSTERING_KMEANS_MODEL";
        }
        return "CLUSTERING_OCLUSTER_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("CLUST_LEAF_COUNT"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_leafCount, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("CLUST_LEVELS_COUNT"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_levelsCount, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("CLUST_CASE_COUNT"));
        this.addComponent(jLabel3, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_caseCount, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTERS"));
        jLabel4.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTERS"));
        this.m_leavesOnly.setText(DM4JResourceUtilities.getUIString("CLUST_LEAVES_ONLY"));
        this.m_leavesOnly.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_LEAVES_ONLY"));
        this.m_leavesOnly.setSelected(false);
        this.m_leavesOnly.setEnabled(false);
        if (this.m_algSetting instanceof KMeansSettings) {
            this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
        } else {
            this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
            this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
        }
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.setEnabled(false);
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        int n = ClusteringClustersPanel.this.m_tableModel.getExpandedRowCount();
                        for (int i = 0; i < n; ++i) {
                            ClusteringClustersPanel.this.m_tableModel.expandExpandedRow(i);
                        }
                        exportDialog.export(ClusteringClustersPanel.this.m_clusterTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)new JLabel(), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        jPanel2.add((Component)this.m_leavesOnly, gridBagConstraints);
        jPanel3.add(this.m_transformButton);
        jPanel3.add(this.m_exportButton);
        jPanel.add("West", jPanel2);
        jPanel.add("East", jPanel3);
        this.addFilledComponent(jPanel, MIDLABELITEMINSETS, n++, 0, 4, 1, 1);
        this.m_clusterTable = this.createTable();
        this.m_clustersPanel.getViewport().add((Component)((Object)this.m_clusterTable));
        this.addFilledComponent(this.m_clustersPanel, MIDLABELITEMINSETS, n, 0, 4, 5, 1);
        jLabel4.setLabelFor((Component)((Object)this.m_clusterTable));
        this.m_attributes.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_DETAILS"));
        this.m_attributes.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_DETAILS"));
        this.m_attributes.setEnabled(false);
        this.addComponent(this.m_attributes, TOPLABELITEMINSETS, n++, 4, 1, 1, 14, 2);
        this.m_expand.setText(DM4JResourceUtilities.getUIString("COMMON_EXPAND_ALL"));
        this.m_expand.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_EXPAND_ALL"));
        this.m_expand.setEnabled(false);
        this.addComponent(this.m_expand, TOPLABELITEMINSETS, n++, 4, 1, 1, 14, 2);
        this.m_collapse.setText(DM4JResourceUtilities.getUIString("COMMON_COLLAPSE_ALL"));
        this.m_collapse.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_COLLAPSE_ALL"));
        this.m_collapse.setEnabled(false);
        this.addComponent(this.m_collapse, TOPLABELITEMINSETS, n++, 4, 1, 1, 14, 2);
        if (this.m_algSetting instanceof KMeansSettings) {
            this.m_transformButton.setVisible(false);
            this.m_transformButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMiningModelBuildTransformation(boolean bl) {
        try {
            ((OraModel)((Object)this.m_miningModel)).setBuildTransformation(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && this.m_xformTables != null) {
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getConnection();
                if (this.m_algSetting instanceof KMeansSettings) {
                    String string = (String)this.m_xformTables.get("XNORM");
                    OraNormalizeTransformFactory oraNormalizeTransformFactory = (OraNormalizeTransformFactory)connection.getFactory("oracle.dmt.jdm.transform.normalize.OraNormalizeTransform");
                    OraNormalizeTransformImpl oraNormalizeTransformImpl = (OraNormalizeTransformImpl)oraNormalizeTransformFactory.create(null, null, false, string);
                    ((OraModel)((Object)this.m_miningModel)).setBuildTransformation(oraNormalizeTransformImpl);
                } else {
                    String string = (String)this.m_xformTables.get("XBINC");
                    String string2 = (String)this.m_xformTables.get("XBINN");
                    OraBinningTransformFactory oraBinningTransformFactory = (OraBinningTransformFactory)connection.getFactory("oracle.dmt.jdm.transform.binning.OraBinningTransform");
                    OraBinningTransformImpl oraBinningTransformImpl = (OraBinningTransformImpl)oraBinningTransformFactory.create(null, null, false, string, string2);
                    ((OraModel)((Object)this.m_miningModel)).setBuildTransformation(oraBinningTransformImpl);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void m_transformButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_transformButton.getText();
        try {
            if (this.m_algSetting instanceof KMeansSettings) {
                if (string.equals(DM4JResourceUtilities.getUIString("COMMON_SCALE"))) {
                    this.m_isTransformed = true;
                    this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                    this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
                } else {
                    this.m_isTransformed = false;
                    this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                    this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
                }
            } else if (string.equals(DM4JResourceUtilities.getUIString("COMMON_UNBIN"))) {
                this.m_isTransformed = true;
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
            } else {
                this.m_isTransformed = false;
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
            }
            this.updateMiningModelBuildTransformation(this.m_isTransformed);
            this.loadClusters();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimePanelLoad() throws Exception {
        Object object;
        this.m_xformTables = null;
        java.sql.Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            object = DMEMetadata.getInstance();
            this.m_xformTables = ((DMEMetadata)object).getTransparencyTables(connection, null, this.m_miningModel.getName());
        }
        catch (Exception exception) {
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_xformTables != null) {
            this.m_isTransformed = true;
            this.m_transformButton.setEnabled(true);
            if (this.m_algSetting instanceof KMeansSettings) {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
            }
        } else {
            this.m_isTransformed = false;
            this.m_transformButton.setEnabled(false);
            if (this.m_algSetting instanceof KMeansSettings) {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            } else {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
            }
        }
        this.updateMiningModelBuildTransformation(this.m_isTransformed);
        this.m_leavesOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringClustersPanel.this.chkLeavesOnly_actionPerformed(actionEvent);
            }
        });
        this.m_transformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringClustersPanel.this.m_transformButton_actionPerformed(actionEvent);
            }
        });
        this.m_attributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringClustersPanel.this.btnDetails_actionPerformed(actionEvent);
            }
        });
        this.m_expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = ClusteringClustersPanel.this.m_tableModel.getExpandedRowCount();
                for (n = 0; n < n2; ++n) {
                    ClusteringClustersPanel.this.m_tableModel.expandExpandedRow(n);
                }
                n = 0;
                ArrayList arrayList = ClusteringClustersPanel.this.m_tableModel.getClusters();
                if (ClusteringClustersPanel.this.m_selectedClusterId != null) {
                    int n3 = ClusteringClustersPanel.this.m_tableModel.getRowCount();
                    for (int i = 0; i < n3; ++i) {
                        Integer n4 = (Integer)((HDataObject)ClusteringClustersPanel.this.m_tableModel.getExpandedData(0, i)).getData();
                        if (n4.intValue() != ClusteringClustersPanel.this.m_selectedClusterId.intValue()) continue;
                        n = i;
                        TwoDSelection twoDSelection = new TwoDSelection(n, true);
                        try {
                            ClusteringClustersPanel.this.m_clusterTable.setSelection(twoDSelection);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        this.m_collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClusteringClustersPanel.this.m_tableModel.getExpandedRowCount();
                for (int i = 0; i < n; ++i) {
                    ClusteringClustersPanel.this.m_tableModel.collapseExpandedRow(i);
                }
            }
        });
        this.loadClusters();
        this.m_leafCount.setText("");
        this.m_levelsCount.setText(DM4JNumericFormat.format(this.m_miningModel.getNumberOfLevels()));
        object = new int[]{100};
        this.m_clusterTable.setColumnWidths((int[])object, true);
    }

    private void loadClusters() {
        int n = 3;
        if (!this.m_displaySplitRules || this.m_leavesOnly.isSelected()) {
            n = 2;
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadClustersWorker loadClustersWorker = (LoadClustersWorker)workerThreadManager.getLoadClustersWorker(this.m_parent, this.m_leafCount, n, this.m_leavesOnly.isSelected());
        loadClustersWorker.addClustersLoadedListener(this);
        loadClustersWorker.start();
    }

    public void clustersLoaded(EventObject eventObject) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        boolean bl = this.m_displaySplitRules && !this.m_leavesOnly.isSelected();
        this.m_tableModel = (ClustersTableModel)((Object)eventObject.getSource());
        this.m_caseCount.setText(DM4JNumericFormat.format(this.m_tableModel.getCaseCount()));
        int n = 3;
        if (!bl) {
            n = 2;
        }
        Object[] objectArray = new String[n];
        objectArray[0] = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ID_HEADER");
        objectArray[1] = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_CASES");
        if (bl) {
            objectArray[2] = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_SPLIT_RULE");
        }
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        this.m_clusterTable.setModels((TwoDModel)this.m_tableModel, arrayOneDModel, null);
        Grid grid = this.m_clusterTable.getGrid();
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
        grid.setColumnPainter(1, (Painter)dM4JTruncatingNumberFormatPainter);
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(0, (Painter)hCellHandler);
        grid.setColumnCellInputHandler(0, (CellInputHandler)hCellHandler);
        int n2 = 0;
        ArrayList arrayList = this.m_tableModel.getClusters();
        if (this.m_selectedClusterId != null) {
            int n3 = this.m_tableModel.getRowCount();
            for (int i = 0; i < n3; ++i) {
                Integer n4 = (Integer)((HDataObject)this.m_tableModel.getExpandedData(0, i)).getData();
                if (n4.intValue() != this.m_selectedClusterId.intValue()) continue;
                n2 = i;
                break;
            }
        }
        if (this.m_tableModel.getRowCount() != 0) {
            TwoDSelection twoDSelection = new TwoDSelection(n2, true);
            try {
                this.m_clusterTable.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray = null;
        nArray = bl ? new int[]{30, 15, 55} : new int[]{70, 30};
        try {
            this.m_clusterTable.setColumnWidths(nArray, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_leavesOnly.setEnabled(true);
        this.m_expand.setEnabled(true);
        this.m_collapse.setEnabled(true);
        this.m_attributes.setEnabled(true);
        this.m_exportButton.setEnabled(true);
        for (int i = 0; i < this.m_parent.getTabCount(); ++i) {
            if (this.m_parent.isEnabledAt(i)) continue;
            this.m_parent.setEnabledAt(i, true);
        }
    }

    private DefaultDm4jSpreadTable createTable() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        Object[] objectArray = new String[]{DM4JResourceUtilities.getUIString("COMMON_CLUSTERS")};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(1, 1);
        arrayTwoDModel.setData(0, 0, (Object)DM4JResourceUtilities.getUIString("COMMON_LOADING"));
        DefaultDm4jSpreadTable defaultDm4jSpreadTable = new DefaultDm4jSpreadTable(null);
        defaultDm4jSpreadTable.setModels((TwoDModel)arrayTwoDModel, arrayOneDModel, null);
        Grid grid = defaultDm4jSpreadTable.getGrid();
        grid.setGridKeyHandler((GridKeyHandler)new HGridKeyHandler(grid));
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        generalGridSelectionManager.addVetoableChangeListener((VetoableChangeListener)this);
        grid.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ClusteringClustersPanel.this.btnDetails_actionPerformed(null);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(0, (Painter)hCellHandler);
        grid.setColumnCellInputHandler(0, (CellInputHandler)hCellHandler);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(defaultDm4jSpreadTable);
        return defaultDm4jSpreadTable;
    }

    private void chkLeavesOnly_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        this.m_leavesOnly.setEnabled(false);
        this.m_expand.setEnabled(false);
        this.m_collapse.setEnabled(false);
        this.m_attributes.setEnabled(false);
        this.m_exportButton.setEnabled(false);
        try {
            this.loadClusters();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void btnDetails_actionPerformed(ActionEvent actionEvent) {
        TwoDSelection twoDSelection = this.m_clusterTable.getSelection();
        int n = twoDSelection.getSingleRow();
        if (n == -1) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("CLUST_DETAIL_WARN_SELECTION"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        ArrayList arrayList = this.m_tableModel.getClusters();
        ODMrCluster oDMrCluster = (ODMrCluster)arrayList.get(n);
        String string = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_DETAILS_TITLE") + " - ";
        string = string + DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ID") + " " + oDMrCluster.getJDmCluster().getClusterId();
        final JFrame jFrame = new JFrame(string);
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerLocation(250);
        this.setCursor(new Cursor(3));
        CentroidAttributesPanel centroidAttributesPanel = new CentroidAttributesPanel(this.m_miningModel, oDMrCluster.getJDmCluster(), jSplitPane, jFrame);
        jSplitPane.add((Component)centroidAttributesPanel, "top");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jSplitPane, "Center");
        jFrame.setSize(550, 600);
        WindowUtils.centerWindow((Window)jFrame);
        jFrame.setVisible(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, true);
        jFrame.getRootPane().getInputMap(1).put(keyStroke, "HelpAction");
        jFrame.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserFrame.getCSHManager().showTopic("CLUSTERING_HISTOGRAM");
                }
                catch (Exception exception) {
                    BrowserFrame.showHelpError(jFrame);
                }
            }
        });
        this.setCursor(new Cursor(0));
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n = twoDSelection.getSingleRow();
        if (n == -1) {
            return;
        }
        int n2 = this.m_tableModel.getExpandedIndex(n);
        this.m_selectedClusterId = (Integer)((HDataObject)this.m_tableModel.getExpandedData(0, n2)).getData();
    }
}

