/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.statistics.UnivariateStatistics;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrCluster;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrComplexAttributeName;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraAttributeStatisticsSet;

public class CentroidAttributesTableModel
extends AbstractTableModel {
    private Object[][] m_data;
    public String[] columns = new String[2];
    private Cluster m_cluster = null;
    private ODMrOraAttributeStatisticsSet m_statsSet;
    private TreeMap m_centroids;

    public CentroidAttributesTableModel(ClusteringModel clusteringModel, Cluster cluster) {
        this.m_cluster = cluster;
        this.columns[0] = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ATTRIBUTE");
        this.columns[1] = DM4JResourceUtilities.getUIString("CLUST_CLUSTER_CENTROID_VALUE");
        try {
            ODMrCluster oDMrCluster = new ODMrCluster(clusteringModel, cluster);
            this.m_statsSet = (ODMrOraAttributeStatisticsSet)oDMrCluster.getStatistics();
            UserPreferences userPreferences = UserPreferences.getInstance();
            boolean bl = true;
            int n = 4;
            if (userPreferences.getClusterDetailsPrecisionOption()) {
                bl = true;
                n = userPreferences.getClusterDetailsPrecisionDegree();
            } else {
                bl = false;
            }
            this.m_centroids = oDMrCluster.getCentroids();
            if (this.m_centroids != null && !this.m_centroids.isEmpty()) {
                this.m_data = new Object[this.m_centroids.size()][2];
                Set set = this.m_centroids.keySet();
                Iterator iterator = set.iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    ODMrComplexAttributeName oDMrComplexAttributeName = (ODMrComplexAttributeName)iterator.next();
                    this.m_data[n2][0] = oDMrComplexAttributeName;
                    Object v = this.m_centroids.get(oDMrComplexAttributeName);
                    if (bl) {
                        this.m_data[n2++][1] = this.convertNumber(v != null ? v.toString() : "", n);
                        continue;
                    }
                    this.m_data[n2++][1] = v != null ? v.toString() : "";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String convertNumber(String string, int n) {
        String string2 = string;
        try {
            double d = Double.parseDouble(string);
            string2 = DM4JNumericFormat.format(d, false, n);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
        return string2;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.m_data[n][n2];
        if (n2 == 1 && object == null) {
            object = " ";
        }
        return object;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int n) {
        return this.columns[n];
    }

    public int getRowCount() {
        return this.m_data.length;
    }

    public UnivariateStatistics getUniVarStatsEntry(int n) {
        ODMrComplexAttributeName oDMrComplexAttributeName = (ODMrComplexAttributeName)this.m_data[n][0];
        UnivariateStatistics univariateStatistics = null;
        try {
            univariateStatistics = this.m_statsSet.getStatistics(oDMrComplexAttributeName);
        }
        catch (Exception exception) {
            univariateStatistics = null;
        }
        return univariateStatistics;
    }

    public String getAttributeName(int n) {
        ODMrComplexAttributeName oDMrComplexAttributeName = (ODMrComplexAttributeName)this.m_data[n][0];
        return oDMrComplexAttributeName.toString();
    }

    public UnivariateStatistics getUniVarStatsEntry(ODMrComplexAttributeName oDMrComplexAttributeName) {
        UnivariateStatistics univariateStatistics = null;
        try {
            univariateStatistics = this.m_statsSet.getStatistics(oDMrComplexAttributeName);
        }
        catch (Exception exception) {
            univariateStatistics = null;
        }
        return univariateStatistics;
    }
}

