/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.data.CategorySet;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeDetailPane;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dss.graph.Graph;
import oracle.dss.util.DataSource;

public class TreeNodeTargetValuesPanel
extends GriddedPanel {
    private ClassificationModel m_miningModel = null;
    private TreeNode m_selectedNode = null;
    private TreeNodeDetailPane m_parent = null;

    public TreeNodeTargetValuesPanel(TreeNodeDetailPane treeNodeDetailPane, ClassificationModel classificationModel, TreeNode treeNode) {
        this.m_miningModel = classificationModel;
        this.m_selectedNode = treeNode;
        this.m_parent = treeNodeDetailPane;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        final TreeNodeTargetValuesPanel treeNodeTargetValuesPanel = this;
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton, new Insets(7, 0, 0, 10), n++, 2, 2, 1, 14);
        final Graph graph = this.m_parent.getGraph();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFrame jFrame = (JFrame)DM4JCommonUIUtils.getParentWindow(treeNodeTargetValuesPanel);
                    ExportChartDialog exportChartDialog = new ExportChartDialog(jFrame, DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(graph);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.addComponent((JComponent)graph, MIDLABELITEMINSETS, n, 2, 2, 2, 18, 1);
    }

    private void runTimePanelLoad() throws Exception {
        Object[][] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        Graph graph = this.m_parent.getGraph();
        CategorySet categorySet = this.m_miningModel.getTargetCategorySet();
        Object[] objectArray4 = categorySet.getValues();
        long[] lArray = this.m_selectedNode.getTargetCounts();
        int n = objectArray4.length;
        objectArray = new Object[n][1];
        objectArray2 = new Object[n];
        objectArray3 = new Object[]{DM4JResourceUtilities.getUIString("TREE_NODE_VALUES_FREQUENCY")};
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray4[i].toString();
            objectArray[i][0] = new Long(lArray[i]);
        }
        graph.getTitle().setVisible(false);
        graph.getO1Title().setText(DM4JResourceUtilities.getUIString("TREE_NODE_VALUES"));
        graph.getY1Title().setText(DM4JResourceUtilities.getUIString("TREE_NODE_VALUES_COUNT"));
        graph.getPFJ().setDisplay(graph.getPFJ().getLegendArea(), false);
        graph.setScrollbarPresenceGroups(1);
        graph.setDataRowShownAsASeries(true);
        graph.setDataSource((DataSource)new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
    }
}

