/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.rule.Predicate;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.share.sort.NumberComparator;
import oracle.dmt.dm4j.browser.BrowserUtils;

public class TreeNodeTableModel
extends HArrayTwoDModel {
    private ArrayList m_visibleNodes = new ArrayList();
    private TreeNode m_root = null;
    private ClassificationModel m_miningModel = null;
    private TreeModelDetail m_modelDetail = null;
    private ResourceBundle m_res = BrowserUtils.getBundleInstance();
    private int m_levels = 0;
    private SortableTwoDModel m_leafOnlyTableModel = null;
    public static final int NODE_ID_COLUMN = 0;
    private static int COLUMN_COUNT = 6;
    static final int ROOT = 0;
    static final int SIBLING = 1;
    static final int CHILD = 2;

    public TreeNodeTableModel(int n) {
        super(COLUMN_COUNT, n);
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public void load(TreeNode treeNode, ClassificationModel classificationModel, boolean bl) throws Exception {
        this.m_root = treeNode;
        this.m_miningModel = classificationModel;
        this.m_modelDetail = (TreeModelDetail)classificationModel.getModelDetail();
        this.m_visibleNodes = new ArrayList();
        if (bl) {
            this.populateLeavesOnly();
        } else {
            this.populateAll();
        }
    }

    private void populateAll() throws Exception {
        TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
        TreeNode treeNode = treeModelDetail.getRootNode();
        if (null != treeNode) {
            this.addRow(treeNode, 0, 0);
        }
    }

    private void populateLeavesOnly() throws Exception {
        int n = 0;
        TreeNode treeNode = null;
        TreeNode treeNode2 = null;
        treeNode2 = this.getRootNode();
        Vector vector = this.getLeaves();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            treeNode = (TreeNode)enumeration.nextElement();
            this.addRow(treeNode, n++, 0);
        }
        this.populateSortableLeafOnlyTableModel();
    }

    private Vector getLeaves() throws Exception {
        TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
        TreeNode[] treeNodeArray = treeModelDetail.getNodes();
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            TreeNode treeNode = treeNodeArray[i];
            if (!treeNode.isLeaf()) continue;
            vector.add(treeNode);
        }
        return vector;
    }

    public SortableTwoDModel getSortableLeafTable() {
        return this.m_leafOnlyTableModel;
    }

    private void populateSortableLeafOnlyTableModel() {
        this.m_leafOnlyTableModel = new SortableTwoDModel(this.getColumnCount(), this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (j == 0) {
                    HDataObject hDataObject = (HDataObject)this.getExpandedData(j, i);
                    Integer n = (Integer)hDataObject.getData();
                    this.m_leafOnlyTableModel.setData(j, i, (Object)n);
                    continue;
                }
                this.m_leafOnlyTableModel.setData(j, i, this.getData(j, i));
            }
        }
        this.m_leafOnlyTableModel.setColumnComparator(0, NumberComparator.getComparator());
        this.m_leafOnlyTableModel.setColumnComparator(3, NumberComparator.getComparator());
        this.m_leafOnlyTableModel.setColumnComparator(4, NumberComparator.getComparator());
        this.m_leafOnlyTableModel.setColumnComparator(5, NumberComparator.getComparator());
    }

    private TreeNode getRootNode() throws Exception {
        TreeNode treeNode = this.m_modelDetail.getRootNode();
        return treeNode;
    }

    private void addRow(TreeNode treeNode, int n, int n2) throws Exception {
        if (2 == n2) {
            this.addChildrenRows(n++, 1);
        } else if (0 == n2) {
            this.addRootRows(n, 1);
        } else if (1 == n2) {
            n = this.addSiblingRows(n, 1);
        }
        if (this.m_levels < treeNode.getLevel()) {
            this.m_levels = treeNode.getLevel();
        }
        this.setRowData(treeNode, n);
        TreeNode[] treeNodeArray = treeNode.getChildren();
        if (null != treeNodeArray) {
            int n3 = n;
            for (int i = 0; i < treeNodeArray.length; ++i) {
                TreeNode treeNode2 = treeNodeArray[i];
                if (0 == i) {
                    this.addRow(treeNode2, n3++, 2);
                    continue;
                }
                this.addRow(treeNode2, n3++, 1);
            }
        }
    }

    private void setRowData(TreeNode treeNode, int n) {
        int n2 = 0;
        this.setExpandedData(n2++, n, new Integer(treeNode.getIdentifier()));
        Predicate predicate = treeNode.getPredicate();
        String string = null;
        if (null != predicate) {
            try {
                string = predicate.toString();
            }
            catch (Exception exception) {
                string = this.m_res.getString("COMMON_UNKNOWN");
            }
            this.setExpandedData(n2++, n, string);
        }
        float f = 0.0f;
        long l = treeNode.getCaseCount();
        long l2 = this.m_root.getCaseCount();
        float f2 = (float)l / (float)l2;
        try {
            Object object = treeNode.getPrediction();
            long l3 = treeNode.getTargetCount(object);
            f = (float)l3 / (float)l;
        }
        catch (JDMException jDMException) {
            jDMException.printStackTrace();
        }
        this.setExpandedData(n2++, n, treeNode.getPrediction().toString());
        this.setExpandedData(n2++, n, new Float(f));
        this.setExpandedData(n2++, n, new Double(treeNode.getCaseCount()));
        this.setExpandedData(n2++, n, new Float(f2));
        this.expandExpandedRow(n);
        this.m_visibleNodes.add(n, treeNode);
    }

    public int getLevels() {
        return this.m_levels;
    }

    public ArrayList getNodes() {
        return this.m_visibleNodes;
    }
}

