/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.rule.Predicate;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeDetailPane;

public class TreeNodePredicatePanel
extends GriddedPanel {
    private JLabel m_pvalue = new JLabel();
    private JLabel m_cases = new JLabel();
    private JLabel m_level = new JLabel();
    private JLabel m_support = new JLabel();
    private JLabel m_confidence = new JLabel();
    private JCheckBox m_reverseFullRule = new JCheckBox();
    private JRadioButton m_radioSimpleRule = new JRadioButton();
    private JRadioButton m_radioSurrogate = new JRadioButton();
    private JRadioButton m_radioFullRule = new JRadioButton();
    private JTextArea m_predicate = new JTextArea();
    private ClassificationModel m_model = null;
    private TreeNode m_selectedNode = null;
    private TreeNodeDetailPane m_parent = null;
    private TreeModelDetail m_modelDetail = null;

    public TreeNodePredicatePanel(TreeNodeDetailPane treeNodeDetailPane, ClassificationModel classificationModel, TreeNode treeNode) {
        this.m_model = classificationModel;
        this.m_selectedNode = treeNode;
        this.m_parent = treeNodeDetailPane;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 1;
        this.m_reverseFullRule.setText(DM4JResourceUtilities.getUIString("TREE_NODE_FULL_RULE"));
        this.m_radioFullRule.setText(DM4JResourceUtilities.getUIString("TREE_NODE_FULL_RULE"));
        this.m_radioSimpleRule.setText(DM4JResourceUtilities.getUIString("TREE_NODE_RULE"));
        this.m_radioSurrogate.setText(DM4JResourceUtilities.getUIString("TREE_NODE_SURROGATE"));
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_PREDICTED_VALUE"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_pvalue, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_SUPPORT"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_support, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_CONFIDENCE"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_confidence, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_CASES"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_cases, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_LEVEL"));
        this.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        this.addComponent(this.m_level, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_NODE_SPLIT_RULES"));
        this.m_predicate.setEditable(false);
        this.m_predicate.setLineWrap(true);
        this.m_predicate.setWrapStyleWord(true);
        DM4JAccessibilityUtils.setAccessibleName(this.m_predicate, DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_DETAIL"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getViewport().add((Component)this.m_predicate, null);
        this.m_radioSimpleRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeNodePredicatePanel.this.enableReverseRuleCheckbox(false);
                TreeNodePredicatePanel.this.m_parent.setShowSimplifiedRule();
                TreeNodePredicatePanel.this.m_predicate.setText(TreeNodePredicatePanel.this.getRule(TreeNodePredicatePanel.this.m_selectedNode, false));
            }
        });
        this.m_radioSurrogate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeNodePredicatePanel.this.enableReverseRuleCheckbox(false);
                TreeNodePredicatePanel.this.m_parent.setShowSurrogates();
                TreeNodePredicatePanel.this.loadSurrogate();
            }
        });
        this.m_radioFullRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeNodePredicatePanel.this.enableReverseRuleCheckbox(true, false);
                TreeNodePredicatePanel.this.m_parent.setShowFullRule(false);
                TreeNodePredicatePanel.this.m_predicate.setText(TreeNodePredicatePanel.this.getFullRule(TreeNodePredicatePanel.this.m_selectedNode, false));
            }
        });
        this.m_reverseFullRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeNodePredicatePanel.this.m_parent.setShowFullRule(false);
                TreeNodePredicatePanel.this.m_predicate.setText(TreeNodePredicatePanel.this.getFullRule(TreeNodePredicatePanel.this.m_selectedNode, false));
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_radioSimpleRule);
        buttonGroup.add(this.m_radioFullRule);
        buttonGroup.add(this.m_radioSurrogate);
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        this.addComponent(this.m_radioSimpleRule, TOPLABELITEMINSETS, n, 2);
        this.addComponent(this.m_radioFullRule, TOPLABELITEMINSETS, n, 3);
        this.addComponent(this.m_radioSurrogate, TOPLABELITEMINSETS, n++, 4);
        this.addFilledComponent(jScrollPane, MIDVALUEITEMINSETS, n++, 1, 6, 2, 1);
    }

    private void enableReverseRuleCheckbox(boolean bl) {
        this.enableReverseRuleCheckbox(bl, bl);
    }

    private void enableReverseRuleCheckbox(boolean bl, boolean bl2) {
        this.m_reverseFullRule.setEnabled(bl);
        this.m_reverseFullRule.setSelected(bl2);
    }

    private void runTimePanelLoad() throws Exception {
        this.m_modelDetail = (TreeModelDetail)this.m_model.getModelDetail();
        this.m_pvalue.setText(this.m_selectedNode.getPrediction().toString());
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 0);
        this.m_cases.setText(numberFormat.format(this.m_selectedNode.getCaseCount()));
        this.m_level.setText(numberFormat.format(this.m_selectedNode.getLevel()));
        float f = 0.0f;
        float f2 = 0.0f;
        long l = this.m_selectedNode.getCaseCount();
        long l2 = this.m_modelDetail.getRootNode().getCaseCount();
        Object object = this.m_selectedNode.getPrediction();
        long l3 = this.m_selectedNode.getTargetCount(object);
        f2 = (float)l / (float)l2;
        f = (float)l3 / (float)l;
        this.m_support.setText(this.toPercent(f2));
        this.m_confidence.setText(this.toPercent(f));
        if (this.m_parent.isShowSimplifiedRule()) {
            this.m_radioSimpleRule.setSelected(true);
            this.enableReverseRuleCheckbox(false);
            this.m_predicate.setText(this.getRule(this.m_selectedNode, false));
        } else if (this.m_parent.isShowSurrogates()) {
            this.m_radioSurrogate.setSelected(true);
            this.enableReverseRuleCheckbox(false);
            this.loadSurrogate();
        } else if (this.m_parent.isShowFullRule()) {
            this.m_radioFullRule.setSelected(true);
            this.enableReverseRuleCheckbox(true, false);
            this.m_predicate.setText(this.getFullRule(this.m_selectedNode, false));
        }
    }

    private String toPercent(float f) {
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 2, 2);
        double d = (double)f * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(2, 4);
        d = bigDecimal.doubleValue();
        String string = numberFormat.format(d);
        return string;
    }

    private void loadSurrogate() {
        Predicate[] predicateArray = this.m_selectedNode.getSurrogates();
        String string = "";
        if (predicateArray != null) {
            for (int i = 0; i < predicateArray.length; ++i) {
                String string2 = Integer.toString(i) + ": " + predicateArray[i].toString();
                string = string + string2 + "\n";
            }
        }
        this.m_predicate.setText(string);
    }

    private String getRule(TreeNode treeNode, boolean bl) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string = "";
        try {
            String string2;
            TreeNode treeNode2 = this.m_modelDetail.getRootNode();
            while (treeNode.getIdentifier() != treeNode2.getIdentifier()) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            if (!bl) {
                ArrayList arrayList2 = new ArrayList();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    arrayList2.add(arrayList.get(i));
                }
                arrayList = null;
                arrayList = arrayList2;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                TreeNode treeNode3 = (TreeNode)arrayList.get(i);
                string2 = treeNode3.getPredicate().toString();
                int n = string2.indexOf(" ");
                String string3 = string2.substring(0, n);
                linkedHashMap.put(string3, string2);
            }
            Iterator iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = (String)entry.getValue();
                string = string + string2;
                if (!iterator.hasNext()) continue;
                string = string + DM4JResourceUtilities.getUIString("TREE_NODE_RULE_AND");
            }
        }
        catch (Exception exception) {
            string = DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR");
            exception.printStackTrace();
        }
        return string;
    }

    private String getFullRule(TreeNode treeNode, boolean bl) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        String string = "";
        try {
            TreeNode treeNode2 = this.m_modelDetail.getRootNode();
            while (treeNode.getIdentifier() != treeNode2.getIdentifier()) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            if (!bl) {
                ArrayList arrayList2 = new ArrayList();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    arrayList2.add(arrayList.get(i));
                }
                arrayList = null;
                arrayList = arrayList2;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                TreeNode treeNode3 = (TreeNode)arrayList.get(i);
                string = string + treeNode3.getPredicate().toString();
                if (i == arrayList.size() - 1) continue;
                string = string + DM4JResourceUtilities.getUIString("TREE_NODE_RULE_AND");
            }
        }
        catch (Exception exception) {
            string = DM4JResourceUtilities.getUIString("TREE_NODE_RULE_ERROR");
            exception.printStackTrace();
        }
        return string;
    }
}

