/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.jdm.data.OraAttributeCoefficient;

public class SVMCoefficientTableModel
extends Dm4jSortableTwoDModel {
    private OraAttributeCoefficient[] m_attributeCoefficients = null;
    private HashMap m_targetMap = new HashMap();
    private ClassificationModel m_model;
    private static String QRY_CLASSIFICATION_ALL_COEFFICIENTS = " SELECT r.attribute_name, r.attribute_value, r.coefficient FROM  (SELECT c.class_id, m.attr as attribute_name, m.sval as attribute_value, c.coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m   WHERE c.class_id = <target_value> AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static final String QRY_CLASSIFICATION_ALL_COEFFICIENTS_11G = "SELECT NVL2( r.attribute_subname, r.attribute_name || '.' || r.attribute_subname, r.attribute_name) attribute_name, \n       r.attribute_subname, r.attribute_value, r.coefficient FROM \n (SELECT c.class_id, m.attr as attribute_name, m.attr_subname as attribute_subname, m.sval as attribute_value, c.coefficient \n  FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m \n  WHERE c.class_id = <target_value> AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static String QRY_DENORMALIZED_CLASSIFICATION_ALL_COEFFICIENTS = " SELECT r.attribute_name, r.attribute_value, r.coefficient FROM  (SELECT c.class_id, m.attr as attribute_name, m.sval as attribute_value, c.coefficient/nvl(n.scale, 1) as coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, <norm_table> n   WHERE m.attr = n.col (+) AND c.class_id = <target_value> AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static String QRY_DENORMALIZED_CLASSIFICATION_ALL_COEFFICIENTS_11G = "SELECT NVL2( r.attribute_subname, r.attribute_name || '.' || r.attribute_subname, r.attribute_name) attribute_name, \n       r.attribute_subname, r.attribute_value, r.coefficient FROM \n (SELECT c.class_id, m.attr as attribute_name, m.attr_subname as attribute_subname, m.sval as attribute_value, c.coefficient/nvl(n.scale, 1) as coefficient \n  FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, <norm_table> n \n  WHERE m.attr = n.col (+) AND c.class_id = <target_value> AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private int m_fetchSize = 1000;
    private Hashtable m_lookupTableMap = null;

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_attributeCoefficients != null ? this.m_attributeCoefficients[n] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(String string) {
        this.addRows(0, 1);
        this.addColumns(0, 2);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            statement.setFetchSize(this.m_fetchSize);
            resultSet = statement.executeQuery(string);
            int n = 0;
            int n2 = this.m_fetchSize;
            this.addRows(n, n2);
            this.addColumns(0, 1);
            String string2 = null;
            boolean bl = true;
            while (resultSet.next()) {
                bl = false;
                String string3 = resultSet.getString("attribute_name");
                String string4 = resultSet.getString("attribute_value");
                Double d = resultSet.getDouble("coefficient");
                if (BrowserFrame.is11Server()) {
                    string2 = resultSet.getString("attribute_subname");
                }
                if (this.m_lookupTableMap == null) {
                    this.setData(0, n, string3);
                } else {
                    String string5 = string3;
                    String string6 = string3;
                    if (BrowserFrame.is11Server() && string2 != null) {
                        int n3;
                        String string7 = (String)this.m_lookupTableMap.get(string2);
                        if (string7 != null && (n3 = string3.lastIndexOf(string2)) != -1) {
                            string6 = string3.substring(0, n3) + string7;
                        }
                    } else {
                        string6 = (String)this.m_lookupTableMap.get(string5);
                    }
                    if (string6 != null) {
                        this.setData(0, n, string6);
                    } else {
                        this.setData(0, n, string3);
                    }
                }
                this.setData(1, n, string4);
                this.setData(2, n, d);
                if (this.getRowCount() > ++n) continue;
                this.addRows(n, n2);
            }
            int n4 = this.getRowCount() - n;
            if (n4 > 0) {
                this.removeRows(n, n4);
            }
            if (bl) {
                this.addRows(0, 1);
                this.setData(0, 0, DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT"));
            }
        }
        catch (Exception exception) {
            this.addRows(0, 1);
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void load(Object object, Object object2, HashMap hashMap) {
        try {
            String string;
            ClassificationModel classificationModel;
            this.m_model = classificationModel = (ClassificationModel)object;
            String string2 = null;
            Hashtable hashtable = (Hashtable)hashMap.get("MENU_DATA_XFORM_NORMALIZE");
            if (hashtable != null) {
                string2 = (String)hashtable.get("XNORM");
            }
            this.m_lookupTableMap = (Hashtable)hashMap.get("COMMON_TEXT_LOOKUP");
            Vector vector = new Vector();
            String string3 = "";
            if (string2 != null) {
                string3 = BrowserFrame.is11Server() ? QRY_DENORMALIZED_CLASSIFICATION_ALL_COEFFICIENTS_11G : QRY_DENORMALIZED_CLASSIFICATION_ALL_COEFFICIENTS;
                string3 = BrowserUtils.getReplacedString(string3, "<norm_table>", string2);
            } else {
                string3 = BrowserFrame.is11Server() ? QRY_CLASSIFICATION_ALL_COEFFICIENTS_11G : QRY_CLASSIFICATION_ALL_COEFFICIENTS;
            }
            String string4 = classificationModel.getName();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            Vector vector2 = null;
            Double d = null;
            Double d2 = null;
            Boolean bl = null;
            Boolean bl2 = null;
            Integer n = null;
            String string10 = null;
            String string11 = null;
            String string12 = string = BrowserFrame.is11Server() ? " NVL2( m.attr_subname, m.attr || '.' || m.attr_subname, m.attr) " : " m.attr ";
            if (hashMap != null) {
                vector2 = (Vector)hashMap.get("COMMON_FILTER_ATTRIBUTES");
                d = (Double)hashMap.get("COMMON_FILTER_TOP");
                d2 = (Double)hashMap.get("COMMON_FILTER_BOTTOM");
                bl = (Boolean)hashMap.get("COMMON_FILTER_BY_ABSOULTE_VALUES");
                bl2 = (Boolean)hashMap.get("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES");
                n = (Integer)hashMap.get("COMMON_FETCH_SIZE");
                string10 = (String)hashMap.get("COMMON_FILTER_SORT_VALUE");
                string11 = (String)hashMap.get("COMMON_FILTER_SORT_ORDER");
                if (vector2 != null && vector2.size() > 0) {
                    String string13 = "";
                    String string14 = "";
                    String string15 = "";
                    for (int i = 0; i < vector2.size(); ++i) {
                        string15 = (String)vector2.get(i);
                        if (this.m_lookupTableMap != null && !BrowserFrame.is11Server()) {
                            Enumeration enumeration = this.m_lookupTableMap.keys();
                            String string16 = null;
                            String string17 = string15;
                            while (enumeration.hasMoreElements()) {
                                string16 = (String)enumeration.nextElement();
                                if (this.m_lookupTableMap.get(string16) == null || !string17.equalsIgnoreCase((String)this.m_lookupTableMap.get(string16))) continue;
                                string15 = string16;
                                break;
                            }
                        }
                        string14 = string14 == "" ? string14 + "'" + DM4JStringUtils.escapeSingleQuotesForSQL(string15) + "'" : string14 + ",'" + DM4JStringUtils.escapeSingleQuotesForSQL(string15) + "'";
                        if ((i + 1) % 1000 != 0) continue;
                        if (i + 1 > 1000) {
                            string13 = bl2 != null && bl2 == true ? string13 + " OR " : string13 + " AND ";
                        }
                        string13 = bl2 != null && bl2 == true ? string13 + string + "in (" + string14 + " )" : string13 + string + " not in (" + string14 + " )";
                        string14 = "";
                    }
                    if (string13.length() > 0) {
                        if (string14.length() > 0) {
                            string13 = bl2 != null && bl2 == true ? string13 + " OR " + string + " in (" + string14 + " )" : string13 + " AND " + string + " not in (" + string14 + " )";
                        }
                        string5 = " AND ( " + string13 + " ) ";
                    } else {
                        string5 = bl2 != null && bl2 == true ? " AND " + string + " in (" + string14 + " )" : " AND " + string + "not in (" + string14 + " )";
                    }
                }
                if (hashtable == null) {
                    if (d != null) {
                        string6 = bl != null && bl == true ? " AND abs(coefficient) <= " + d : " AND coefficient <= " + d;
                    }
                    if (d2 != null) {
                        string7 = bl != null && bl.booleanValue() ? " AND abs(coefficient) >= " + d2 : " AND coefficient >= " + d2;
                    }
                } else {
                    if (d != null) {
                        string6 = bl != null && bl == true ? " AND abs(c.coefficient/nvl(n.scale, 1)) <= " + d : " AND c.coefficient/nvl(n.scale, 1) <= " + d;
                    }
                    if (d2 != null) {
                        string7 = bl != null && bl == true ? " AND abs(c.coefficient/nvl(n.scale, 1)) >= " + d2 : " AND c.coefficient/nvl(n.scale, 1) >= " + d2;
                    }
                }
                if (n != null) {
                    string8 = " where rownum <= " + n.toString();
                    this.m_fetchSize = n;
                }
                if (string10 != null && !string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ANY_ATTRIBUTE"))) {
                    if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT"))) {
                        string9 = " order by coefficient ";
                    } else if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ATTRIBUTE"))) {
                        string9 = " order by attribute_name ";
                    } else if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_VALUE"))) {
                        string9 = " order by attribute_value ";
                    }
                    if (string11 != null) {
                        if (string11.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"))) {
                            string9 = string9 + " ASC ";
                        } else if (string11.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"))) {
                            string9 = string9 + " DESC ";
                        }
                    }
                }
            }
            string3 = BrowserUtils.getReplacedString(string3, "<model_name>", string4);
            string3 = (object2 = this.getMappedTargetValue(object2)) instanceof Number ? BrowserUtils.getReplacedString(string3, "<target_value>", object2.toString()) : BrowserUtils.getReplacedString(string3, "<target_value>", "'" + object2.toString() + "'");
            string3 = BrowserUtils.getReplacedString(string3, "<and1>", string5);
            string3 = BrowserUtils.getReplacedString(string3, "<and2>", string6);
            string3 = BrowserUtils.getReplacedString(string3, "<and3>", string7);
            string3 = BrowserUtils.getReplacedString(string3, "<order>", string9);
            string3 = BrowserUtils.getReplacedString(string3, "<rownum>", string8);
            this.updateTable(string3);
        }
        catch (Exception exception) {
            this.addRows(0, 1);
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
        }
    }

    public void load(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMappedTargetValue(Object object) throws Exception {
        if (object instanceof Number) {
            return object;
        }
        Object object2 = this.m_targetMap.get(object);
        if (object2 != null) {
            return object2;
        }
        Vector vector = new Vector();
        Connection connection = null;
        try {
            object2 = object;
            connection = DM4JConnectionManager.getDbConnection();
            String string = this.m_model.getName();
            String string2 = this.m_model.getTargetAttributeName();
            String string3 = "select vid from \"DM$PD<model_name>\" where upper(attr) = '<target>' and sval = '<target_value>'";
            string3 = BrowserUtils.getReplacedString(string3, "<model_name>", string);
            string3 = BrowserUtils.getReplacedString(string3, "<target>", DM4JStringUtils.escapeSingleQuotesForSQL(this.m_model.getTargetAttributeName().toUpperCase()));
            string3 = BrowserUtils.getReplacedString(string3, "<target_value>", object.toString());
            vector = BrowserUtils.getVectorData(connection, string3);
            if (vector != null) {
                Object[] objectArray = (Object[])vector.get(0);
                object2 = new Integer(objectArray[0].toString());
                this.m_targetMap.put(object, object2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return object2;
    }
}

