/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettings;
import javax.datamining.data.CategorySet;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesDialog;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class SVMClassificationModelContentPanel
extends GriddedPanel
implements VetoableChangeListener {
    ClassificationModel m_model = null;
    private JLabel m_targetAttribName = new JLabel();
    JLabel lblTarget = new JLabel();
    JComboBox targetComboBox = new JComboBox();
    HashMap m_targetMap = new HashMap();
    JLabel lblBias = new JLabel();
    JLabel lblBiasValue = new JLabel();
    JButton m_filter = new JButton();
    JButton m_scale = new JButton();
    boolean m_isScaled = false;
    JButton m_exportButton = new JButton();
    JCheckBox m_sortAbsoluteCoefficientValue = new JCheckBox();
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    String m_defaultSortBy = null;
    String m_defaultSortOrder = null;
    Hashtable m_xformTables = null;
    SVMCoefficientTable m_coefficientTable = null;
    JScrollPane m_coefficientScrollPane = new JScrollPane();
    HashMap m_condition = new HashMap();
    Hashtable m_lookupTableMap = null;
    boolean isOneClassSVM = false;

    public SVMClassificationModelContentPanel(LeafNodeData leafNodeData) {
        this.m_model = (ClassificationModel)leafNodeData.getOdmObject();
        try {
            this.isOneClassSVM = this.m_model.getTargetAttributeName() == null;
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return this.isOneClassSVM ? "dm4j_anomaly_result_viewer_html" : "SVM_CLASSIFICATION_MODEL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMappedTargetValue(Object object) throws Exception {
        if (object instanceof Number) {
            return object;
        }
        Object object2 = this.m_targetMap.get(object);
        if (object2 != null) {
            return object2;
        }
        Vector vector = new Vector();
        Connection connection = null;
        try {
            object2 = object;
            connection = DM4JConnectionManager.getDbConnection();
            String string = this.m_model.getName();
            String string2 = "select vid from \"DM$PE<model_name>\" where upper(attr) = '<target>' and sval = '<target_value>'";
            string2 = BrowserUtils.getReplacedString(string2, "<model_name>", string);
            string2 = BrowserUtils.getReplacedString(string2, "<target>", DM4JStringUtils.escapeSingleQuotesForSQL(this.m_model.getTargetAttributeName().toUpperCase()));
            string2 = BrowserUtils.getReplacedString(string2, "<target_value>", object.toString());
            vector = BrowserUtils.getVectorData(connection, string2);
            if (vector != null) {
                Object[] objectArray = (Object[])vector.get(0);
                object2 = new Integer(objectArray[0].toString());
                this.m_targetMap.put(object, object2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return object2;
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        this.lblTarget.setText(DM4JResourceUtilities.getUIString("CLASS_TARGET_CLASS") + ":");
        this.lblTarget.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TARGET_CLASS"));
        this.lblTarget.setLabelFor(this.targetComboBox);
        CategorySet categorySet = this.m_model.getTargetCategorySet();
        for (int i = 0; i < categorySet.getSize(); ++i) {
            this.targetComboBox.addItem(categorySet.getValue(i));
        }
        this.targetComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationModelContentPanel.this.targetComboBox_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.lblTarget, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.targetComboBox, TOPLABELITEMINSETS, n++, 1);
        boolean bl = false;
        try {
            SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)this.m_model.getBuildSettings().getAlgorithmSettings();
            bl = sVMClassificationSettings.getKernelFunction().equals(KernelFunction.kLinear);
        }
        catch (Exception exception) {
            System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
            exception.printStackTrace();
            bl = DMEMetadata.isSVMModelLinear(this.m_model.getName());
        }
        if (bl) {
            this.lblBias.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_BIAS") + ":");
            this.lblBias.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_BIAS"));
            this.lblBias.setLabelFor(this.lblBiasValue);
            this.addComponent(this.lblBias, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.lblBiasValue, MIDLABELITEMINSETS, n++, 1);
            this.m_coefficientTable = new SVMCoefficientTable(this.m_model);
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS"));
            this.addAnchoredComponent(jLabel2, MIDLABELITEMINSETS, n++, 0, 1, 1, 16);
            this.m_sortAbsoluteCoefficientValue.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
            this.m_sortAbsoluteCoefficientValue.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
            this.m_sortAbsoluteCoefficientValue.setSelected(false);
            this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
            this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
            this.m_exportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                        if (!exportDialog.isCancelled()) {
                            exportDialog.export(SVMClassificationModelContentPanel.this.m_coefficientTable);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            this.m_filter.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER"));
            this.m_filter.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER"));
            this.m_coefficientScrollPane.getViewport().add((Component)((Object)this.m_coefficientTable));
            this.m_coefficientScrollPane.setPreferredSize(null);
            this.m_defaultSortBy = DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT");
            this.m_defaultSortOrder = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
            JPanel jPanel = new JPanel();
            this.m_tfSize.setDataType(Integer.TYPE);
            this.m_tfSize.setNumber((Number)this.m_defaultFectchSize);
            this.m_tfSize.setSigned(false);
            this.m_tfSize.setColumns(5);
            this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
            this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
            this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
            this.m_lblSize.setLabelFor((Component)this.m_tfSize);
            this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
            this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
            this.m_btnRefresh.setEnabled(true);
            this.m_btnRefresh.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMClassificationModelContentPanel.this.m_btnRefresh_actionPerformed(actionEvent);
                }
            });
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.m_lblSize, gridBagConstraints);
            jPanel.add((Component)this.m_tfSize, gridBagConstraints);
            jPanel.add((Component)this.m_btnRefresh, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JLabel(), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new FlowLayout());
            jPanel2.add((Component)jPanel, "West");
            jPanel3.add(this.m_scale);
            jPanel3.add(this.m_filter);
            jPanel3.add(this.m_exportButton);
            jPanel2.add((Component)jPanel3, "East");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new FlowLayout());
            jPanel4.add((Component)jPanel5, "West");
            jPanel5.add(this.m_sortAbsoluteCoefficientValue);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel2, "North");
            jPanel6.add((Component)this.m_coefficientScrollPane, "Center");
            jPanel6.add((Component)jPanel4, "South");
            this.addFilledComponent(jPanel6, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
            this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        } else {
            this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        }
    }

    protected void m_sortAbsoluteCoefficientValue_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            boolean bl = this.m_sortAbsoluteCoefficientValue.isSelected();
            this.m_condition.put("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT", bl);
            int n = 2;
            if (bl) {
                this.m_coefficientTable.setSortAbsoluteCoefficient(true);
            } else {
                this.m_coefficientTable.setSortAbsoluteCoefficient(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void targetComboBox_actionPerformed(ActionEvent actionEvent) {
        if (!this.m_coefficientTable.isLoaded()) {
            return;
        }
        this.setCursor(new Cursor(3));
        try {
            Object object = this.targetComboBox.getSelectedItem();
            this.loadBias(object);
            this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
            this.m_coefficientTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Object object = this.targetComboBox.getSelectedItem();
            Number number = this.m_tfSize.getNumber();
            if (number == null) {
                DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                this.setCursor(new Cursor(0));
                return;
            }
            this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
            this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
            this.m_coefficientTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        this.m_model = (ClassificationModel)leafNodeData.getOdmObject();
        boolean bl = false;
        try {
            SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)this.m_model.getBuildSettings().getAlgorithmSettings();
            bl = sVMClassificationSettings.getKernelFunction().equals(KernelFunction.kLinear);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = DMEMetadata.isSVMModelLinear(this.m_model.getName());
        }
        if (bl) {
            DMEMetadata dMEMetadata;
            this.m_targetAttribName.setText(this.m_model.getTargetAttributeName());
            Object object = this.targetComboBox.getSelectedItem();
            if (this.targetComboBox.getItemCount() == 2) {
                this.targetComboBox.setSelectedIndex(1);
                object = this.targetComboBox.getSelectedItem();
            }
            this.m_condition.put("COMMON_FETCH_SIZE", this.m_defaultFectchSize);
            this.m_condition.put("COMMON_FILTER_SORT_VALUE", this.m_defaultSortBy);
            this.m_condition.put("COMMON_FILTER_SORT_ORDER", this.m_defaultSortOrder);
            this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(this.m_model.getName());
            this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
            this.m_xformTables = null;
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                dMEMetadata = DMEMetadata.getInstance();
                this.m_xformTables = dMEMetadata.getTransparencyTables(connection, null, this.m_model.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (null != connection) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (this.m_xformTables != null) {
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", this.m_xformTables);
                this.m_isScaled = true;
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", null);
                this.m_isScaled = false;
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            }
            this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
            this.loadBias(this.getMappedTargetValue(object));
            dMEMetadata = this.m_coefficientTable.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
            dMEMetadata.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
            generalGridSelectionManager.addVetoableChangeListener((VetoableChangeListener)this);
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_coefficientTable);
            this.m_filter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMClassificationModelContentPanel.this.m_filter_actionPerformed(actionEvent);
                }
            });
            this.m_scale.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMClassificationModelContentPanel.this.m_scale_actionPerformed(actionEvent);
                }
            });
            this.m_sortAbsoluteCoefficientValue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMClassificationModelContentPanel.this.m_sortAbsoluteCoefficientValue_actionPerformed(actionEvent);
                }
            });
            this.m_scale.setVisible(!this.isOneClassSVM);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string = DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT");
            String string2 = DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED");
            String string3 = "";
            if (n2 >= 0) {
                string3 = (String)this.m_coefficientTable.getGrid().getModel().getData(0, n2);
            }
            if (string3 != null) {
                if (string3.equals(string) || string3.equals(string2)) {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(false);
                    this.m_exportButton.setEnabled(false);
                    this.m_scale.setEnabled(false);
                } else {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(true);
                    this.m_exportButton.setEnabled(true);
                    this.m_filter.setEnabled(true);
                    if (this.m_model != null) {
                        if (this.m_xformTables != null) {
                            this.m_scale.setEnabled(true);
                        } else {
                            this.m_scale.setEnabled(false);
                        }
                    }
                }
                return;
            }
            this.m_sortAbsoluteCoefficientValue.setEnabled(true);
            this.m_exportButton.setEnabled(true);
            this.m_filter.setEnabled(true);
            if (this.m_model != null) {
                if (this.m_xformTables != null) {
                    this.m_scale.setEnabled(true);
                } else {
                    this.m_scale.setEnabled(false);
                }
            }
        }
        if (this.m_isScaled) {
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
        } else {
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
        }
    }

    protected void m_filter_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(new Cursor(3));
            FilterAttributesDialog filterAttributesDialog = new FilterAttributesDialog(null, this.m_model, this.m_condition, DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES_DIALOG"), true);
            this.setCursor(new Cursor(0));
            filterAttributesDialog.display();
            if (!filterAttributesDialog.isCancelled()) {
                Vector vector = filterAttributesDialog.getSelectedAttributes();
                Double d = filterAttributesDialog.getTopValue();
                Double d2 = filterAttributesDialog.getBottomValue();
                Boolean bl = filterAttributesDialog.isFilterByAbsoluteValue();
                Boolean bl2 = filterAttributesDialog.isIncludedAttributes();
                String string = filterAttributesDialog.getSortByValue();
                String string2 = filterAttributesDialog.getSortOrderValue();
                this.m_condition.put("COMMON_FILTER_ATTRIBUTES", vector);
                this.m_condition.put("COMMON_FILTER_TOP", d);
                this.m_condition.put("COMMON_FILTER_BOTTOM", d2);
                this.m_condition.put("COMMON_FILTER_BY_ABSOULTE_VALUES", bl);
                this.m_condition.put("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES", bl2);
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", string);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", string2);
                this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
                Object object = this.targetComboBox.getSelectedItem();
                this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.m_coefficientTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void m_scale_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_scale.getText();
        Object object = this.targetComboBox.getSelectedItem();
        try {
            if (string.equals(DM4JResourceUtilities.getUIString("COMMON_SCALE"))) {
                this.m_isScaled = true;
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", this.m_xformTables);
                this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.loadBias(this.getMappedTargetValue(object));
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_isScaled = false;
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", null);
                this.m_coefficientTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.loadBias(this.getMappedTargetValue(object));
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBias(Object object) {
        Object object2;
        Object[] objectArray = "SELECT (s.coefficient - de_norm.sum_coefficient) as bias  FROM  (SELECT (b * -1) as coefficient FROM \"DM$PZ<model_name>\" WHERE class_id = <target>) s,  (SELECT nvl(SUM(c.coefficient * n.shift / n.scale), 0) as sum_coefficient    FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, <norm_table> n    WHERE m.attr = n.col (+) AND c.class_id = <target> AND c.attr_id = m.aid AND m.aid != 1 AND n.scale <> 0) de_norm";
        String string = "SELECT b * -1 FROM \"DM$PZ<model_name>\" WHERE class_id = <target>";
        int n = 0;
        Vector vector = new Vector();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            object2 = null;
            if (this.m_isScaled) {
                object2 = objectArray;
                if (this.m_xformTables != null) {
                    object2 = BrowserUtils.getReplacedString((String)object2, "<norm_table>", (String)this.m_xformTables.get("XNORM"));
                }
            } else {
                object2 = string;
            }
            object2 = BrowserUtils.getReplacedString((String)object2, "<model_name>", this.m_model.getName());
            object2 = object instanceof Number ? BrowserUtils.getReplacedString((String)object2, "<target>", object.toString()) : BrowserUtils.getReplacedString((String)object2, "<target>", "'" + object.toString() + "'");
            vector = BrowserUtils.getVectorData(connection, (String)object2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        int n2 = n = vector != null ? vector.size() : 0;
        if (n > 0) {
            object2 = (Object[])vector.get(0);
            double d = new Double((String)object2[0]);
            this.lblBiasValue.setText(DM4JNumericFormat.format(d, true, 8) + "");
        } else {
            this.lblBiasValue.setText("");
        }
    }
}

