/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.EventObject;
import javax.datamining.rule.Rule;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.classification.ABNRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.LoadABNRulesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.RulesTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public final class RulesTable
extends Dm4jSpreadTable
implements ABNRulesLoadedListener {
    private LoadABNRulesWorker m_worker = null;
    private RulesTableModel m_tableModel;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_RULE_ID"), DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_IF_STMT"), DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_THEN_STMT"), DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE"), DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT")};
    int[] m_colWidths = new int[]{15, 35, 20, 15, 15};

    public RulesTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load() throws Exception {
        this.setColumnWidths(this.m_colWidths, true);
        ClassificationModel classificationModel = (ClassificationModel)this.getDataItem();
        if (null == classificationModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadABNRulesWorker)workerThreadManager.getLoadABNRulesWorker(classificationModel);
        this.m_worker.addABNRulesLoadedListener(this);
        this.m_worker.start();
    }

    public void rulesLoaded(EventObject eventObject) {
        Grid grid;
        RulesTableModel rulesTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = rulesTableModel = (RulesTableModel)((Object)eventObject.getSource());
        this.setModels((TwoDModel)rulesTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                grid = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)grid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        grid = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        grid.setColumnPainter(3, (Painter)dM4JTruncatingNumberFormatPainter);
        grid.setColumnPainter(4, (Painter)dM4JTruncatingNumberFormatPainter2);
    }

    public Rule getMiningRule(int n) {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getMiningRule(n);
        }
        return null;
    }
}

