/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.data.CategorySet;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesDialog;
import oracle.dmt.dm4j.browser.viewer.classification.NBPairProbabilitiesTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.modeldetail.naivebayes.OraNaiveBayesModelDetail;

public class NBPairProbabilitiesPanel
extends GriddedPanel
implements VetoableChangeListener {
    ClassificationModel m_model = null;
    private JLabel m_targetAttribName = new JLabel();
    JLabel lblTarget = new JLabel();
    JComboBox targetComboBox = new JComboBox();
    HashMap m_targetMap = new HashMap();
    JLabel lblTargetProbability = new JLabel();
    JLabel lblTargetProbabilityValue = new JLabel();
    JButton m_filter = new JButton();
    JButton m_unbin = new JButton();
    boolean m_isUnBinned = false;
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    String m_defaultSortBy = null;
    String m_defaultSortOrder = null;
    Hashtable m_xformTables = null;
    NBPairProbabilitiesTable m_pairProbabilitiesTable = null;
    JScrollPane m_pairProbabilitiesScrollPane = new JScrollPane();
    JButton m_exportButton = new JButton();
    HashMap m_condition = new HashMap();

    public NBPairProbabilitiesPanel(LeafNodeData leafNodeData) {
        this.m_model = (ClassificationModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "NB_MODEL";
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        this.lblTarget.setText(DM4JResourceUtilities.getUIString("CLASS_TARGET_CLASS") + ":");
        this.lblTarget.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TARGET_CLASS"));
        this.lblTarget.setLabelFor(this.targetComboBox);
        CategorySet categorySet = this.m_model.getTargetCategorySet();
        Object[] objectArray = categorySet.getValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.targetComboBox.addItem(objectArray[i]);
        }
        this.targetComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NBPairProbabilitiesPanel.this.targetComboBox_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.lblTarget, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.targetComboBox, TOPLABELITEMINSETS, n++, 1);
        this.lblTargetProbability.setText(DM4JResourceUtilities.getUIString("CLASS_PRIOR_PROBABILITY") + ":");
        this.lblTargetProbability.setLabelFor(this.lblTargetProbabilityValue);
        this.addComponent(this.lblTargetProbability, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.lblTargetProbabilityValue, MIDLABELITEMINSETS, n++, 1);
        this.m_pairProbabilitiesTable = new NBPairProbabilitiesTable(this.m_model);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("CLASS_PAIR_PROBABILITIES"));
        this.addComponent(jLabel2, TOPLABELITEMINSETS, n++, 0);
        this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
        this.m_unbin.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
        this.m_filter.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER"));
        this.m_filter.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER"));
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(NBPairProbabilitiesPanel.this.m_pairProbabilitiesTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_pairProbabilitiesScrollPane.getViewport().add((Component)((Object)this.m_pairProbabilitiesTable));
        this.m_pairProbabilitiesScrollPane.setPreferredSize(null);
        this.m_defaultSortBy = DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_PROBABILITY");
        this.m_defaultSortOrder = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
        JPanel jPanel = new JPanel();
        this.m_tfSize.setDataType(Integer.TYPE);
        this.m_tfSize.setNumber((Number)this.m_defaultFectchSize);
        this.m_tfSize.setSigned(false);
        this.m_tfSize.setColumns(5);
        this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setLabelFor((Component)this.m_tfSize);
        this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setEnabled(true);
        this.m_btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NBPairProbabilitiesPanel.this.m_btnRefresh_actionPerformed(actionEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.m_lblSize, gridBagConstraints);
        jPanel.add((Component)this.m_tfSize, gridBagConstraints);
        jPanel.add((Component)this.m_btnRefresh, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel3.add(this.m_unbin);
        jPanel3.add(this.m_filter);
        jPanel3.add(this.m_exportButton);
        jPanel2.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)this.m_pairProbabilitiesScrollPane, "Center");
        this.addFilledComponent(jPanel4, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMappedTargetValue(Object object) throws Exception {
        if (object instanceof Number) {
            return object;
        }
        Object object2 = this.m_targetMap.get(object);
        if (object2 != null) {
            return object2;
        }
        Vector vector = new Vector();
        Connection connection = null;
        try {
            object2 = object;
            connection = DM4JConnectionManager.getDbConnection();
            String string = this.m_model.getName();
            String string2 = "select nval from DM$PE<model_name> where upper(attr) = '<target>' and sval = '<target_value>'";
            string2 = BrowserUtils.getReplacedString(string2, "<model_name>", string);
            string2 = BrowserUtils.getReplacedString(string2, "<target>", DM4JStringUtils.escapeSingleQuotesForSQL(this.m_model.getTargetAttributeName().toUpperCase()));
            string2 = BrowserUtils.getReplacedString(string2, "<target_value>", object.toString());
            vector = BrowserUtils.getVectorData(connection, string2);
            if (vector != null) {
                Object[] objectArray = (Object[])vector.get(0);
                object2 = new Integer(objectArray[0].toString());
                this.m_targetMap.put(object, object2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getTargetProbability(Object object) throws Exception {
        double d = 0.0;
        Vector vector = new Vector();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = "";
            String string2 = "select EXP(p.LOG_PRIOR) from DM$P1<model_name> p where value = <target_value>";
            String string3 = this.m_model.getName();
            Object object2 = object;
            string = string2;
            string = BrowserUtils.getReplacedString(string, "<model_name>", string3);
            string = BrowserUtils.getReplacedString(string, "<target_value>", object2.toString());
            vector = BrowserUtils.getVectorData(connection, string);
            if (vector != null) {
                Object[] objectArray = (Object[])vector.get(0);
                Double d2 = new Double(objectArray[0].toString());
                d = d2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return d;
    }

    private void targetComboBox_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            double d = 0.0;
            Object object = this.targetComboBox.getSelectedItem();
            try {
                d = this.getTargetProbability(this.getMappedTargetValue(object));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lblTargetProbabilityValue.setText(DM4JNumericFormat.format(d, false, 10));
            this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
            this.m_pairProbabilitiesTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m_filter_actionPerformed(ActionEvent actionEvent) {
        try {
            FilterAttributesDialog filterAttributesDialog = null;
            try {
                this.setCursor(new Cursor(3));
                filterAttributesDialog = new FilterAttributesDialog(null, this.m_model, this.m_condition, DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES_DIALOG"), true);
            }
            finally {
                this.setCursor(new Cursor(0));
            }
            filterAttributesDialog.display();
            if (!filterAttributesDialog.isCancelled()) {
                Vector vector = filterAttributesDialog.getSelectedAttributes();
                Double d = filterAttributesDialog.getTopValue();
                Double d2 = filterAttributesDialog.getBottomValue();
                Boolean bl = filterAttributesDialog.isFilterByAbsoluteValue();
                Boolean bl2 = filterAttributesDialog.isIncludedAttributes();
                String string = filterAttributesDialog.getSortByValue();
                String string2 = filterAttributesDialog.getSortOrderValue();
                this.m_condition = new HashMap();
                this.m_condition.put("COMMON_FILTER_ATTRIBUTES", vector);
                this.m_condition.put("COMMON_FILTER_TOP", d);
                this.m_condition.put("COMMON_FILTER_BOTTOM", d2);
                this.m_condition.put("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES", bl2);
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.m_tfSize.requestFocus();
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", string);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", string2);
                Object object = this.targetComboBox.getSelectedItem();
                this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.m_pairProbabilitiesTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Object object = this.targetComboBox.getSelectedItem();
            Number number = this.m_tfSize.getNumber();
            if (number == null) {
                DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                this.m_tfSize.requestFocus();
                this.setCursor(new Cursor(0));
                return;
            }
            this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
            this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
            this.m_pairProbabilitiesTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        DMEMetadata dMEMetadata;
        this.m_model = (ClassificationModel)leafNodeData.getOdmObject();
        this.m_targetAttribName.setText(this.m_model.getTargetAttributeName());
        OraNaiveBayesModelDetail oraNaiveBayesModelDetail = (OraNaiveBayesModelDetail)this.m_model.getModelDetail();
        double d = 0.0;
        Object object = this.targetComboBox.getSelectedItem();
        try {
            d = this.getTargetProbability(this.getMappedTargetValue(object));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblTargetProbabilityValue.setText(DM4JNumericFormat.format(d, false, 10));
        this.m_condition.put("COMMON_FETCH_SIZE", this.m_defaultFectchSize);
        this.m_condition.put("COMMON_FILTER_SORT_VALUE", this.m_defaultSortBy);
        this.m_condition.put("COMMON_FILTER_SORT_ORDER", this.m_defaultSortOrder);
        this.m_xformTables = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            dMEMetadata = DMEMetadata.getInstance();
            this.m_xformTables = dMEMetadata.getTransparencyTables(connection, null, this.m_model.getName());
        }
        catch (Exception exception) {
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_xformTables != null) {
            this.m_condition.put("MENU_DATA_XFORM_BIN", this.m_xformTables);
            this.m_isUnBinned = true;
            this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
            this.m_unbin.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
        } else {
            this.m_condition.put("MENU_DATA_XFORM_BIN", null);
            this.m_isUnBinned = false;
            this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
            this.m_unbin.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
        }
        this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
        dMEMetadata = this.m_pairProbabilitiesTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        dMEMetadata.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        generalGridSelectionManager.addVetoableChangeListener((VetoableChangeListener)this);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_pairProbabilitiesTable);
        this.m_filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NBPairProbabilitiesPanel.this.m_filter_actionPerformed(actionEvent);
            }
        });
        this.m_unbin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NBPairProbabilitiesPanel.this.m_unbin_actionPerformed(actionEvent);
            }
        });
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string = DM4JResourceUtilities.getUIString("CLASS_NB_PAIR_PROBABILITIES_NO_ROW");
            String string2 = DM4JResourceUtilities.getUIString("CLASS_NB_GET_PAIR_PROBABILITIES_FAILED");
            String string3 = "";
            if (n2 >= 0) {
                string3 = (String)this.m_pairProbabilitiesTable.getGrid().getModel().getData(0, n2);
            }
            if (string3 != null) {
                if (string3.equals(string) || string3.equals(string2)) {
                    this.m_exportButton.setEnabled(false);
                    this.m_unbin.setEnabled(false);
                } else {
                    this.m_exportButton.setEnabled(true);
                    this.m_filter.setEnabled(true);
                    if (this.m_model != null) {
                        if (this.m_xformTables != null) {
                            this.m_unbin.setEnabled(true);
                        } else {
                            this.m_unbin.setEnabled(false);
                        }
                    }
                }
            }
        }
        if (this.m_isUnBinned) {
            this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
        } else {
            this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
        }
    }

    protected void m_unbin_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_unbin.getText();
        Object object = this.targetComboBox.getSelectedItem();
        try {
            if (string.equals(DM4JResourceUtilities.getUIString("COMMON_UNBIN"))) {
                this.m_isUnBinned = true;
                this.m_condition.put("MENU_DATA_XFORM_BIN", this.m_xformTables);
                this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
                this.m_unbin.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
            } else {
                this.m_isUnBinned = false;
                this.m_condition.put("MENU_DATA_XFORM_BIN", null);
                this.m_pairProbabilitiesTable.load(this.getMappedTargetValue(object), this.m_condition);
                this.m_unbin.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
                this.m_unbin.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

