/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.EventObject;
import java.util.HashMap;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadSVMCoefficientWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClassificationModel m_miningModel = null;
    private Object m_targetValue = null;
    private HashMap m_condition = null;
    private SVMCoefficientTableModel m_tableModel = null;

    public LoadSVMCoefficientWorker(WorkerThreadManager workerThreadManager, ClassificationModel classificationModel, Object object, HashMap hashMap) {
        super(workerThreadManager);
        this.m_miningModel = classificationModel;
        this.m_targetValue = object;
        this.m_condition = hashMap;
    }

    public void addSVMCoefficientLoadedListener(SVMCoefficientLoadedListener sVMCoefficientLoadedListener) {
        this.listenerList.add(SVMCoefficientLoadedListener.class, sVMCoefficientLoadedListener);
    }

    public void removeSVMCoefficientLoadedListener(SVMCoefficientLoadedListener sVMCoefficientLoadedListener) {
        this.listenerList.remove(SVMCoefficientLoadedListener.class, sVMCoefficientLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new SVMCoefficientTableModel();
            this.m_tableModel.load(this.m_miningModel, this.m_targetValue, this.m_condition);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SVMCoefficientLoadedListener.class) continue;
            ((SVMCoefficientLoadedListener)objectArray[i + 1]).svmCoefficientLoaded(new EventObject(this.getValue()));
        }
    }
}

