/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.EventObject;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.classification.ABNRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.RulesTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadABNRulesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClassificationModel m_miningModel = null;
    private RulesTableModel m_tableModel = null;

    public LoadABNRulesWorker(WorkerThreadManager workerThreadManager, ClassificationModel classificationModel) {
        super(workerThreadManager);
        this.m_miningModel = classificationModel;
    }

    public void addABNRulesLoadedListener(ABNRulesLoadedListener aBNRulesLoadedListener) {
        this.listenerList.add(ABNRulesLoadedListener.class, aBNRulesLoadedListener);
    }

    public void removeABNRulesLoadedListener(ABNRulesLoadedListener aBNRulesLoadedListener) {
        this.listenerList.remove(ABNRulesLoadedListener.class, aBNRulesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new RulesTableModel();
            this.m_tableModel.load(this.m_miningModel);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ABNRulesLoadedListener.class) continue;
            ((ABNRulesLoadedListener)objectArray[i + 1]).rulesLoaded(new EventObject(this.getValue()));
        }
    }
}

