/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.EventObject;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.classification.DetailRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.DetailRulesTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadABNDetailRulesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClassificationModel m_miningModel = null;
    private DetailRulesTableModel m_tableModel = null;
    private int m_columnCount = 0;

    public LoadABNDetailRulesWorker(WorkerThreadManager workerThreadManager, ClassificationModel classificationModel, int n) {
        super(workerThreadManager);
        this.m_miningModel = classificationModel;
        this.m_columnCount = n;
    }

    public void addDetailRulesLoadedListener(DetailRulesLoadedListener detailRulesLoadedListener) {
        this.listenerList.add(DetailRulesLoadedListener.class, detailRulesLoadedListener);
    }

    public void removeDetailRulesLoadedListener(DetailRulesLoadedListener detailRulesLoadedListener) {
        this.listenerList.remove(DetailRulesLoadedListener.class, detailRulesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new DetailRulesTableModel(this.m_columnCount, 0);
            this.m_tableModel.load(this.m_miningModel);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DetailRulesLoadedListener.class) continue;
            ((DetailRulesLoadedListener)objectArray[i + 1]).detailRulesLoaded(new EventObject(this.getValue()));
        }
    }
}

