/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.MiningFunction;
import javax.datamining.base.Model;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.jdm.data.OraAttributeCoefficient;
import oracle.dmt.jdm.modeldetail.glm.OraGLMModelDetail;

public class GLMCoefficientTableModel
extends Dm4jSortableTwoDModel {
    private OraAttributeCoefficient[] m_attributeCoefficients = null;
    private Model m_model;
    private Vector m_interceptRow = new Vector();
    private static final String QRY_CLASSIFICATION_ALL_COEFFICIENTS_11G = "SELECT * FROM (SELECT NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) attribute_name, attribute_value, coefficient, STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT FROM TABLE(dbms_data_mining.get_model_details_glm('<model_name>')) WHERE class = <target_value> AND attribute_name is not null  <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static final String QRY_GET_INTERCEPT_ROW_11G = "SELECT coefficient, STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT FROM TABLE(dbms_data_mining.get_model_details_glm('<model_name>')) WHERE attribute_name is null";
    private static final String QRY_GET_R_INTERCEPT_ROW_11G = "SELECT coefficient, STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT, VIF FROM TABLE(dbms_data_mining.get_model_details_glm('<model_name>')) WHERE attribute_name is null";
    private static final String QRY_REGRESSION_ALL_COEFFICIENTS_11G = "SELECT * FROM (SELECT NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) attribute_name, attribute_value, coefficient, STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT, VIF FROM TABLE(dbms_data_mining.get_model_details_glm('<model_name>')) WHERE attribute_name is not null   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private int m_fetchSize = 1000;
    private Hashtable m_lookupTableMap = null;
    private boolean _isClassification = true;
    private boolean _isCovarianceMatrixComputed = true;

    public void isClassification(boolean bl) {
        this._isClassification = bl;
    }

    public void isCovarianceMatrixComputed(boolean bl) {
        this._isCovarianceMatrixComputed = bl;
    }

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_attributeCoefficients != null ? this.m_attributeCoefficients[n] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(String string) {
        this.addRows(0, 1);
        if (this._isClassification) {
            if (this._isCovarianceMatrixComputed) {
                this.addColumns(0, 12);
            } else {
                this.addColumns(0, 3);
            }
        } else if (this._isCovarianceMatrixComputed) {
            this.addColumns(0, 13);
        } else {
            this.addColumns(0, 4);
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            statement.setFetchSize(this.m_fetchSize);
            resultSet = statement.executeQuery(string);
            int n2 = 0;
            int n3 = 1;
            this.addRows(n2, n3);
            Double d = null;
            Double d2 = null;
            Double d3 = null;
            Double d4 = null;
            Double d5 = null;
            Double d6 = null;
            Double d7 = null;
            Double d8 = null;
            Double d9 = null;
            double d10 = 0.0;
            boolean bl = true;
            while (resultSet.next()) {
                bl = false;
                String string2 = resultSet.getString("attribute_name");
                String string3 = resultSet.getString("attribute_value");
                Double d11 = resultSet.getDouble("coefficient");
                if (this._isCovarianceMatrixComputed) {
                    d = resultSet.getDouble("std_error");
                    d2 = resultSet.getDouble("TEST_STATISTIC");
                    d3 = resultSet.getDouble("P_VALUE");
                    d5 = resultSet.getDouble("STD_COEFFICIENT");
                    d6 = resultSet.getDouble("LOWER_COEFF_LIMIT");
                    d7 = resultSet.getDouble("UPPER_COEFF_LIMIT");
                    d8 = resultSet.getDouble("EXP_COEFFICIENT");
                    d9 = resultSet.getDouble("EXP_LOWER_COEFF_LIMIT");
                    d10 = resultSet.getDouble("EXP_UPPER_COEFF_LIMIT");
                }
                if (!this._isClassification) {
                    d4 = resultSet.getDouble("VIF");
                }
                if (this.m_lookupTableMap == null) {
                    this.setData(0, n2, string2);
                } else {
                    String string4 = string2;
                    String string5 = null;
                    if (this.m_lookupTableMap != null && string4 != null) {
                        string5 = (String)this.m_lookupTableMap.get(string4);
                    }
                    if (string5 != null) {
                        this.setData(0, n2, string5);
                    } else {
                        this.setData(0, n2, string2);
                    }
                }
                this.setData(1, n2, string3);
                this.setData(2, n2, d11);
                n = 3;
                if (this._isCovarianceMatrixComputed) {
                    this.setData(3, n2, d);
                    this.setData(4, n2, d2);
                    this.setData(5, n2, d3);
                    this.setData(6, n2, d5);
                    this.setData(7, n2, d6);
                    this.setData(8, n2, d7);
                    this.setData(9, n2, d8);
                    this.setData(10, n2, d9);
                    this.setData(11, n2, new Double(d10));
                    n = 12;
                }
                if (!this._isClassification) {
                    this.setData(n, n2, d4);
                }
                if (this.getRowCount() > ++n2) continue;
                this.addRows(n2, n3);
            }
            n = this.getRowCount() - n2;
            if (n > 0) {
                this.removeRows(n2, n);
            }
            if (bl) {
                this.addRows(0, 1);
                this.setData(0, 0, DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT"));
            }
            this.loadInterceptRow(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.addRows(0, 1);
            this.setData(0, 0, exception.getClass().getName() + DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void addInterceptRow() {
        int n = this.gerIntercentRowIndex();
        if (n == -1) {
            this.addRows(0, 1);
            int n2 = 0;
            this.setData(n2++, 0, DM4JResourceUtilities.getUIString("GLM_INTERCEPT_VALUE"));
            this.setData(n2++, 0, null);
            for (int i = 0; i < this.m_interceptRow.size(); ++i) {
                this.setData(n2++, 0, this.m_interceptRow.get(i));
            }
        }
    }

    public void removeInterceptRow() {
        int n = this.gerIntercentRowIndex();
        if (n != -1) {
            this.removeRows(n, 1);
        }
    }

    private int gerIntercentRowIndex() {
        int n = this.getRowCount();
        String string = null;
        String string2 = DM4JResourceUtilities.getUIString("GLM_INTERCEPT_VALUE");
        for (int i = 0; i < n; ++i) {
            string = (String)this.getData(0, i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void load(Object object, Object object2, HashMap hashMap) {
        try {
            Model model;
            this.m_model = model = (Model)object;
            this._isClassification = MiningFunction.classification.equals(model.getMiningFunction());
            Number number = (Number)((OraGLMModelDetail)this.m_model.getModelDetail()).getGlobalDetails().get("VALID_COVARIANCE_MATRIX");
            this._isCovarianceMatrixComputed = number == null || 1 == number.intValue();
            String string = null;
            Hashtable hashtable = (Hashtable)hashMap.get("MENU_DATA_XFORM_NORMALIZE");
            if (hashtable != null) {
                string = (String)hashtable.get("XNORM");
            }
            this.m_lookupTableMap = (Hashtable)hashMap.get("COMMON_TEXT_LOOKUP");
            Vector vector = new Vector();
            String string2 = QRY_REGRESSION_ALL_COEFFICIENTS_11G;
            if (this._isClassification) {
                string2 = QRY_CLASSIFICATION_ALL_COEFFICIENTS_11G;
            }
            String string3 = model.getName();
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            Vector vector2 = null;
            Double d = null;
            Double d2 = null;
            Boolean bl = null;
            Boolean bl2 = null;
            Integer n = null;
            String string9 = null;
            String string10 = null;
            String string11 = "NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) ";
            if (hashMap != null) {
                vector2 = (Vector)hashMap.get("COMMON_FILTER_ATTRIBUTES");
                d = (Double)hashMap.get("COMMON_FILTER_TOP");
                d2 = (Double)hashMap.get("COMMON_FILTER_BOTTOM");
                bl = (Boolean)hashMap.get("COMMON_FILTER_BY_ABSOULTE_VALUES");
                bl2 = (Boolean)hashMap.get("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES");
                n = (Integer)hashMap.get("COMMON_FETCH_SIZE");
                string9 = (String)hashMap.get("COMMON_FILTER_SORT_VALUE");
                string10 = (String)hashMap.get("COMMON_FILTER_SORT_ORDER");
                if (vector2 != null && vector2.size() > 0) {
                    String string12 = "";
                    String string13 = "";
                    String string14 = "";
                    for (int i = 0; i < vector2.size(); ++i) {
                        string14 = (String)vector2.get(i);
                        if (this.m_lookupTableMap != null) {
                            Enumeration enumeration = this.m_lookupTableMap.keys();
                            String string15 = null;
                            String string16 = string14;
                            while (enumeration.hasMoreElements()) {
                                string15 = (String)enumeration.nextElement();
                                if (this.m_lookupTableMap.get(string15) == null || !string16.equalsIgnoreCase((String)this.m_lookupTableMap.get(string15))) continue;
                                string14 = string15;
                                break;
                            }
                        }
                        string13 = string13 == "" ? string13 + "'" + DM4JStringUtils.escapeSingleQuotesForSQL(string14) + "'" : string13 + ",'" + DM4JStringUtils.escapeSingleQuotesForSQL(string14) + "'";
                        if ((i + 1) % 1000 != 0) continue;
                        if (i + 1 > 1000) {
                            string12 = bl2 != null && bl2 == true ? string12 + " OR " : string12 + " AND ";
                        }
                        string12 = bl2 != null && bl2 == true ? string12 + string11 + "in (" + string13 + " )" : string12 + string11 + " not in (" + string13 + " )";
                        string13 = "";
                    }
                    if (string12.length() > 0) {
                        if (string13.length() > 0) {
                            string12 = bl2 != null && bl2 == true ? string12 + " OR " + string11 + " in (" + string13 + " )" : string12 + " AND " + string11 + " not in (" + string13 + " )";
                        }
                        string4 = " AND ( " + string12 + " ) ";
                    } else {
                        string4 = bl2 != null && bl2 == true ? " AND " + string11 + " in (" + string13 + " )" : " AND " + string11 + "not in (" + string13 + " )";
                    }
                }
                if (d != null) {
                    string5 = bl != null && bl == true ? " AND abs(coefficient) <= " + d : " AND coefficient <= " + d;
                }
                if (d2 != null) {
                    string6 = bl != null && bl == true ? " AND abs(coefficient) >= " + d2 : " AND coefficient >= " + d2;
                }
                if (n != null) {
                    string7 = " where rownum <= " + n.toString();
                    this.m_fetchSize = n;
                }
                if (string9 != null && !string9.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ANY_ATTRIBUTE"))) {
                    if (string9.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT"))) {
                        string8 = " order by coefficient ";
                    } else if (string9.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ATTRIBUTE"))) {
                        string8 = " order by attribute_name ";
                    } else if (string9.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_VALUE"))) {
                        string8 = " order by attribute_value ";
                    }
                    if (string10 != null) {
                        if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"))) {
                            string8 = string8 + " ASC ";
                        } else if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"))) {
                            string8 = string8 + " DESC ";
                        }
                    }
                }
            }
            string2 = BrowserUtils.getReplacedString(string2, "<model_name>", string3);
            object2 = this.getMappedTargetValue(object2);
            if (this._isClassification) {
                string2 = object2 instanceof Number ? BrowserUtils.getReplacedString(string2, "<target_value>", object2.toString()) : BrowserUtils.getReplacedString(string2, "<target_value>", "'" + object2.toString() + "'");
            }
            string2 = BrowserUtils.getReplacedString(string2, "<and1>", string4);
            string2 = BrowserUtils.getReplacedString(string2, "<and2>", string5);
            string2 = BrowserUtils.getReplacedString(string2, "<and3>", string6);
            string2 = BrowserUtils.getReplacedString(string2, "<order>", string8);
            string2 = BrowserUtils.getReplacedString(string2, "<rownum>", string7);
            this.updateTable(string2);
        }
        catch (Exception exception) {
            this.addRows(0, 1);
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
        }
    }

    public void load(Object object) {
    }

    private Object getMappedTargetValue(Object object) throws Exception {
        return object;
    }

    private void loadInterceptRow(Connection connection) throws Exception {
        if (this.m_interceptRow.size() == 0) {
            String string = null;
            string = this._isClassification ? BrowserUtils.getReplacedString(QRY_GET_INTERCEPT_ROW_11G, "<model_name>", this.m_model.getName()) : BrowserUtils.getReplacedString(QRY_GET_R_INTERCEPT_ROW_11G, "<model_name>", this.m_model.getName());
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    this.m_interceptRow.add(resultSet.getDouble("COEFFICIENT"));
                    if (this._isCovarianceMatrixComputed) {
                        this.m_interceptRow.add(resultSet.getDouble("STD_ERROR"));
                        this.m_interceptRow.add(resultSet.getDouble("TEST_STATISTIC"));
                        this.m_interceptRow.add(resultSet.getDouble("P_VALUE"));
                        this.m_interceptRow.add(resultSet.getDouble("STD_COEFFICIENT"));
                        this.m_interceptRow.add(resultSet.getDouble("LOWER_COEFF_LIMIT"));
                        this.m_interceptRow.add(resultSet.getDouble("UPPER_COEFF_LIMIT"));
                        this.m_interceptRow.add(resultSet.getDouble("EXP_COEFFICIENT"));
                        this.m_interceptRow.add(resultSet.getDouble("EXP_LOWER_COEFF_LIMIT"));
                        this.m_interceptRow.add(resultSet.getDouble("EXP_UPPER_COEFF_LIMIT"));
                    }
                    if (!this._isClassification) {
                        this.m_interceptRow.add(resultSet.getDouble("VIF"));
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

