/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.Locale;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JSplitPane;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreePanel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeDetailPane;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class DecisionTreeSplitterPanel
extends JSplitPane {
    private DecisionTreePanel m_treePanel = null;
    private TreeNodeDetailPane m_detailPane = null;
    private ClassificationModel m_model = null;
    private TreeNode m_treeNode = null;
    private Graph m_graph = null;
    private boolean firstTimeLoad = true;

    public DecisionTreeSplitterPanel(ClassificationModel classificationModel, TreeNode treeNode) {
        try {
            this.m_model = classificationModel;
            this.m_treeNode = treeNode;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "TREE_MODEL";
    }

    private void jbInit() throws Exception {
        this.setOrientation(0);
        if (null == this.m_graph) {
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            defaultErrorHandler.setDebugMode(0);
            this.m_graph = new Graph((ErrorHandler)defaultErrorHandler);
            this.m_graph.setLocale(Locale.getDefault());
            this.m_graph.setGraphType(17);
            this.m_graph.setAutoLayout(2);
            this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
        }
        this.m_treePanel = new DecisionTreePanel(this, this.m_model);
        this.m_detailPane = new TreeNodeDetailPane(this.m_model, this.m_treeNode, this.m_graph);
        this.setTopComponent(this.m_treePanel);
        this.setBottomComponent(this.m_detailPane);
    }

    public void doLayout() {
        super.doLayout();
        if (this.firstTimeLoad) {
            this.firstTimeLoad = false;
            this.setDividerLocation(0.6);
        }
    }

    public void loadDetailPane(TreeNode treeNode) {
        int n = this.getDividerLocation();
        this.m_detailPane = new TreeNodeDetailPane(this.m_model, treeNode, this.m_graph);
        this.setBottomComponent(this.m_detailPane);
        this.setDividerLocation(n);
    }
}

