/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.grid.hGrid.HGridKeyHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreeSplitterPanel;
import oracle.dmt.dm4j.browser.viewer.classification.LoadTreeNodesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeDetailPane;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class DecisionTreePanel
extends GriddedPanel
implements TreeNodesLoadedListener,
VetoableChangeListener {
    private JLabel m_targetAttribName = new JLabel();
    private JCheckBox m_leavesOnly = new JCheckBox();
    private JButton m_expand = null;
    private JButton m_collapse = null;
    private JButton m_exportButton = null;
    private JSpinner m_levels = null;
    private JLabel m_levelsLabel = null;
    private JScrollPane m_nodesPane = new JScrollPane();
    private ClassificationModel m_miningModel = null;
    private TreeNodeTableModel m_tableModel = null;
    private RulesSpreadTable m_nodesTable = null;
    private SortableTwoDModel m_sortableModel;
    private DecisionTreeSplitterPanel m_parent = null;

    public DecisionTreePanel(DecisionTreeSplitterPanel decisionTreeSplitterPanel, ClassificationModel classificationModel) {
        this.m_miningModel = classificationModel;
        this.m_parent = decisionTreeSplitterPanel;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "TREE_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("TREE_NODES"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTERS"));
        this.addAnchoredComponent(jLabel2, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_leavesOnly.setText(DM4JResourceUtilities.getUIString("TREE_LEAVES_ONLY"));
        this.m_leavesOnly.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TREE_LEAVES_ONLY"));
        this.m_leavesOnly.setSelected(false);
        this.m_leavesOnly.setEnabled(false);
        this.addAnchoredComponent(this.m_leavesOnly, TOPLABELITEMINSETS, n, 1, 1, 1, 16);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        this.m_levels = new JSpinner(spinnerNumberModel);
        this.m_levelsLabel = new JLabel(DM4JResourceUtilities.getUIString("TREE_SHOW_LEVELS"));
        this.addComponent(new JLabel(""), TOPLABELITEMINSETS, n, 3, 2, 1, 14, 2);
        int n2 = 5;
        this.addComponent(this.m_levelsLabel, TOPLABELITEMINSETS, n, n2++, 1, 1, 14, 2);
        this.addComponent(this.m_levels, new Insets(0, 1, 0, 1), n, n2++, 1, 1, 14, 0);
        this.m_expand = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/expandall.gif"));
        this.m_expand.setToolTipText(DM4JResourceUtilities.getUIString("TREE_EXPAND_ALL"));
        this.m_expand.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TREE_EXPAND_ALL"));
        this.m_expand.setEnabled(false);
        this.addComponent(this.m_expand, new Insets(0, 1, 0, 1), n, n2++, 1, 1, 14, 2);
        this.m_collapse = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/collapseall.gif"));
        this.m_collapse.setToolTipText(DM4JResourceUtilities.getUIString("TREE_COLLAPSE_ALL"));
        this.m_collapse.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TREE_COLLAPSE_ALL"));
        this.m_collapse.setEnabled(false);
        this.addComponent(this.m_collapse, new Insets(0, 1, 0, 1), n, n2++, 1, 1, 14, 0);
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.setEnabled(false);
        this.addComponent(this.m_exportButton, new Insets(0, 1, 0, 10), n++, n2++, 1, 1, 14, 0);
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        int n = DecisionTreePanel.this.m_tableModel.getExpandedRowCount();
                        for (int i = 0; i < n; ++i) {
                            DecisionTreePanel.this.m_tableModel.expandExpandedRow(i);
                        }
                        exportDialog.export(DecisionTreePanel.this.m_nodesTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_nodesTable = this.createTable();
        this.m_nodesPane.getViewport().add((Component)((Object)this.m_nodesTable));
        this.addFilledComponent(this.m_nodesPane, MIDLABELITEMINSETS, n, 0, n2++, 5, 1);
        jLabel2.setLabelFor((Component)((Object)this.m_nodesTable));
    }

    private void runTimePanelLoad() throws Exception {
        this.m_leavesOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DecisionTreePanel.this.chkLeavesOnly_actionPerformed(actionEvent);
            }
        });
        this.m_expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DecisionTreePanel.this.m_tableModel.getExpandedRowCount();
                for (int i = 0; i < n; ++i) {
                    DecisionTreePanel.this.m_tableModel.expandExpandedRow(i);
                }
            }
        });
        this.m_collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DecisionTreePanel.this.m_tableModel.getExpandedRowCount();
                for (int i = 0; i < n; ++i) {
                    DecisionTreePanel.this.m_tableModel.collapseExpandedRow(i);
                }
            }
        });
        this.m_levels.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                browserFrame.setCursor(new Cursor(3));
                int n = (Integer)DecisionTreePanel.this.m_levels.getValue();
                ArrayList arrayList = DecisionTreePanel.this.m_tableModel.getNodes();
                for (int i = 0; i < arrayList.size(); ++i) {
                    TreeNode treeNode = (TreeNode)arrayList.get(i);
                    int n2 = treeNode.getLevel();
                    if (n2 >= n) {
                        DecisionTreePanel.this.m_tableModel.collapseExpandedRow(i);
                        continue;
                    }
                    DecisionTreePanel.this.m_tableModel.expandExpandedRow(i);
                }
                browserFrame.setCursor(new Cursor(0));
            }
        });
        this.loadNodes();
        int[] nArray = new int[]{100};
        this.m_nodesTable.setColumnWidths(nArray, true);
        this.m_targetAttribName.setText(this.m_miningModel.getTargetAttributeName());
    }

    private void loadNodes() throws Exception {
        TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
        TreeNode treeNode = treeModelDetail.getRootNode();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadTreeNodesWorker loadTreeNodesWorker = (LoadTreeNodesWorker)workerThreadManager.getLoadTreeNodesWorker(treeNode, this.m_miningModel, this.m_leavesOnly.isSelected());
        loadTreeNodesWorker.addTreeNodesLoadedListener(this);
        loadTreeNodesWorker.start();
    }

    public void nodesLoaded(EventObject eventObject) {
        Object object;
        this.m_tableModel = (TreeNodeTableModel)((Object)eventObject.getSource());
        int n = this.m_tableModel.getColumnCount();
        String[] stringArray = new String[]{DM4JResourceUtilities.getUIString("TREE_HEADER_NODE_ID"), DM4JResourceUtilities.getUIString("TREE_HEADER_PREDICATE"), DM4JResourceUtilities.getUIString("TREE_HEADER_PREDICTED_VALUE"), DM4JResourceUtilities.getUIString("TREE_HEADER_CONFIDENCE"), DM4JResourceUtilities.getUIString("TREE_HEADER_CASES"), DM4JResourceUtilities.getUIString("TREE_HEADER_SUPPORT")};
        Object[] objectArray = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = stringArray[i];
        }
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        if (this.m_leavesOnly.isSelected()) {
            this.m_sortableModel = this.m_tableModel.getSortableLeafTable();
            this.m_nodesTable.setModels((TwoDModel)this.m_sortableModel, arrayOneDModel, null);
        } else {
            this.m_nodesTable.setModels((TwoDModel)this.m_tableModel, arrayOneDModel, null);
        }
        this.m_nodesTable.setSortOn(this.m_leavesOnly.isSelected());
        Grid grid = this.m_nodesTable.getGrid();
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 0);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(true, 4, 4);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(numberFormat2);
        TruncatingTextPainter truncatingTextPainter = new TruncatingTextPainter();
        grid.setColumnPainter(1, (Painter)truncatingTextPainter);
        grid.setColumnPainter(2, (Painter)truncatingTextPainter);
        grid.setColumnPainter(3, (Painter)dM4JTruncatingNumberFormatPainter2);
        grid.setColumnPainter(4, (Painter)dM4JTruncatingNumberFormatPainter);
        grid.setColumnPainter(5, (Painter)dM4JTruncatingNumberFormatPainter2);
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(0, (Painter)hCellHandler);
        grid.setColumnCellInputHandler(0, (CellInputHandler)hCellHandler);
        if (this.m_tableModel.getRowCount() != 0) {
            object = new TwoDSelection(0, true);
            try {
                this.m_nodesTable.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = null;
        object = new int[]{20, 30, 13, 13, 11, 11};
        try {
            this.m_nodesTable.setColumnWidths((int[])object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_leavesOnly.setEnabled(true);
        this.m_expand.setEnabled(true);
        this.m_collapse.setEnabled(true);
        this.m_exportButton.setEnabled(true);
        int n2 = this.m_tableModel.getLevels();
        this.m_levels.setModel(new SpinnerNumberModel(0, 0, n2, 1));
        this.m_levels.setValue(new Integer(n2));
    }

    private RulesSpreadTable createTable() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        Object[] objectArray = new String[]{DM4JResourceUtilities.getUIString("TREE_NODES")};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(1, 1);
        arrayTwoDModel.setData(0, 0, (Object)DM4JResourceUtilities.getUIString("COMMON_LOADING"));
        RulesSpreadTable rulesSpreadTable = new RulesSpreadTable(null);
        rulesSpreadTable.setModels((TwoDModel)arrayTwoDModel, arrayOneDModel, null);
        Grid grid = rulesSpreadTable.getGrid();
        grid.setGridKeyHandler((GridKeyHandler)new HGridKeyHandler(grid));
        grid.setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
        grid.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DecisionTreePanel.this.btnDetails_actionPerformed(null);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        generalGridSelectionManager.addVetoableChangeListener((VetoableChangeListener)this);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(rulesSpreadTable);
        return rulesSpreadTable;
    }

    private void chkLeavesOnly_actionPerformed(ActionEvent actionEvent) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(3));
        boolean bl = !this.m_leavesOnly.isSelected();
        this.m_levels.setVisible(bl);
        this.m_levelsLabel.setVisible(bl);
        this.m_expand.setVisible(bl);
        this.m_collapse.setVisible(bl);
        this.m_leavesOnly.setEnabled(false);
        this.m_expand.setEnabled(false);
        this.m_collapse.setEnabled(false);
        this.m_exportButton.setEnabled(false);
        try {
            this.loadNodes();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        browserFrame.setCursor(new Cursor(0));
    }

    private void btnDetails_actionPerformed(ActionEvent actionEvent) {
        TreeNode treeNode;
        Serializable serializable;
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(3));
        TwoDSelection twoDSelection = this.m_nodesTable.getSelection();
        int n = twoDSelection.getSingleRow();
        if (this.m_leavesOnly.isSelected()) {
            TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
            serializable = (Integer)this.m_sortableModel.getData(0, n);
            try {
                treeNode = treeModelDetail.getNode((Integer)serializable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        } else {
            int n2 = this.m_tableModel.getExpandedIndex(n);
            serializable = this.m_tableModel.getNodes();
            treeNode = (TreeNode)((ArrayList)serializable).get(n2);
        }
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(0);
        serializable = new Graph((ErrorHandler)defaultErrorHandler);
        serializable.setLocale(Locale.getDefault());
        serializable.setGraphType(17);
        serializable.setAutoLayout(2);
        serializable.getPFJ().setDisplay(serializable.getPFJ().getLegendArea(), false);
        TreeNodeDetailPane treeNodeDetailPane = new TreeNodeDetailPane(this.m_miningModel, treeNode, (Graph)serializable);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(treeNodeDetailPane);
        jFrame.setSize(600, 250);
        jFrame.setTitle(DM4JResourceUtilities.getUIString("TREE_MODEL2") + this.m_miningModel.getName() + " : " + DM4JResourceUtilities.getUIString("TREE_NODE_ID") + treeNode.getIdentifier());
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        jFrame.setIconImage(imageIcon.getImage());
        WindowUtils.centerWindow((Window)jFrame);
        jFrame.setVisible(true);
        browserFrame.setCursor(new Cursor(0));
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        Integer n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection.getSingleRow();
        if (n2 == -1) {
            return;
        }
        if (this.m_leavesOnly.isSelected()) {
            n = (Integer)this.m_sortableModel.getData(0, n2);
        } else {
            int n3 = this.m_tableModel.getExpandedIndex(n2);
            n = (Integer)((HDataObject)this.m_tableModel.getExpandedData(0, n3)).getData();
        }
        try {
            TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
            TreeNode treeNode = treeModelDetail.getNode(n);
            this.m_parent.loadDetailPane(treeNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadDetailPane(TwoDSelection twoDSelection) {
        int n = twoDSelection.getSingleRow();
        Integer n2 = (Integer)this.m_sortableModel.getData(0, n);
        TreeModelDetail treeModelDetail = (TreeModelDetail)this.m_miningModel.getModelDetail();
        try {
            TreeNode treeNode = treeModelDetail.getNode(n2);
            this.m_parent.loadDetailPane(treeNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class RulesSpreadTable
    extends DefaultDm4jSpreadTable {
        public static final String SORT_ACTION = "SORT";
        private boolean m_sortOn;

        public RulesSpreadTable(Object object) {
            super(object);
            this.m_sortOn = false;
        }

        public void setFirstRowSelection() {
            TwoDSelection twoDSelection = new TwoDSelection(0, true);
            try {
                this.setSelection(twoDSelection);
                DecisionTreePanel.this.loadDetailPane(twoDSelection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setModels(TwoDModel twoDModel, ArrayOneDModel arrayOneDModel, ArrayOneDModel arrayOneDModel2) {
            super.setModels(twoDModel, arrayOneDModel, arrayOneDModel2);
        }

        public void setSortOn(boolean bl) {
            this.m_sortOn = bl;
            Header header = this.getColumnHeader();
            if (this.m_sortOn) {
                header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
                header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(DecisionTreePanel.this.m_sortableModel));
            } else {
                header.setItemInputHandler((HeaderItemInputHandler)new InvalidSortHandler());
            }
            header.setCanMoveItems(false);
        }

        public boolean isSortOn() {
            return this.m_sortOn;
        }

        private class InvalidSortHandler
        implements HeaderItemInputHandler {
            public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
                JOptionPane.showOptionDialog(DecisionTreePanel.this.m_parent, DM4JResourceUtilities.getUIString("TREE_HEADER_ERROR_MESG"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            }

            public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            }
        }

        private class SortHandler
        implements HeaderItemInputHandler {
            SortableTwoDModel model = null;
            boolean sortOrder = true;
            final boolean ASCENDING = true;
            int sortColIndex = 0;

            public SortHandler(SortableTwoDModel sortableTwoDModel) {
                this.model = sortableTwoDModel;
            }

            public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
            }

            public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
                if (RulesSpreadTable.this.m_sortOn) {
                    this.sortColIndex = n;
                    this.sortOrder = !this.sortOrder;
                    this.model.sort(this.sortColIndex, this.sortOrder);
                    RulesSpreadTable.this.setFirstRowSelection();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            }
        }
    }
}

