/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Component;
import java.awt.EventQueue;
import javax.datamining.JDMException;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreeSplitterPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;

public class DecisionTreeModelViewer
extends ModelViewer {
    private static int TREE_TAB = 0;
    private static int RESULT_TAB = 1;
    private static int SETTING_TAB = 2;
    private static int TASK_TAB = 3;
    private int[] m_tabIndex;
    private DecisionTreeSplitterPanel m_treePanel;
    private BrowseResultsListPanel m_browseResultsListPanel;
    private ClassificationSettingsPanel m_settingsPanel;
    private BuildTaskPanel m_buildTaskPanel;
    private OraMiningBuildResult m_buldTask;
    private TreeNode m_nodeCache = null;

    public DecisionTreeModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    public void removeNotify() {
        super.removeNotify();
        this.m_nodeCache = null;
    }

    public TreeNode getRootNode() throws Exception {
        if (this.m_nodeCache != null) {
            return this.m_nodeCache;
        }
        ClassificationModel classificationModel = (ClassificationModel)this.getNode().getOdmObject();
        TreeModelDetail treeModelDetail = (TreeModelDetail)classificationModel.getModelDetail();
        this.m_nodeCache = treeModelDetail.getRootNode();
        return this.m_nodeCache;
    }

    public ClassificationModel getMiningModel() {
        return (ClassificationModel)this.getNode().getOdmObject();
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        OraModel oraModel = (OraModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[4];
        this.addTab(DM4JResourceUtilities.getUIString("TREE_NODES_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TREE_NODES_TAB"));
        this.m_tabIndex[n2++] = TREE_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RESULTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RESULTS"));
        this.m_tabIndex[n2++] = RESULT_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        Component panel;
        Exception exception = null;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TreeModelDetail treeModelDetail = null;
            TreeNode treeNode = null;
            this.panel = null;
            try {
                ClassificationModel classificationModel = (ClassificationModel)DecisionTreeModelViewer.this.m_node.getOdmObject();
                if (DecisionTreeModelViewer.this.m_tabIndex[this.tabIndex] == TREE_TAB) {
                    if (DecisionTreeModelViewer.this.m_treePanel == null) {
                        try {
                            treeModelDetail = (TreeModelDetail)classificationModel.getModelDetail();
                            treeNode = treeModelDetail.getRootNode();
                            DecisionTreeModelViewer.this.m_treePanel = new DecisionTreeSplitterPanel(classificationModel, treeNode);
                        }
                        catch (JDMException jDMException) {
                            jDMException.printStackTrace();
                            return;
                        }
                    }
                    this.panel = DecisionTreeModelViewer.this.m_treePanel;
                } else if (DecisionTreeModelViewer.this.m_tabIndex[this.tabIndex] == RESULT_TAB) {
                    if (DecisionTreeModelViewer.this.m_browseResultsListPanel == null) {
                        DecisionTreeModelViewer.this.m_browseResultsListPanel = new BrowseResultsListPanel(DecisionTreeModelViewer.this.m_node);
                    }
                    this.panel = DecisionTreeModelViewer.this.m_browseResultsListPanel;
                } else if (DecisionTreeModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (DecisionTreeModelViewer.this.m_settingsPanel == null) {
                        DecisionTreeModelViewer.this.m_settingsPanel = new ClassificationSettingsPanel((SupervisedModel)DecisionTreeModelViewer.this.m_node.getOdmObject(), DecisionTreeModelViewer.this.getNode());
                    }
                    this.panel = DecisionTreeModelViewer.this.m_settingsPanel;
                } else if (DecisionTreeModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (DecisionTreeModelViewer.this.m_buildTaskPanel == null) {
                        DecisionTreeModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(classificationModel.getName());
                    }
                    this.panel = DecisionTreeModelViewer.this.m_buildTaskPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        DecisionTreeModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                this.exception = exception;
                exception.printStackTrace();
            }
        }
    }
}

