/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.data.CategoryMatrix;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.results.test.ConfusionMatrixTable;

public class CostMatrixPanel
extends GriddedPanel {
    private String m_panelDescriptionResourceKey = null;
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private CategoryMatrix m_costMatrix = null;
    private ConfusionMatrixTable m_cmTable = null;

    public CostMatrixPanel(String string, CategoryMatrix categoryMatrix) throws Exception {
        this.m_panelDescriptionResourceKey = string;
        this.m_costMatrix = categoryMatrix;
        this.jbInit();
        this.runTimePanelLoad();
    }

    private void runTimePanelLoad() throws Exception {
        this.m_cmTable.load();
        this.m_cmTable.setResize(false);
        this.m_cmTable.setAutoResize(false);
        this.m_cmTable.setColumnWidths(75);
        this.m_cmTable.setDefaultColumnWidth(75);
    }

    private void jbInit() throws Exception {
        int n = 0;
        if (null != this.m_costMatrix) {
            JLabel jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("CLASS_COST_MATRIX_DESC"));
            this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
            JScrollPane jScrollPane = new JScrollPane();
            JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
            jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
            this.addAnchoredComponent(jButton, TOPLABELITEMINSETS, n++, 2, 1, 1, 14);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                        if (!exportDialog.isCancelled()) {
                            exportDialog.export(CostMatrixPanel.this.m_cmTable);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.m_cmTable = new ConfusionMatrixTable(this.m_costMatrix);
            this.m_cmTable.setShowFloats(true);
            jScrollPane.getViewport().add((Component)((Object)this.m_cmTable));
            jScrollPane.setPreferredSize(null);
            this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 0, 3, 2, 1);
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
            Grid grid = this.m_cmTable.getGrid();
            grid.setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_cmTable);
        }
    }
}

